/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import java.net.URI;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface GraphQlClientBuilder {
    public static GraphQlClientBuilder newBuilder() {
        ServiceLoader<GraphQlClientBuilder> loader = ServiceLoader.load(GraphQlClientBuilder.class);
        Iterator<GraphQlClientBuilder> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ServiceConfigurationError("no " + GraphQlClientBuilder.class.getName() + " in classpath");
        }
        GraphQlClientBuilder graphQlClientBuilder = iterator.next();
        if (iterator.hasNext()) {
            throw new ServiceConfigurationError("more than one " + GraphQlClientBuilder.class.getName() + " in classpath");
        }
        return graphQlClientBuilder;
    }

    public GraphQlClientBuilder configKey(String var1);

    default public GraphQlClientBuilder endpoint(String endpoint) {
        return this.endpoint(URI.create(endpoint));
    }

    public GraphQlClientBuilder endpoint(URI var1);

    public <T> T build(Class<T> var1);

    public GraphQlClientBuilder register(Object var1);

    public GraphQlClientBuilder register(Class<?> var1);
}

