/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.pipeline;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.pipeline.MessagePipeline;

public class BasicMessagePipeline
implements MessagePipeline {
    private MessageEncoder encoder;
    private MessageDecoder decoder;
    private MessageHandler outboundPayloadHandler;
    private MessageHandler outboundTransportHandler;
    private MessageHandler inboundHandler;

    public BasicMessagePipeline(@Nonnull MessageEncoder newEncoder, @Nonnull MessageDecoder newDecoder) {
        this.setEncoder(newEncoder);
        this.setDecoder(newDecoder);
    }

    @Override
    public MessageEncoder getEncoder() {
        return this.encoder;
    }

    protected void setEncoder(@Nonnull MessageEncoder newEncoder) {
        this.encoder = (MessageEncoder)Constraint.isNotNull((Object)newEncoder, (String)"MessageEncoder can not be null");
    }

    @Override
    public MessageDecoder getDecoder() {
        return this.decoder;
    }

    protected void setDecoder(@Nonnull MessageDecoder newDecoder) {
        this.decoder = (MessageDecoder)Constraint.isNotNull((Object)newDecoder, (String)"MessageDecoder can not be null");
    }

    @Override
    public MessageHandler getOutboundPayloadMessageHandler() {
        return this.outboundPayloadHandler;
    }

    public void setOutboundPayloadHandler(@Nullable MessageHandler handler) {
        this.outboundPayloadHandler = handler;
    }

    @Override
    public MessageHandler getOutboundTransportMessageHandler() {
        return this.outboundTransportHandler;
    }

    public void setOutboundTransportHandler(MessageHandler handler) {
        this.outboundTransportHandler = handler;
    }

    @Override
    public MessageHandler getInboundMessageHandler() {
        return this.inboundHandler;
    }

    public void setInboundHandler(MessageHandler handler) {
        this.inboundHandler = handler;
    }
}

