/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InitialRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient TraceComponent tc = Tr.register(InitialRequest.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    String reqUrl = null;
    String requestURL = null;
    String method = null;
    String strInResponseToId;
    boolean isFormLogoutExitPage = false;
    String formLogoutExitPage = null;
    String postParams = "";
    HashMap savedPostParams = null;
    public static final String ATTRIB_HASH_MAP = "ServletRequestWrapperHashmap";
    public static final String COOKIE_NAME_SAVED_PARAMS = "WASSamlParams_IR_";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_GET = "GET";
    public static final int LENGTH_INT = 4;
    private static final int OFFSET_DATA = 1;
    private static final Charset CHARSET_NAME = StandardCharsets.UTF_8;
    private static final int postParamSaveSize = 16000;

    /*
     * WARNING - void declaration
     */
    public InitialRequest(HttpServletRequest request, String reqUrl, String requestURL, String method, String inResponseTo, String formlogout, HashMap savedPostParams) throws SamlException {
        this.reqUrl = reqUrl;
        this.requestURL = requestURL;
        this.method = method;
        this.strInResponseToId = inResponseTo;
        this.formLogoutExitPage = formlogout;
        if (this.formLogoutExitPage != null) {
            this.isFormLogoutExitPage = true;
        }
        if (METHOD_POST.equalsIgnoreCase(this.method) && this.formLogoutExitPage == null) {
            try {
                this.savedPostParams = savedPostParams;
                this.postParams = this.serializePostParams((IExtendedRequest)request);
            }
            catch (IOException | IllegalStateException exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.internal.utils.InitialRequest", (String)"80", (Object)this, (Object[])new Object[]{request, reqUrl, requestURL, method, inResponseTo, formlogout, savedPostParams});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"An exception getting InputStreamData : ", (Object[])new Object[]{e});
                }
                throw new SamlException((Exception)e);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Request: method (" + this.method + ") savedParams:" + this.savedPostParams), (Object[])new Object[0]);
        }
    }

    public String getFormLogoutExitPage() {
        return this.formLogoutExitPage;
    }

    public String getInResponseToId() {
        return this.strInResponseToId;
    }

    public String getRequestUrl() {
        return this.reqUrl;
    }

    public String getRequestUrlWithEncodedQueryString() {
        return this.requestURL;
    }

    public String getMethod() {
        return this.method;
    }

    public HashMap getPostParamsMap() {
        return this.savedPostParams;
    }

    /*
     * WARNING - void declaration
     */
    public void setPostParamsMap(HttpServletRequest request) {
        block3: {
            if (METHOD_POST.equalsIgnoreCase(this.method) && this.formLogoutExitPage == null) {
                try {
                    this.savedPostParams = this.deserializePostParams(this.postParams.getBytes(CHARSET_NAME), (IExtendedRequest)request);
                }
                catch (IOException | IllegalStateException exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.internal.utils.InitialRequest", (String)"120", (Object)this, (Object[])new Object[]{request});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"An exception getting InputStreamData : ", (Object[])new Object[]{e});
                }
            }
        }
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        this.reqUrl = aInputStream.readUTF();
        this.requestURL = aInputStream.readUTF();
        this.method = aInputStream.readUTF();
        this.strInResponseToId = aInputStream.readUTF();
        this.isFormLogoutExitPage = aInputStream.readBoolean();
        if (this.isFormLogoutExitPage) {
            this.formLogoutExitPage = aInputStream.readUTF();
        } else if (METHOD_POST.equalsIgnoreCase(this.method)) {
            this.formLogoutExitPage = null;
            this.postParams = aInputStream.readUTF();
        }
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.writeUTF(this.reqUrl);
        aOutputStream.writeUTF(this.requestURL);
        aOutputStream.writeUTF(this.method);
        aOutputStream.writeUTF(this.strInResponseToId);
        aOutputStream.writeBoolean(this.isFormLogoutExitPage);
        if (this.isFormLogoutExitPage) {
            aOutputStream.writeUTF(this.formLogoutExitPage);
        } else if (METHOD_POST.equalsIgnoreCase(this.method)) {
            aOutputStream.writeUTF(this.postParams);
        }
    }

    public String serializePostParams(IExtendedRequest req) throws IOException, IllegalStateException {
        String output = null;
        if (this.savedPostParams != null) {
            long size = req.sizeInputStreamData((Map)this.savedPostParams);
            long total = size + 4L;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("length:" + total + "  maximum length:" + 16000), (Object[])new Object[0]);
            }
            if (total < 16000L) {
                byte[][] data = req.serializeInputStreamData((Map)this.savedPostParams);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < data.length; ++i) {
                    if (i != 0) {
                        sb.append(".");
                    }
                    sb.append(InitialRequest.toStringFromByteArray(Base64Coder.base64Encode((byte[])data[i])));
                }
                output = sb.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("encoded length:" + output.length()), (Object[])new Object[0]);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("encoded POST parameters: " + output), (Object[])new Object[0]);
            }
        }
        return output;
    }

    private HashMap deserializePostParams(byte[] paramsbytes, IExtendedRequest req) throws IOException, IllegalStateException {
        byte[][] bytes;
        HashMap output = null;
        List<byte[]> data = this.splitBytes(paramsbytes, (byte)46);
        int total = data.size();
        if (total >= 1) {
            bytes = new byte[total][];
            for (int i = 0; i < total; ++i) {
                bytes[i] = Base64Coder.base64Decode((byte[])data.get(i));
            }
        } else {
            throw new IllegalStateException("The data of the post param cookie is too short. The data might be truncated.");
        }
        output = req.deserializeInputStreamData((byte[][])bytes);
        return output;
    }

    private List<byte[]> splitBytes(byte[] array, byte delimiter) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        int begin = 0;
        for (int i = 0; i < array.length; ++i) {
            while (i < array.length && array[i] != delimiter) {
                ++i;
            }
            byteArrays.add(Arrays.copyOfRange(array, begin, i));
            begin = i + 1;
        }
        return byteArrays;
    }

    public static String toStringFromByteArray(byte[] b) {
        StringBuffer sb = new StringBuffer();
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            sb.append((char)(b[i] & 0xFF));
        }
        String str = sb.toString();
        return str;
    }
}

