/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

public final class MultiCollectorOp<T, A, R>
extends AbstractMultiOperator<T, R> {
    private final Collector<? super T, A, ? extends R> collector;
    private final boolean acceptNullAsInitialValue;

    public MultiCollectorOp(Multi<T> upstream, Collector<? super T, A, ? extends R> collector, boolean acceptNullAsInitialValue) {
        super(upstream);
        this.collector = collector;
        this.acceptNullAsInitialValue = acceptNullAsInitialValue;
    }

    @Override
    public void subscribe(MultiSubscriber<? super R> downstream) {
        Function<A, ? extends R> finisher;
        BiConsumer<A, ? super T> accumulator;
        A initialValue;
        try {
            initialValue = this.collector.supplier().get();
            accumulator = this.collector.accumulator();
            finisher = this.collector.finisher();
        }
        catch (Throwable ex) {
            Subscriptions.fail(downstream, ex, this.upstream);
            return;
        }
        if (initialValue == null && !this.acceptNullAsInitialValue) {
            Subscriptions.fail(downstream, new NullPointerException("The supplier returned `null`"), this.upstream);
            return;
        }
        if (accumulator == null) {
            Subscriptions.fail(downstream, new NullPointerException("`accumulator` must not be `null`"), this.upstream);
            return;
        }
        CollectorProcessor<? super T, A, ? extends R> processor = new CollectorProcessor<T, A, R>(downstream, initialValue, accumulator, finisher);
        this.upstream.subscribe().withSubscriber(processor);
    }

    static class CollectorProcessor<T, A, R>
    extends MultiOperatorProcessor<T, R> {
        private final BiConsumer<A, T> accumulator;
        private final Function<A, R> finisher;
        private A intermediate;

        CollectorProcessor(MultiSubscriber<? super R> downstream, A initialValue, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(downstream);
            this.intermediate = initialValue;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public void onItem(T item) {
            if (this.getUpstreamSubscription() != EmptyUniSubscription.CANCELLED) {
                try {
                    this.accumulator.accept(this.intermediate, item);
                }
                catch (Throwable ex) {
                    this.failAndCancel(ex);
                }
            }
        }

        @Override
        public void onCompletion() {
            Flow.Subscription subscription = this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED);
            if (subscription != Subscriptions.CANCELLED) {
                R result;
                MultiSubscriber subscriber = this.downstream;
                try {
                    result = this.finisher.apply(this.intermediate);
                }
                catch (Throwable ex) {
                    subscriber.onFailure(ex);
                    return;
                }
                this.intermediate = null;
                if (result != null) {
                    subscriber.onItem(result);
                }
                subscriber.onCompletion();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onFailure(Subscriptions.getInvalidRequestException());
            } else {
                super.request(Long.MAX_VALUE);
            }
        }
    }
}

