/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transport.netty.SipMessageEvent;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;

public final class SipMessageBufferDatagramDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private static final TraceComponent tc = Tr.register(SipMessageBufferDatagramDecoder.class);

    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf content = (ByteBuf)packet.content();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("new packet length: " + content.readableBytes() + " for datagram: " + packet), (Object[])new Object[0]);
        }
        if (content.readableBytes() < 20) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"ignoring message with length less than 20", (Object[])new Object[0]);
            }
            return;
        }
        byte[] b = new byte[content.readableBytes()];
        content.getBytes(0, b);
        SipMessageByteBuffer data = SipMessageByteBuffer.fromPool();
        data.put(b, 0, b.length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("new SipMessageByteBuffer length: " + data.getMarkedBytesNumber()), (Object[])new Object[0]);
        }
        SipMessageEvent sipEvent = new SipMessageEvent(data, (InetSocketAddress)packet.sender());
        out.add(sipEvent);
    }
}

