/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.ws.jain.protocol.ip.sip.address.AddressFactoryImpl;
import com.ibm.ws.jain.protocol.ip.sip.address.NameAddressImpl;
import com.ibm.ws.jain.protocol.ip.sip.address.URIImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersImpl;
import com.ibm.ws.sip.parser.Coder;
import com.ibm.ws.sip.parser.Lexer;
import com.ibm.ws.sip.parser.Separators;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.parser.util.LRUStringCache;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import java.util.HashMap;

public class SipParser
extends Lexer
implements Separators {
    private static final char[] s_userNameSeparators = new char[]{':', '@'};
    private static final char[] s_hostNameSeparators = new char[]{':', ';', '>', ' ', '?'};
    private boolean m_unescape;
    private boolean m_parseHeaderParameters;

    public SipParser(boolean unescape) {
        this.m_unescape = unescape;
    }

    public SipParser() {
        this(true);
    }

    public void setParseHeaderParameters(boolean headerParameters) {
        this.m_parseHeaderParameters = headerParameters;
    }

    public ParametersImpl parseParametersMap(char separator, boolean escaped, boolean uri) throws SipParseException {
        ParametersImpl params = new ParametersImpl();
        while (true) {
            String value;
            boolean quote;
            this.lws();
            String key = uri ? this.sipUriParam() : this.sipToken();
            if (key.length() == 0) {
                throw new SipParseException("Expected parameter key", this.toString());
            }
            this.lws();
            if (this.LA(1) == '=') {
                this.match('=');
                this.lws();
                if (this.LA(1) == '\"') {
                    quote = true;
                    value = this.quotedString();
                    this.lws();
                } else {
                    quote = false;
                    value = uri ? this.sipUriParam() : this.sipParam();
                    this.lws();
                }
            } else {
                quote = false;
                value = "";
            }
            if (escaped && this.m_unescape) {
                value = Coder.decode(value);
            }
            params.setParameter(key, value, quote);
            if (this.LA(1) != separator) break;
            this.match(separator);
        }
        return params;
    }

    public String quotedStringWithQuotes() throws SipParseException {
        LRUStringCache cache = LRUStringCache.getInstance();
        CharsBuffer buf = CharsBuffersPool.getBuffer();
        buf.append('\"');
        buf.append(this.quotedString());
        buf.append('\"');
        String ret = cache.get(buf.getCharArray(), 0, buf.getCharCount());
        CharsBuffersPool.putBufferBack(buf);
        return ret;
    }

    public NameAddress parseNameAddress() throws SipParseException {
        String name = null;
        URI address = null;
        CharsBuffer buff = CharsBuffersPool.getBuffer();
        int i = 1;
        while (this.LA(i) != '\u0000' && address == null) {
            char n = this.LA(i);
            switch (n) {
                case '<': {
                    buff.rtrim();
                    LRUStringCache cache = LRUStringCache.getInstance();
                    name = cache.get(buff.getCharArray(), 0, buff.getCharCount());
                    this.consume(i - 1);
                    address = this.parseURIwithBrackets();
                    break;
                }
                case '\"': {
                    this.consume(i - 1);
                    name = this.quotedString();
                    this.lws();
                    address = this.parseURIwithBrackets();
                    break;
                }
                case ':': {
                    address = this.parseURI();
                    break;
                }
                default: {
                    buff.append(n);
                }
            }
            ++i;
        }
        CharsBuffersPool.putBufferBack(buff);
        if (address == null) {
            throw new SipParseException("the address syntax is bad ");
        }
        NameAddressImpl nameAddress = new NameAddressImpl();
        if (name != null && name.length() > 0) {
            nameAddress.setDisplayName(name);
        }
        nameAddress.setAddress(address);
        return nameAddress;
    }

    public URI parseURIwithBrackets() throws SipParseException {
        this.match('<');
        URI uri = this.parseURI(true);
        this.match('>');
        this.lws();
        return uri;
    }

    public URI parseURI(boolean uriWithBrackets) throws SipParseException {
        String scheme = this.nextToken(':');
        this.match(':');
        return this.parseURI(scheme, uriWithBrackets);
    }

    public URI parseURI() throws SipParseException {
        return this.parseURI(false);
    }

    public URI parseURI(String scheme) throws SipParseException {
        return this.parseURI(scheme, false);
    }

    public URI parseURI(String scheme, boolean uriWithBrackets) throws SipParseException {
        if (scheme.equalsIgnoreCase("SIP") || scheme.equalsIgnoreCase("SIPS")) {
            return this.parseSipURLInternally(scheme, uriWithBrackets);
        }
        if (scheme.equalsIgnoreCase("TEL")) {
            return this.parseTelURLInternally(scheme, uriWithBrackets);
        }
        if (scheme.length() < 1) {
            throw new SipParseException("empty scheme in URI");
        }
        if (!Character.isLetter(scheme.charAt(0))) {
            throw new SipParseException(scheme, "expected letter in scheme but found [" + scheme.charAt(0) + ']');
        }
        for (int i = scheme.length() - 1; i > 0; --i) {
            char c = scheme.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.') continue;
            throw new SipParseException(scheme, "expected letter/digit/+/-/. in scheme but found [" + c + ']');
        }
        URIImpl url = new URIImpl(scheme);
        String data = null;
        data = !uriWithBrackets && this.m_parseHeaderParameters ? (this.find(';') != -1 ? this.nextToken(';') : this.nextToken('?')) : this.nextToken('>');
        if (this.m_unescape) {
            data = Coder.decode(data);
        }
        url.setSchemeData(data);
        return url;
    }

    private URI parseTelURLInternally(String scheme, boolean uriWithBrackets) throws SipParseException {
        boolean isGlobal;
        String uri = null;
        if (uriWithBrackets) {
            uri = this.nextToken('>');
            if (this.LA() == '>') {
                this.consume();
            }
        } else {
            uri = this.nextToken(';');
        }
        String headerParams = this.nextToken(' ');
        URIImpl retUrl = new URIImpl(scheme);
        String data = null;
        String url = uri + headerParams;
        if (uri.isEmpty()) {
            throw new SipParseException("null URL");
        }
        int length = url.length();
        int position = this.parseIsGlobal(url);
        boolean bl = isGlobal = position != 0;
        if (position >= length) {
            throw new SipParseException("unexpected end of URL [" + url + ']');
        }
        position = this.parsePhoneNumber(url, position, isGlobal);
        if (!this.m_parseHeaderParameters || uriWithBrackets) {
            position = this.parseParam(uri, position);
        }
        data = uri;
        if ((position += headerParams.length()) != length) {
            throw new SipParseException("unexpected character in URL [" + url + "] at position [" + position + ']');
        }
        if (this.m_unescape) {
            data = Coder.decode(data);
        }
        this.rewind();
        if (uriWithBrackets) {
            this.nextToken('>');
        } else {
            this.nextToken(';');
        }
        retUrl.setSchemeData(data);
        return retUrl;
    }

    private int parseIsGlobal(String url) throws SipParseException {
        boolean isGlobal;
        boolean bl = isGlobal = url.charAt(0) == '+';
        if (isGlobal) {
            return 1;
        }
        return 0;
    }

    private int parsePhoneNumber(String url, int position, boolean isGlobal) throws SipParseException {
        int i;
        int length = url.length();
        block4: for (i = position; i < length; ++i) {
            char c = url.charAt(i);
            switch (c) {
                case '#': 
                case '(': 
                case ')': 
                case '*': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'P': 
                case 'W': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'p': 
                case 'w': {
                    continue block4;
                }
                case 'E': 
                case 'F': 
                case 'e': 
                case 'f': {
                    if (!isGlobal) continue block4;
                    throw new SipParseException("invalid number in tel URL [" + url + ']');
                }
            }
        }
        if (i == position) {
            throw new SipParseException("invalid number in tel URL [" + url + ']');
        }
        return i;
    }

    private int parseParam(String url, int position) throws SipParseException {
        String name;
        char c;
        HashMap<String, String> params = new HashMap<String, String>();
        int length = url.length();
        int i = position;
        while (i < length && (c = url.charAt(i)) == ';' && (name = SipParser.token(url, ++i)) != null) {
            String value;
            if ((i += name.length()) < length) {
                c = url.charAt(i);
                if (c == '=') {
                    if ((value = SipParser.token(url, ++i)) == null) break;
                    i += value.length();
                } else {
                    value = "";
                }
            } else {
                value = "";
            }
            if (params.get(name) == null) {
                params.put(name, value);
                continue;
            }
            throw new SipParseException("duplicate parameter [" + name + "] in URL [" + url + ']');
        }
        return i;
    }

    private static String token(String url, int position) {
        char c;
        int i;
        int length = url.length();
        for (i = position; i < length && ((c = url.charAt(i)) == '!' || '#' <= c && c <= '\'' || '*' <= c && c <= '+' || '-' <= c && c <= '.' || '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || '^' <= c && c <= 'z' || c == '|' || c == '~'); ++i) {
        }
        if (i == position) {
            return null;
        }
        return url.substring(position, i);
    }

    public SipURL parseSipURL(String scheme, boolean uriWithBrackets) throws SipParseException {
        if (!scheme.equalsIgnoreCase("SIP") && !scheme.equalsIgnoreCase("SIPS")) {
            throw new SipParseException("Sip url must have a sip or sips scheme", "");
        }
        return this.parseSipURLInternally(scheme, uriWithBrackets);
    }

    private SipURL parseSipURLInternally(String scheme, boolean uriWithBrackets) throws SipParseException {
        SipURL url = null;
        String userName = null;
        String password = null;
        int portNum = 0;
        String userType = null;
        String hostname = null;
        ParametersImpl params = null;
        ParametersImpl headers = null;
        if (this.find('@') != -1) {
            userName = this.nextToken(s_userNameSeparators);
            if (this.m_unescape) {
                userName = Coder.decode(userName);
            }
            if (userName == null || userName.length() == 0) {
                throw new SipParseException("expected user name");
            }
            if (this.LA(1) == ':') {
                this.match(':');
                password = this.nextToken('@');
                if (password.indexOf(58) != -1) {
                    throw new SipParseException("password contains a colon");
                }
                if (this.m_unescape) {
                    password = Coder.decode(password);
                }
            }
            this.match('@');
            userType = userName.indexOf(35) >= 0 || userName.indexOf(59) >= 0 ? "phone" : "ip";
        }
        boolean isIpv6 = false;
        if (this.LA() == '[') {
            this.consume();
            hostname = this.nextToken(']');
            this.consume();
            isIpv6 = true;
        } else {
            hostname = this.nextToken(s_hostNameSeparators);
            if (this.m_unescape) {
                hostname = Coder.decode(hostname);
            }
        }
        if (hostname == null || hostname.length() == 0) {
            throw new SipParseException("missing hostname");
        }
        if (!isIpv6 && !SipParser.isHostname(hostname)) {
            throw new SipParseException("invalid hostname [" + hostname + ']', "");
        }
        if (this.LA(1) == ':') {
            this.match(':');
            portNum = this.number();
        }
        this.lws();
        if (this.m_parseHeaderParameters && !uriWithBrackets) {
            url = AddressFactoryImpl.createSipURL(scheme, userName, password, hostname, portNum, params, headers, userType, null);
            return url;
        }
        if (this.LA(1) == ';') {
            this.match(';');
            params = this.parseParametersMap(';', true, true);
        }
        if (this.LA(1) == '?') {
            this.match('?');
            headers = this.parseParametersMap('&', true, false);
        }
        url = AddressFactoryImpl.createSipURL(scheme, userName, password, hostname, portNum, params, headers, userType, null);
        return url;
    }

    public String parseSipVersion(char delim) throws SipParseException {
        if (this.LA(1) == '2' && this.LA(2) == '.' && this.LA(3) == '0' && !Character.isDigit(this.LA(4))) {
            this.consume(3);
            return "2.0";
        }
        String unknownVersion = this.nextToken(delim);
        throw new SipParseException("Unknown protocol version", unknownVersion);
    }

    public static boolean isHostname(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Coder.isAlphanum(c) || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }
}

