/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.internal;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.appqueue.MessageDispatchingHandler;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.protocol.SipProtocolLayer;
import com.ibm.ws.sip.container.resolver.DomainResolverImpl;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.timer.BaseTimerService;
import com.ibm.ws.sip.container.was.WebsphereLauncherImpl;
import com.ibm.ws.sip.container.was.message.SipMessageFactory;
import com.ibm.ws.sip.stack.transport.GenericEndpointImpl;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import jain.protocol.ip.sip.SipStack;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={SipContainerComponent.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, configurationPid={"com.ibm.ws.sip.container.internal.SipContainerComponent"}, name="com.ibm.ws.sip.container.internal.SipContainerComponent", property={"service.vendor=IBM"})
public class SipContainerComponent {
    private static final LogMgr c_logger = Log.get(SipContainerComponent.class);
    private static final AtomicServiceReference<SipApplicationRouter> s_sipApplicationRouterSvcRef = new AtomicServiceReference("com.ibm.ws.sip.ar");
    private static MessageDispatchingHandler s_messageDispatchingHandlerSvc = null;
    private static BaseTimerService s_timerService;
    private static final AtomicServiceReference<SipStack> s_sipStackSvcRef;
    private static final AtomicServiceReference<PerformanceMgr> s_perfManager;
    private static final ConcurrentServiceReferenceSet<GenericEndpointImpl> genericEndpointRef;
    private static final ConcurrentServiceReferenceSet<SipMessageFactory> sipMessageFactoryRef;
    private static SipMessageFactory _sipMessageFactory;
    private static ComponentContext m_context;
    private WebsphereLauncherImpl wsl = new WebsphereLauncherImpl();
    private static DynamicVirtualHostManager _vhostManager;
    private static boolean s_initialized;
    private static final String USE_NETTY = "useNettyTransport";
    private static boolean useNetty;
    private static DomainResolverImpl _domainResolver;

    public static ComponentContext getContext() {
        return m_context;
    }

    protected void activate(ComponentContext context, Map<String, Object> properties) {
        block5: {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipContainerComponent activated", properties);
            }
            m_context = context;
            try {
                PropertiesStore.getInstance().getProperties().updateProperties(properties);
                this.initContainer();
            }
            catch (ParserConfigurationException e2) {
                if (!c_logger.isErrorEnabled()) break block5;
                c_logger.error("error.initialize.sip.container");
            }
        }
        boolean bl = useNetty = !ProductInfo.getBetaEdition() ? false : MetatypeUtils.parseBoolean((Object)"sipContainer", (String)USE_NETTY, (Object)properties.get(USE_NETTY), (boolean)true);
        if (c_logger.isTraceDebugEnabled() && useNetty) {
            c_logger.traceDebug("SipContainerComponent activate: useNetty=true");
        }
        if (c_logger.isTraceDebugEnabled() && ProductInfo.getBetaEdition() && !useNetty) {
            c_logger.traceDebug("SipContainerComponent activate: useNetty=false");
        }
        genericEndpointRef.activate(context);
        sipMessageFactoryRef.activate(context);
    }

    private void initContainer() throws ParserConfigurationException {
        this.wsl.init();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("initContainer done");
        }
    }

    protected void deactivate(int reason) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("SipContainerComponent deactivated, reason=" + reason, new Object[0]);
        }
        this.wsl.stop();
        s_sipStackSvcRef.deactivate(m_context);
        genericEndpointRef.deactivate(m_context);
        sipMessageFactoryRef.deactivate(m_context);
        s_perfManager.deactivate(m_context);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipContainerComponent modified", properties);
        }
        PropertiesStore.getInstance().getProperties().updateProperties(properties);
        boolean bl = useNetty = !ProductInfo.getBetaEdition() ? false : MetatypeUtils.parseBoolean((Object)"sipContainer", (String)USE_NETTY, (Object)properties.get(USE_NETTY), (boolean)true);
        if (c_logger.isTraceDebugEnabled() && useNetty) {
            c_logger.traceDebug("SipContainerComponent modified: useNetty=true");
        }
        if (c_logger.isTraceDebugEnabled() && ProductInfo.getBetaEdition() && !useNetty) {
            c_logger.traceDebug("SipContainerComponent activate: useNetty=false");
        }
    }

    @Reference(service=MessageDispatchingHandler.class, policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    public void setMessageDispatchingHandlerSvc(MessageDispatchingHandler messageDispatchingHandlerSvc) {
        s_messageDispatchingHandlerSvc = messageDispatchingHandlerSvc;
    }

    public void unsetMessageDispatchingHandlerSvc(MessageDispatchingHandler MessageDispatchingHandlerSvc) {
        if (s_messageDispatchingHandlerSvc == MessageDispatchingHandlerSvc) {
            s_messageDispatchingHandlerSvc = null;
        }
    }

    public static MessageDispatchingHandler getMessageDispatchingHandlerSvc() {
        return s_messageDispatchingHandlerSvc;
    }

    public static BaseTimerService getTimerService() {
        return s_timerService;
    }

    @Reference
    public void setTimerService(BaseTimerService timerService) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipContainerComponent setTimerService", timerService);
        }
        s_timerService = timerService;
    }

    public void unsetTimerService(BaseTimerService timerService) {
        if (timerService == s_timerService) {
            s_timerService = null;
        }
    }

    @Reference(name="com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHostMgr(DynamicVirtualHostManager vhostMgr) {
        _vhostManager = vhostMgr;
    }

    protected void unsetVirtualHostMgr(DynamicVirtualHostManager vhostMgr) {
        if (vhostMgr == _vhostManager) {
            _vhostManager = null;
        }
    }

    public static DynamicVirtualHostManager getVirtualHostMgr() {
        return _vhostManager;
    }

    @Reference(service=SipMessageFactory.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE, name="com.ibm.ws.sip.container.was.message.SipMessageFactory")
    protected void setSipMessageFactory(ServiceReference<SipMessageFactory> ref) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setSipMessageFactory", ref);
        }
        sipMessageFactoryRef.addReference(ref);
        SipContainerComponent.updateCurrentSipMessageFactory();
    }

    protected void unsetSipMessageFactory(ServiceReference<SipMessageFactory> ref) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("unsetSipMessageFactory", ref);
        }
        sipMessageFactoryRef.removeReference(ref);
        SipContainerComponent.updateCurrentSipMessageFactory();
    }

    private static synchronized void updateCurrentSipMessageFactory() {
        SipMessageFactory currentHighestFactory = (SipMessageFactory)sipMessageFactoryRef.getHighestRankedService();
        if (_sipMessageFactory != currentHighestFactory) {
            _sipMessageFactory = currentHighestFactory;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("updateCurrentSipMessageFactory updates SipMessageFactory", _sipMessageFactory);
            }
        }
    }

    public static SipMessageFactory getSipMessageFactory() {
        if (_sipMessageFactory == null) {
            SipContainerComponent.updateCurrentSipMessageFactory();
        }
        return _sipMessageFactory;
    }

    @Reference(service=PerformanceMgr.class, name="com.ibm.ws.sip.container.pmi", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setPerformanceManager(ServiceReference<PerformanceMgr> perfManager) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setPerformanceManager", perfManager);
        }
        s_perfManager.setReference(perfManager);
    }

    protected void unsetPerformanceManager(ServiceReference<PerformanceMgr> perfManager) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("unsetPerformanceManager", perfManager);
        }
        s_perfManager.unsetReference(perfManager);
    }

    @Reference(service=SipStack.class, name="com.ibm.ws.jain.protocol.ip.sip", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    public void setSipStack(ServiceReference<SipStack> sipStack) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setSipStack", sipStack);
        }
        s_sipStackSvcRef.setReference(sipStack);
    }

    @Reference(service=GenericEndpointImpl.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, name="com.ibm.ws.sip.endpoint")
    protected void setGenericEndpoint(ServiceReference<GenericEndpointImpl> ref) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setGenericEndpoint", ref);
        }
        genericEndpointRef.addReference(ref);
        if (SipProtocolLayer.getInstance().isInitialized()) {
            SipContainerComponent.startGenericEndpoints();
        }
    }

    protected void unsetGenericEndpoint(ServiceReference<GenericEndpointImpl> ref) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("unsetGenericEndpoint", ref);
        }
        genericEndpointRef.removeReference(ref);
    }

    private static Iterator<GenericEndpointImpl> getGenericEndpoints() {
        return genericEndpointRef.getServices();
    }

    public static void startGenericEndpoints() {
        Iterator<GenericEndpointImpl> gepi = SipContainerComponent.getGenericEndpoints();
        if (gepi == null || !gepi.hasNext()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("startGenericEndpoints", "GEP service was not set");
            }
        } else {
            while (gepi.hasNext()) {
                gepi.next();
            }
        }
    }

    public void unsetSipStackService(ServiceReference<SipStack> sipStackSvc) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("unsetSipStack", sipStackSvc);
        }
        s_sipStackSvcRef.unsetReference(sipStackSvc);
    }

    public static AtomicServiceReference<SipStack> getSipStackService() {
        return s_sipStackSvcRef;
    }

    public static void activateSipStack() {
        s_sipStackSvcRef.activate(m_context);
    }

    public static void activatePerfManager() {
        s_perfManager.activate(m_context);
    }

    @Reference(service=SipApplicationRouter.class, name="com.ibm.ws.sip.ar", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    public void setSipApplicationRouter(ServiceReference<SipApplicationRouter> sipApplicationRouter) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setSipApplicationRouter: " + sipApplicationRouter);
        }
        s_sipApplicationRouterSvcRef.setReference(sipApplicationRouter);
    }

    public void unsetSipApplicationRouter(ServiceReference<SipApplicationRouter> sipApplicationRouterSvc) {
        s_sipApplicationRouterSvcRef.unsetReference(sipApplicationRouterSvc);
    }

    public static SipApplicationRouter getSipApplicationRouter() {
        return (SipApplicationRouter)s_sipApplicationRouterSvcRef.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activateSipApplicationRouter() {
        if (s_sipApplicationRouterSvcRef.getReference() == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("activateSipApplicationRouter: no application router was found");
            }
            return;
        }
        Class<SipContainerComponent> clazz = SipContainerComponent.class;
        synchronized (SipContainerComponent.class) {
            if (s_initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            s_sipApplicationRouterSvcRef.activate(m_context);
            SipApplicationRouter sipAppRouter = (SipApplicationRouter)s_sipApplicationRouterSvcRef.getService();
            sipAppRouter.init(PropertiesStore.getInstance().getProperties().copyProps());
            sipAppRouter.init();
            SipRouter sipRouter = SipContainer.getInstance().getRouter();
            sipRouter.initialize(sipAppRouter);
            sipRouter.notifyRouterOnDeployedApps();
            s_initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Reference(service=DomainResolverImpl.class, policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    public void setDomainResolverService(DomainResolverImpl domainResolverSvc) {
        _domainResolver = domainResolverSvc;
    }

    public static DomainResolverImpl getDomainResolverService() {
        return _domainResolver;
    }

    public void unsetDomainResolverService(DomainResolverImpl domainResolverSvc) {
        _domainResolver = null;
    }

    public static boolean useNetty() {
        return useNetty;
    }

    static {
        s_sipStackSvcRef = new AtomicServiceReference("com.ibm.ws.jain.protocol.ip.sip");
        s_perfManager = new AtomicServiceReference("com.ibm.ws.sip.container.pmi");
        genericEndpointRef = new ConcurrentServiceReferenceSet("com.ibm.ws.sip.endpoint");
        sipMessageFactoryRef = new ConcurrentServiceReferenceSet("com.ibm.ws.sip.container.was.message.SipMessageFactory");
        _sipMessageFactory = null;
        m_context = null;
        s_initialized = false;
        useNetty = false;
    }
}

