/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilderFactory;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;

public class SAMLConfiguration {
    private static Function<String, String> lowercaseFunction = new LowercaseFunction();
    private SAML1ArtifactBuilderFactory saml1ArtifactBuilderFactory;
    private SAML2ArtifactBuilderFactory saml2ArtifactBuilderFactory;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    private List<String> allowedBindingURLSchemes;

    public SAMLConfiguration() {
        this.setAllowedBindingURLSchemes(Collections.unmodifiableList(Arrays.asList("http", "https")));
    }

    public SAML1ArtifactBuilderFactory getSAML1ArtifactBuilderFactory() {
        return this.saml1ArtifactBuilderFactory;
    }

    public void setSAML1ArtifactBuilderFactory(SAML1ArtifactBuilderFactory factory) {
        this.saml1ArtifactBuilderFactory = factory;
    }

    public SAML2ArtifactBuilderFactory getSAML2ArtifactBuilderFactory() {
        return this.saml2ArtifactBuilderFactory;
    }

    public void setSAML2ArtifactBuilderFactory(SAML2ArtifactBuilderFactory factory) {
        this.saml2ArtifactBuilderFactory = factory;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<String> getAllowedBindingURLSchemes() {
        return this.allowedBindingURLSchemes;
    }

    public void setAllowedBindingURLSchemes(@Nullable List<String> schemes) {
        this.allowedBindingURLSchemes = schemes == null || schemes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(StringSupport.normalizeStringCollection(schemes).stream().map(lowercaseFunction::apply).collect(Collectors.toList()));
    }

    private static class LowercaseFunction
    implements Function<String, String> {
        private LowercaseFunction() {
        }

        @Override
        public String apply(String input) {
            if (input == null) {
                return null;
            }
            return input.toLowerCase();
        }
    }
}

