/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DumpData {
    private static TraceComponent tc = Tr.register(DumpData.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static final long serialVersionUID = 862897699984935868L;

    @Trivial
    public static StringBuffer dumpAssertion(StringBuffer sbParent, Assertion assertion, int identLevel) {
        StringBuffer sb = sbParent == null ? new StringBuffer("\n") : sbParent;
        sb.append(DumpData.identString(identLevel, true)).append("SubjectID(Username):").append(assertion.getSubject().getNameID().getValue()).append("\n");
        sb.append(DumpData.identString(identLevel)).append("Issuer:").append(assertion.getIssuer().getValue()).append("\n");
        sb.append(DumpData.identString(identLevel)).append("isSigned:").append(assertion.isSigned()).append(" signReferenceId:").append(assertion.getSignatureReferenceID()).append("\n");
        sb.append(DumpData.identString(identLevel)).append("DOM:").append(assertion.getDOM()).append(" @").append(assertion.getDOM().hashCode()).append(")\n");
        List children = assertion.getOrderedChildren();
        for (XMLObject xmlObject : children) {
            if (!(xmlObject instanceof Assertion)) continue;
            DumpData.dumpAssertion(sb, (Assertion)xmlObject, identLevel + 1);
        }
        return sb;
    }

    @Trivial
    public static StringBuffer dumpXMLObject(StringBuffer sbParent, XMLObject xmlObject, int identLevel) {
        StringBuffer sb;
        StringBuffer stringBuffer = sb = sbParent == null ? new StringBuffer("\n") : sbParent;
        if (xmlObject == null) {
            sb.append(DumpData.identString(identLevel, false)).append("found an null XMLObject\n");
            return sb;
        }
        QName qName = xmlObject.getElementQName();
        sb.append(DumpData.identString(identLevel, true)).append(qName.getPrefix()).append(":").append(qName.getLocalPart()).append("(").append(qName.getNamespaceURI()).append(")\n");
        Element dom = xmlObject.getDOM();
        if (dom != null) {
            sb.append(DumpData.identString(identLevel)).append("DOM:").append(dom).append(" @").append(dom.hashCode()).append(")\n");
        } else {
            sb.append(DumpData.identString(identLevel)).append("DOM is null");
        }
        if (xmlObject instanceof SignableSAMLObject) {
            sb.append(DumpData.identString(identLevel)).append("isSigned:").append(((SignableSAMLObject)xmlObject).isSigned()).append(" id:").append(((SignableSAMLObject)xmlObject).getSignatureReferenceID()).append(")\n");
        }
        if (xmlObject.hasChildren()) {
            List children = xmlObject.getOrderedChildren();
            for (XMLObject xmlObj : children) {
                DumpData.dumpXMLObject(sb, xmlObj, identLevel + 1);
            }
        }
        return sb;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public static String dumpRequestInfo(HttpServletRequest request) {
        StringBuffer strBuf = new StringBuffer("");
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (int iI = 0; iI < cookies.length; ++iI) {
                    strBuf.append("cookie " + cookies[iI] + "\n");
                }
            }
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames != null && headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String value = request.getHeader(headerName);
                strBuf.append("header " + headerName + ":" + value + "\n");
            }
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames != null && parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameterName);
                if (values != null && values.length > 0) {
                    for (int iI = 0; iI < values.length; ++iI) {
                        strBuf.append("parameter " + parameterName + ":" + values[iI] + "\n");
                    }
                    continue;
                }
                strBuf.append("parameter " + parameterName + ":null or empty\n");
            }
            StringBuffer requestUrl = request.getRequestURL();
            strBuf.append("requestUrl:" + requestUrl.toString() + "\n");
            strBuf.append("queryString:" + request.getQueryString() + "\n");
            strBuf.append("sessionId:" + request.getRequestedSessionId() + "\n");
            strBuf.append("session:" + request.getSession(true) + "\n");
            String contentType = request.getContentType();
            strBuf.append("contentType:" + contentType + "\n");
            strBuf.append("method:" + request.getMethod() + "\n");
            if ("multipart/form-data".equalsIgnoreCase(contentType)) {
                Collection parts = request.getParts();
                for (Part part : parts) {
                    strBuf.append("part:" + part.getName() + "->" + part.getContentType() + "\n");
                }
            }
        }
        catch (Exception cookies) {
            void e;
            FFDCFilter.processException((Throwable)cookies, (String)"com.ibm.ws.security.saml.sso20.internal.utils.DumpData", (String)"139", null, (Object[])new Object[]{request});
            strBuf.append("Hit unexpect exception:" + e);
        }
        return strBuf.toString();
    }

    @Trivial
    static String identString(int ident) {
        String space = "  ";
        String result = "";
        for (int iI = 0; iI < ident; ++iI) {
            result = result.concat(space);
        }
        return result;
    }

    @Trivial
    static String identString(int ident, boolean bOk) {
        String space;
        String string = space = bOk ? "**" : "==";
        if (ident == 0) {
            return "";
        }
        String result = DumpData.identString(ident - 1);
        return result.concat(space);
    }

    public static StringBuffer dumpMetadata(DOMMetadataResolver metadataProvider) {
        XMLObject metadata = null;
        return DumpData.dumpXMLObject(null, metadata, 0);
    }
}

