/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import jakarta.faces.FactoryFinder;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewParameter;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitContextFactory;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.context.PartialViewContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.PhaseId;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.view.ViewMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.context.PartialResponseWriterImpl;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.renderkit.html.HtmlResponseStateManager;
import org.apache.myfaces.shared.util.StringUtils;

public class PartialViewContextImpl
extends PartialViewContext {
    private static final String FACES_REQUEST = "Faces-Request";
    private static final String PARTIAL_AJAX = "partial/ajax";
    private static final String PARTIAL_AJAX_REQ = "jakarta.faces.partial.ajax";
    private static final String PARTIAL_PROCESS = "partial/process";
    private static final String PARTIAL_IFRAME = "org.apache.myfaces.partial.iframe";
    private static final Set<VisitHint> PARTIAL_EXECUTE_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.EXECUTE_LIFECYCLE, VisitHint.SKIP_UNRENDERED));
    private static final Set<VisitHint> PARTIAL_RENDER_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_UNRENDERED));
    private static final VisitCallback RESET_VALUES_CALLBACK = new ResetValuesCallback();
    private static final Set<VisitHint> RESET_VALUES_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_UNRENDERED));
    private FacesContext _facesContext = null;
    private boolean _released = false;
    private Boolean _ajaxRequest = null;
    private Boolean _iframeRequest = null;
    private Collection<String> _executeClientIds = null;
    private Collection<String> _renderClientIds = null;
    private Boolean _partialRequest = null;
    private Boolean _renderAll = null;
    private PartialResponseWriter _partialResponseWriter = null;
    private VisitContextFactory _visitContextFactory = null;
    private Boolean _resetValues = null;
    private List<String> _evalScripts = new ArrayList<String>();

    public PartialViewContextImpl(FacesContext context) {
        this._facesContext = context;
    }

    public PartialViewContextImpl(FacesContext context, VisitContextFactory visitContextFactory) {
        this._facesContext = context;
        this._visitContextFactory = visitContextFactory;
    }

    public boolean isAjaxRequest() {
        this.assertNotReleased();
        if (this._ajaxRequest == null) {
            String requestType = (String)this._facesContext.getExternalContext().getRequestHeaderMap().get(FACES_REQUEST);
            this._ajaxRequest = requestType != null && PARTIAL_AJAX.equals(requestType);
            String reqParmamterPartialAjax = (String)this._facesContext.getExternalContext().getRequestParameterMap().get(PARTIAL_AJAX_REQ);
            this._ajaxRequest = this._ajaxRequest != false || reqParmamterPartialAjax != null;
        }
        return this._ajaxRequest;
    }

    public boolean isExecuteAll() {
        String executeMode;
        this.assertNotReleased();
        return this.isAjaxRequest() && "@all".equals(executeMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.execute"));
    }

    public boolean isPartialRequest() {
        this.assertNotReleased();
        if (this._partialRequest == null) {
            String requestType = (String)this._facesContext.getExternalContext().getRequestHeaderMap().get(FACES_REQUEST);
            this._partialRequest = requestType != null && PARTIAL_PROCESS.equals(requestType);
        }
        return this._partialRequest != false || this.isAjaxRequest();
    }

    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this._renderAll == null) {
            String executeMode;
            if (this.isAjaxRequest() && "@all".equals(executeMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.render"))) {
                this._renderAll = true;
            }
            if (this._renderAll == null) {
                this._renderAll = false;
            }
        }
        return this._renderAll;
    }

    public boolean isIFrameRequest() {
        if (this._iframeRequest == null) {
            this._iframeRequest = this._facesContext.getExternalContext().getRequestParameterMap().containsKey(PARTIAL_IFRAME);
        }
        return this._iframeRequest;
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.assertNotReleased();
        this._partialRequest = isPartialRequest;
    }

    public void setRenderAll(boolean renderAll) {
        this.assertNotReleased();
        this._renderAll = renderAll;
    }

    public Collection<String> getExecuteIds() {
        this.assertNotReleased();
        if (this._executeClientIds == null) {
            String executeMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.execute");
            if (executeMode != null && !"".equals(executeMode) && !"@all".equals(executeMode)) {
                String[] clientIds = StringUtils.splitShortString(this._replaceTabOrEnterCharactersWithSpaces(executeMode), ' ');
                ArrayList<String> tempList = new ArrayList<String>();
                for (String clientId : clientIds) {
                    if (clientId.length() <= 0) continue;
                    tempList.add(clientId);
                }
                String source = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
                if (source != null && !tempList.contains(source = source.trim())) {
                    tempList.add(source);
                }
                this._executeClientIds = tempList;
            } else {
                this._executeClientIds = new ArrayList<String>();
            }
        }
        return this._executeClientIds;
    }

    private String _replaceTabOrEnterCharactersWithSpaces(String mode) {
        StringBuilder builder = new StringBuilder(mode.length());
        for (int i = 0; i < mode.length(); ++i) {
            if (mode.charAt(i) == '\t' || mode.charAt(i) == '\n') {
                builder.append(' ');
                continue;
            }
            builder.append(mode.charAt(i));
        }
        return builder.toString();
    }

    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this._renderClientIds == null) {
            String renderMode = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.render");
            if (renderMode != null && !"".equals(renderMode) && !"@all".equals(renderMode)) {
                String[] clientIds = StringUtils.splitShortString(this._replaceTabOrEnterCharactersWithSpaces(renderMode), ' ');
                ArrayList<String> tempList = new ArrayList<String>();
                for (String clientId : clientIds) {
                    if (clientId.length() <= 0) continue;
                    tempList.add(clientId);
                }
                this._renderClientIds = tempList;
            } else {
                this._renderClientIds = new ArrayList<String>();
                if ("@all".equals(renderMode)) {
                    this._renderClientIds.add("jakarta.faces.ViewRoot");
                }
            }
        }
        return this._renderClientIds;
    }

    public PartialResponseWriter getPartialResponseWriter() {
        this.assertNotReleased();
        if (this._partialResponseWriter == null) {
            ResponseWriter responseWriter = this._facesContext.getResponseWriter();
            if (responseWriter == null) {
                try {
                    RenderKit renderKit = this._facesContext.getRenderKit();
                    if (renderKit == null) {
                        String renderKitId = this._facesContext.getApplication().getViewHandler().calculateRenderKitId(this._facesContext);
                        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
                        renderKit = rkf.getRenderKit(this._facesContext, renderKitId);
                    }
                    responseWriter = renderKit.createResponseWriter(this._facesContext.getExternalContext().getResponseOutputWriter(), "text/xml", this._facesContext.getExternalContext().getRequestCharacterEncoding());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot create Partial Response Writer", e);
                }
            }
            this._partialResponseWriter = responseWriter instanceof PartialResponseWriter ? (PartialResponseWriter)responseWriter : new PartialResponseWriterImpl(responseWriter);
        }
        return this._partialResponseWriter;
    }

    public List<String> getEvalScripts() {
        return this._evalScripts;
    }

    public void processPartial(PhaseId phaseId) {
        this.assertNotReleased();
        UIViewRoot viewRoot = this._facesContext.getViewRoot();
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            this.processPartialExecute(viewRoot, phaseId);
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            this.processPartialRendering(viewRoot, phaseId);
        }
    }

    private void processPartialExecute(UIViewRoot viewRoot, PhaseId phaseId) {
        PartialViewContext pvc = this._facesContext.getPartialViewContext();
        Collection executeIds = pvc.getExecuteIds();
        if (executeIds == null || executeIds.isEmpty()) {
            return;
        }
        VisitContext visitCtx = this.getVisitContextFactory().getVisitContext(this._facesContext, executeIds, PARTIAL_EXECUTE_HINTS);
        viewRoot.visitTree(visitCtx, (VisitCallback)new PhaseAwareVisitCallback(this._facesContext, phaseId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartialRendering(UIViewRoot viewRoot, PhaseId phaseId) {
        Logger log;
        PartialResponseWriter writer = this._facesContext.getPartialViewContext().getPartialResponseWriter();
        PartialViewContext pvc = this._facesContext.getPartialViewContext();
        ResponseWriter oldWriter = this._facesContext.getResponseWriter();
        boolean inDocument = false;
        ExternalContext externalContext = this._facesContext.getExternalContext();
        externalContext.setResponseContentType("text/xml");
        externalContext.addResponseHeader("Pragma", "no-cache");
        externalContext.addResponseHeader("Cache-control", "no-cache");
        externalContext.addResponseHeader("Expires", "-1");
        try {
            String viewState;
            String currentEncoding = writer.getCharacterEncoding();
            writer.startDocument();
            writer.writeAttribute("id", (Object)viewRoot.getContainerClientId(this._facesContext), "id");
            inDocument = true;
            this._facesContext.setResponseWriter((ResponseWriter)writer);
            if (this.isResetValues()) {
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this._facesContext, this.getRenderIds(), RESET_VALUES_HINTS);
                viewRoot.visitTree(visitContext, RESET_VALUES_CALLBACK);
            }
            if (pvc.isRenderAll()) {
                this.processRenderAll(viewRoot, writer);
            } else {
                Object rvc;
                ArrayList<UIComponent> updatedComponents;
                Collection renderIds = pvc.getRenderIds();
                if (renderIds != null && !renderIds.isEmpty()) {
                    if (renderIds.contains("jakarta.faces.ViewRoot")) {
                        this.processRenderAll(viewRoot, writer);
                    } else {
                        updatedComponents = new ArrayList();
                        rvc = RequestViewContext.getCurrentInstance(this._facesContext);
                        this.processRenderResource(this._facesContext, writer, (RequestViewContext)rvc, updatedComponents, "head");
                        this.processRenderResource(this._facesContext, writer, (RequestViewContext)rvc, updatedComponents, "body");
                        this.processRenderResource(this._facesContext, writer, (RequestViewContext)rvc, updatedComponents, "form");
                        VisitContext visitCtx = this.getVisitContextFactory().getVisitContext(this._facesContext, renderIds, PARTIAL_RENDER_HINTS);
                        viewRoot.visitTree(visitCtx, (VisitCallback)new PhaseAwareVisitCallback(this._facesContext, phaseId, updatedComponents));
                    }
                } else {
                    updatedComponents = new ArrayList<UIComponent>();
                    rvc = RequestViewContext.getCurrentInstance(this._facesContext);
                    this.processRenderResource(this._facesContext, writer, (RequestViewContext)rvc, updatedComponents, "head");
                    this.processRenderResource(this._facesContext, writer, (RequestViewContext)rvc, updatedComponents, "body");
                    this.processRenderResource(this._facesContext, writer, (RequestViewContext)rvc, updatedComponents, "form");
                }
                List evalScripts = pvc.getEvalScripts();
                if (evalScripts != null && evalScripts.size() > 0) {
                    rvc = evalScripts.iterator();
                    while (rvc.hasNext()) {
                        String script = (String)rvc.next();
                        writer.startEval();
                        writer.write(script);
                        writer.endEval();
                    }
                }
            }
            Collection viewParams = ViewMetadata.getViewParameters((UIViewRoot)viewRoot);
            if (!viewParams.isEmpty()) {
                for (UIViewParameter param : viewParams) {
                    param.encodeAll(this._facesContext);
                }
            }
            if ((viewState = this._facesContext.getApplication().getStateManager().getViewState(this._facesContext)) != null) {
                writer.startUpdate(HtmlResponseStateManager.generateUpdateViewStateId((FacesContext)this._facesContext));
                writer.write(viewState);
                writer.endUpdate();
            } else if (viewRoot.isTransient()) {
                writer.startUpdate(HtmlResponseStateManager.generateUpdateViewStateId((FacesContext)this._facesContext));
                writer.write("stateless");
                writer.endUpdate();
            }
            ClientWindow cw = this._facesContext.getExternalContext().getClientWindow();
            if (cw != null) {
                writer.startUpdate(HtmlResponseStateManager.generateUpdateClientWindowId((FacesContext)this._facesContext));
                writer.write(cw.getId());
                writer.endUpdate();
            }
        }
        catch (IOException ex) {
            log = Logger.getLogger(PartialViewContextImpl.class.getName());
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "", ex);
            }
        }
        finally {
            block29: {
                try {
                    if (inDocument) {
                        writer.endDocument();
                    }
                    writer.flush();
                }
                catch (IOException ex) {
                    log = Logger.getLogger(PartialViewContextImpl.class.getName());
                    if (!log.isLoggable(Level.SEVERE)) break block29;
                    log.log(Level.SEVERE, "", ex);
                }
            }
            this._facesContext.setResponseWriter(oldWriter);
        }
    }

    private void processRenderResource(FacesContext facesContext, PartialResponseWriter writer, RequestViewContext rvc, List<UIComponent> updatedComponents, String target) throws IOException {
        List<UIComponent> list;
        if (rvc.isRenderTarget(target) && (list = rvc.getRenderTargetComponentList(target)) != null && !list.isEmpty()) {
            writer.startUpdate("jakarta.faces.Resource");
            for (UIComponent component : list) {
                boolean resourceRendered = false;
                if ("jakarta.faces.resource.Script".equals(component.getRendererType()) || "jakarta.faces.resource.Stylesheet".equals(component.getRendererType())) {
                    String resourceName = (String)component.getAttributes().get("name");
                    String libraryName = (String)component.getAttributes().get("library");
                    if (resourceName == null) {
                        component.encodeAll(facesContext);
                        continue;
                    }
                    if ("".equals(resourceName)) {
                        component.encodeAll(facesContext);
                        continue;
                    }
                    int index = resourceName.indexOf(63);
                    if (index >= 0) {
                        resourceName = resourceName.substring(0, index);
                    }
                    if (!this._facesContext.getApplication().getResourceHandler().isResourceRendered(this._facesContext, resourceName, libraryName)) {
                        component.encodeAll(facesContext);
                    }
                } else {
                    component.encodeAll(facesContext);
                }
                if (resourceRendered) continue;
                if (updatedComponents == null) {
                    updatedComponents = new ArrayList<UIComponent>();
                }
                updatedComponents.add(component);
            }
            writer.endUpdate();
        }
    }

    private void processRenderAll(UIViewRoot viewRoot, PartialResponseWriter writer) throws IOException {
        Map map = (Map)viewRoot.getTransientStateHelper().getTransient((Object)"org.apache.myfaces.RENDERED_RESOURCES_SET");
        if (map != null) {
            map.clear();
        }
        writer.startUpdate("jakarta.faces.ViewRoot");
        int childCount = viewRoot.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent comp = (UIComponent)viewRoot.getChildren().get(i);
            comp.encodeAll(this._facesContext);
        }
        writer.endUpdate();
    }

    private void assertNotReleased() {
        if (this._released) {
            throw new IllegalStateException("Error the FacesContext is already released!");
        }
    }

    public void release() {
        this.assertNotReleased();
        this._visitContextFactory = null;
        this._executeClientIds = null;
        this._renderClientIds = null;
        this._ajaxRequest = null;
        this._partialRequest = null;
        this._renderAll = null;
        this._facesContext = null;
        this._released = true;
    }

    private VisitContextFactory getVisitContextFactory() {
        if (this._visitContextFactory == null) {
            this._visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.component.visit.VisitContextFactory");
        }
        return this._visitContextFactory;
    }

    public boolean isResetValues() {
        if (this._resetValues == null) {
            String value = (String)this._facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.resetValues");
            this._resetValues = "true".equals(value);
        }
        return this._resetValues;
    }

    private class PhaseAwareVisitCallback
    implements VisitCallback {
        private PhaseId _phaseId;
        private FacesContext _facesContext;
        private List<UIComponent> _alreadyUpdatedComponents;

        public PhaseAwareVisitCallback(FacesContext facesContext, PhaseId phaseId) {
            this._phaseId = phaseId;
            this._facesContext = facesContext;
            this._alreadyUpdatedComponents = null;
        }

        public PhaseAwareVisitCallback(FacesContext facesContext, PhaseId phaseId, List<UIComponent> alreadyUpdatedComponents) {
            this._phaseId = phaseId;
            this._facesContext = facesContext;
            this._alreadyUpdatedComponents = alreadyUpdatedComponents;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this._phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                target.processDecodes(this._facesContext);
            } else if (this._phaseId == PhaseId.PROCESS_VALIDATIONS) {
                target.processValidators(this._facesContext);
            } else if (this._phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                target.processUpdates(this._facesContext);
            } else if (this._phaseId == PhaseId.RENDER_RESPONSE) {
                this.processRenderComponent(target);
            } else {
                throw new IllegalStateException("PPR Response, illegale phase called");
            }
            return VisitResult.REJECT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRenderComponent(UIComponent target) {
            Logger log;
            boolean inUpdate = false;
            PartialResponseWriter writer = (PartialResponseWriter)this._facesContext.getResponseWriter();
            if (this._alreadyUpdatedComponents != null) {
                for (UIComponent parent = target; parent != null; parent = parent.getParent()) {
                    if (!this._alreadyUpdatedComponents.contains(parent)) continue;
                    return;
                }
            }
            try {
                writer.startUpdate(target.getClientId(this._facesContext));
                inUpdate = true;
                target.encodeAll(this._facesContext);
            }
            catch (IOException ex) {
                log = Logger.getLogger(PartialViewContextImpl.class.getName());
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, "IOException for rendering component", ex);
                }
            }
            finally {
                block16: {
                    if (inUpdate) {
                        try {
                            writer.endUpdate();
                        }
                        catch (IOException ex) {
                            log = Logger.getLogger(PartialViewContextImpl.class.getName());
                            if (!log.isLoggable(Level.SEVERE)) break block16;
                            log.log(Level.SEVERE, "IOException for rendering component, stopping update rendering", ex);
                        }
                    }
                }
            }
        }
    }

    private static class ResetValuesCallback
    implements VisitCallback {
        private ResetValuesCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target instanceof EditableValueHolder) {
                ((EditableValueHolder)target).resetValue();
            }
            return VisitResult.ACCEPT;
        }
    }
}

