/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.monitor.pmi.queuemonitor;

import com.ibm.websphere.monitor.meters.Gauge;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.container.pmi.OutboundQueueMonitoringCounter;
import com.ibm.ws.sip.container.pmi.QueueMonitoringCounter;
import com.ibm.ws.sip.container.pmi.QueueMonitoringModuleInterface;
import com.ibm.ws.sip.monitor.mxbeans.QueueMonitoringCountersMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="s_logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class QueueMonitoringModule
extends Meter
implements QueueMonitoringCountersMXBean,
QueueMonitoringModuleInterface {
    private static final Logger s_logger = Logger.getLogger(QueueMonitoringModule.class.getName());
    private Gauge _totalTasksCountInProcessingQueue;
    private Gauge _peakTasksCountInProcessingQueue;
    private Gauge _minTasksCountInProcessingQueue;
    private Gauge _percentageFullTasksCountInProcessingQueue;
    private Gauge _totalTasksCountInOutboundQueue;
    private Gauge _peakTasksCountInOutboundQueue;
    private Gauge _minTasksCountInOutboundQueue;
    private Gauge _percentageFullTasksCountInOutboundQueue;
    private QueueMonitoringCounter _processingQueueMonitoringCounter;
    private QueueMonitoringCounter _outboundQueueMonitoringCounter;
    private static QueueMonitoringModule s_singleton = null;
    static final long serialVersionUID = -5504305192832617761L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static QueueMonitoringModule getInstance() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getInstance", new Object[0]);
        }
        if (s_singleton == null) {
            s_singleton = new QueueMonitoringModule();
        }
        QueueMonitoringModule queueMonitoringModule = s_singleton;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            queueMonitoringModule = queueMonitoringModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getInstance", queueMonitoringModule);
        }
        return queueMonitoringModule;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QueueMonitoringModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "<init>", new Object[0]);
        }
        this._totalTasksCountInProcessingQueue = new Gauge();
        this._peakTasksCountInProcessingQueue = new Gauge();
        this._minTasksCountInProcessingQueue = new Gauge();
        this._percentageFullTasksCountInProcessingQueue = new Gauge();
        this._totalTasksCountInOutboundQueue = new Gauge();
        this._peakTasksCountInOutboundQueue = new Gauge();
        this._minTasksCountInOutboundQueue = new Gauge();
        this._percentageFullTasksCountInOutboundQueue = new Gauge();
        this._processingQueueMonitoringCounter = new QueueMonitoringCounter();
        this._outboundQueueMonitoringCounter = new OutboundQueueMonitoringCounter();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void destroy() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "destroy", new Object[0]);
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "destroy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void updateQueueMonitoringTaskQueuedInProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskQueuedInProcessingQueue", new Object[0]);
        }
        this._processingQueueMonitoringCounter.updateInTask();
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, QueueMonitoringModule.class.getName(), "updateQueueMonitoringTaskQueuedInProcessingQueue", "New task queued");
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskQueuedInProcessingQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void updateQueueMonitoringTaskDequeuedFromProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskDequeuedFromProcessingQueue", new Object[0]);
        }
        this._processingQueueMonitoringCounter.updateOutTask();
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, QueueMonitoringModule.class.getName(), "updateQueueMonitoringTaskDequeuedFromProcessingQueue", "Task dequeued");
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskDequeuedFromProcessingQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void updateQueueMonitoringTaskQueuedInOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskQueuedInOutboundQueue", new Object[0]);
        }
        this._outboundQueueMonitoringCounter.updateInTask();
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, QueueMonitoringModule.class.getName(), "updateQueueMonitoringTaskDequeuedFromProcessingQueue", "New task queued");
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskQueuedInOutboundQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void updateQueueMonitoringTaskDequeuedFromOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskDequeuedFromOutboundQueue", new Object[0]);
        }
        this._outboundQueueMonitoringCounter.updateOutTask();
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, QueueMonitoringModule.class.getName(), "updateQueueMonitoringTaskDequeuedFromOutboundQueue", "Task dequeued");
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringTaskDequeuedFromOutboundQueue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setPMICounterIfEnabled(Gauge counter, long value) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "setPMICounterIfEnabled", new Object[]{counter, value});
        }
        counter.setCurrentValue(value);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "setPMICounterIfEnabled");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void updateQueueMonitoringPMICounters() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringPMICounters", new Object[0]);
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, QueueMonitoringModule.class.getName(), "updateQueueMonitoringPMICounters", "");
        }
        this.setPMICounterIfEnabled(this._totalTasksCountInProcessingQueue, this._processingQueueMonitoringCounter.getTotalTasksDuringCurrentWindow());
        this.setPMICounterIfEnabled(this._peakTasksCountInProcessingQueue, this._processingQueueMonitoringCounter.getPeakTasks());
        this.setPMICounterIfEnabled(this._minTasksCountInProcessingQueue, this._processingQueueMonitoringCounter.getMinTasks());
        this.setPMICounterIfEnabled(this._percentageFullTasksCountInProcessingQueue, this._processingQueueMonitoringCounter.getPercentageFull());
        this.setPMICounterIfEnabled(this._totalTasksCountInOutboundQueue, this._outboundQueueMonitoringCounter.getTotalTasksDuringCurrentWindow());
        this.setPMICounterIfEnabled(this._peakTasksCountInOutboundQueue, this._outboundQueueMonitoringCounter.getPeakTasks());
        this.setPMICounterIfEnabled(this._minTasksCountInOutboundQueue, this._outboundQueueMonitoringCounter.getMinTasks());
        this.setPMICounterIfEnabled(this._percentageFullTasksCountInOutboundQueue, this._outboundQueueMonitoringCounter.getPercentageFull());
        this._processingQueueMonitoringCounter.initStatistics();
        this._outboundQueueMonitoringCounter.initStatistics();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "updateQueueMonitoringPMICounters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized boolean isQueueMonitoringProcessingQueuePMIEnabled() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "isQueueMonitoringProcessingQueuePMIEnabled", new Object[0]);
        }
        boolean bl = true;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            bl = bl;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "isQueueMonitoringProcessingQueuePMIEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isQueueMonitoringOutboundQueuePMIEnabled() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "isQueueMonitoringOutboundQueuePMIEnabled", new Object[0]);
        }
        boolean bl = true;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            bl = bl;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "isQueueMonitoringOutboundQueuePMIEnabled", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getTotalTasksCountInProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getTotalTasksCountInProcessingQueue", new Object[0]);
        }
        long l = this._totalTasksCountInProcessingQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getTotalTasksCountInProcessingQueue", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getPeakTasksCountInProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPeakTasksCountInProcessingQueue", new Object[0]);
        }
        long l = this._peakTasksCountInProcessingQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPeakTasksCountInProcessingQueue", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getMinTasksCountInProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getMinTasksCountInProcessingQueue", new Object[0]);
        }
        long l = this._minTasksCountInProcessingQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getMinTasksCountInProcessingQueue", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getPercentageFullTasksCountInProcessingQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPercentageFullTasksCountInProcessingQueue", new Object[0]);
        }
        long l = this._percentageFullTasksCountInProcessingQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPercentageFullTasksCountInProcessingQueue", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getTotalTasksCountInOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getTotalTasksCountInOutboundQueue", new Object[0]);
        }
        long l = this._totalTasksCountInOutboundQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getTotalTasksCountInOutboundQueue", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getPeakTasksCountInOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPeakTasksCountInOutboundQueue", new Object[0]);
        }
        long l = this._peakTasksCountInOutboundQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPeakTasksCountInOutboundQueue", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getMinTasksCountInOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getMinTasksCountInOutboundQueue", new Object[0]);
        }
        long l = this._minTasksCountInOutboundQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getMinTasksCountInOutboundQueue", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getPercentageFullTasksCountInOutboundQueue() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPercentageFullTasksCountInOutboundQueue", new Object[0]);
        }
        long l = this._percentageFullTasksCountInOutboundQueue.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.queuemonitor.QueueMonitoringModule", "getPercentageFullTasksCountInOutboundQueue", l);
        }
        return l;
    }
}

