/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.monitor.pmi.basic;

import com.ibm.websphere.monitor.meters.Gauge;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.monitor.mxbeans.SipContainerBasicCountersMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="s_logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SipContainerBasicCounters
extends Meter
implements SipContainerBasicCountersMXBean {
    private static final Logger s_logger = Logger.getLogger(SipContainerBasicCounters.class.getName());
    private static SipContainerBasicCounters s_singleton = null;
    private Gauge _sipAppSessionCounter;
    private Gauge _sipSessionCounter;
    private Gauge _receivedSipMsgsCounter;
    private Gauge _newSipApplicationCreated;
    private Gauge _sipRequestProcessing;
    private Gauge _rejectedMessagesCounter;
    private Gauge _sipTimersInvokations;
    private Gauge _invokerSize;
    static final long serialVersionUID = -4561964390759470799L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SipContainerBasicCounters() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "<init>", new Object[0]);
        }
        this._sipAppSessionCounter = new Gauge();
        this._sipSessionCounter = new Gauge();
        this._receivedSipMsgsCounter = new Gauge();
        this._newSipApplicationCreated = new Gauge();
        this._sipRequestProcessing = new Gauge();
        this._rejectedMessagesCounter = new Gauge();
        this._sipTimersInvokations = new Gauge();
        this._invokerSize = new Gauge();
        this.setDescription("This module provides the basic SIP container counters");
        this._sipAppSessionCounter.setDescription("Sip Application Sessions counter that count SipApplicationSessions");
        this._sipSessionCounter.setDescription("Sip Sessions counter that count SipSessions");
        this._receivedSipMsgsCounter.setDescription("Number of SIP messages received by the SIP Container during 10 secs or the predefined <pmiUpdateRange>");
        this._newSipApplicationCreated.setDescription("Num of new Sip Application Sessions created in the SIP Container during 10 secs or the predefined <pmiUpdateRange>");
        this._sipRequestProcessing.setDescription("Time processing of SIP Request during 10 secs or the predefined <pmiUpdateRange>");
        this._rejectedMessagesCounter.setDescription("Number of rejected messages");
        this._sipTimersInvokations.setDescription("Number of SIP timers invocations");
        this._invokerSize.setDescription("Average the invoker queue size");
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getSipAppSessions() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipAppSessions", new Object[0]);
        }
        long l = this._sipAppSessionCounter.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipAppSessions", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getSipSessions() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipSessions", new Object[0]);
        }
        long l = this._sipSessionCounter.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipSessions", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getReceivedSipMsgs() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getReceivedSipMsgs", new Object[0]);
        }
        long l = this._receivedSipMsgsCounter.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getReceivedSipMsgs", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getNewSipApplications() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getNewSipApplications", new Object[0]);
        }
        long l = this._newSipApplicationCreated.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getNewSipApplications", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getSipRequestProcessing() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipRequestProcessing", new Object[0]);
        }
        long l = this._sipRequestProcessing.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipRequestProcessing", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getRejectedMessages() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getRejectedMessages", new Object[0]);
        }
        long l = this._rejectedMessagesCounter.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getRejectedMessages", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getSipTimersInvocations() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipTimersInvocations", new Object[0]);
        }
        long l = this._sipTimersInvokations.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getSipTimersInvocations", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getInvokerSize() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getInvokerSize", new Object[0]);
        }
        long l = this._invokerSize.getCurrentValue();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            l = l;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getInvokerSize", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInvokerSize(long size) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setInvokerSize", new Object[]{size});
        }
        this._invokerSize.setCurrentValue(size);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setInvokerSize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setReceivedSipMsgs(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setReceivedSipMsgs", new Object[]{num});
        }
        this._receivedSipMsgsCounter.setCurrentValue(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setReceivedSipMsgs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setNewSipApplications(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setNewSipApplications", new Object[]{num});
        }
        this._newSipApplicationCreated.setCurrentValue(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setNewSipApplications");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRejectedSipMessages(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setRejectedSipMessages", new Object[]{num});
        }
        this._rejectedMessagesCounter.setCurrentValue(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setRejectedSipMessages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRequestProcessing(long ms) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setRequestProcessing", new Object[]{ms});
        }
        this._sipRequestProcessing.setCurrentValue(ms);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setRequestProcessing");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSipAppSessions(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setSipAppSessions", new Object[]{num});
        }
        this._sipAppSessionCounter.setCurrentValue(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setSipAppSessions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSipSessions(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setSipSessions", new Object[]{num});
        }
        this._sipSessionCounter.setCurrentValue(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setSipSessions");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setSipTimersInvocations(long num) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setSipTimersInvocations", new Object[]{num});
        }
        this._sipTimersInvokations.setCurrentValue(num);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "setSipTimersInvocations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SipContainerBasicCounters getInstance() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getInstance", new Object[0]);
        }
        if (s_singleton == null) {
            s_singleton = new SipContainerBasicCounters();
        }
        SipContainerBasicCounters sipContainerBasicCounters = s_singleton;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            sipContainerBasicCounters = sipContainerBasicCounters;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.basic.SipContainerBasicCounters", "getInstance", sipContainerBasicCounters);
        }
        return sipContainerBasicCounters;
    }
}

