/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.sso.common.SsoService;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.saml.saml2.core.Assertion;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TokenUtils {
    protected static final TraceComponent tc = Tr.register(TokenUtils.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    public static final String KEY_SSO_SERVICE = "ssoService";
    static ConcurrentServiceReferenceMap<String, SsoService> ssoServiceRef = new ConcurrentServiceReferenceMap("ssoService");
    private static WebProviderAuthenticatorHelper authHelper;
    static final String KEY_SECURITY_SERVICE = "securityService";
    private static AtomicServiceReference<SecurityService> securityServiceRef;
    static final long serialVersionUID = -1257917027803645837L;

    public static Saml20Token createSamlTokenFromAssertion(Assertion assertion) throws Exception {
        Saml20Token token = null;
        SsoService saml20Service = TokenUtils.getCommonSsoService("saml20");
        if (saml20Service != null) {
            HashMap<String, Assertion> requestContext = new HashMap<String, Assertion>();
            requestContext.put("wssecurity-samlassertion", assertion);
            Map result = saml20Service.handleRequest("wssecurity-samlassertion", requestContext);
            if (!result.isEmpty()) {
                token = (Saml20Token)result.get("samlssotoken");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Can not find SAML20 SsoService=saml20", (Object[])new Object[0]);
        }
        return token;
    }

    public static void setCommonSsoService(ConcurrentServiceReferenceMap<String, SsoService> activatedSsoServicerefs) {
        ssoServiceRef = activatedSsoServicerefs;
    }

    public static SsoService getCommonSsoService(String key) {
        return (SsoService)ssoServiceRef.getService((Object)key);
    }

    public static WebProviderAuthenticatorHelper getAuthHelper() {
        return authHelper;
    }

    public static void setAuthHelper(WebProviderAuthenticatorHelper authHelper) {
        TokenUtils.authHelper = authHelper;
    }

    public static AtomicServiceReference<SecurityService> getSecurityServiceRef() {
        return securityServiceRef;
    }

    public static void setSecurityServiceRef(AtomicServiceReference<SecurityService> securityServiceRef) {
        TokenUtils.securityServiceRef = securityServiceRef;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        securityServiceRef = new AtomicServiceReference(KEY_SECURITY_SERVICE);
    }
}

