/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.AbstractConverter;
import io.smallrye.config.common.AbstractDelegatingConverter;
import io.smallrye.config.inject.InjectionMessages;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigProducerUtil {
    private ConfigProducerUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> T getValue(InjectionPoint injectionPoint, Config config) {
        return ConfigProducerUtil.getValue(ConfigProducerUtil.getName(injectionPoint), ConfigProducerUtil.getType(injectionPoint), ConfigProducerUtil.getDefaultValue(injectionPoint), config);
    }

    private static Type getType(InjectionPoint injectionPoint) {
        ParameterizedType parameterizedType;
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType && ((parameterizedType = (ParameterizedType)type).getRawType().equals(Provider.class) || parameterizedType.getRawType().equals(Instance.class))) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static <T> T getValue(String name, Type type, String defaultValue, Config config) {
        if (name == null) {
            return null;
        }
        SmallRyeConfig smallRyeConfig = (SmallRyeConfig)config.unwrap(SmallRyeConfig.class);
        ConfigValue configValue = ConfigProducerUtil.getConfigValue(name, smallRyeConfig);
        ConfigValue configValueWithDefault = configValue.withValue(ConfigProducerUtil.resolveDefault(configValue.getValue(), defaultValue));
        if (ConfigProducerUtil.hasCollection(type)) {
            return ConfigProducerUtil.convertValues(configValueWithDefault, type, smallRyeConfig);
        }
        if (ConfigProducerUtil.hasMap(type)) {
            return smallRyeConfig.convertValue(configValueWithDefault, ConfigProducerUtil.resolveConverter(type, smallRyeConfig, (kC, vC) -> new StaticMapConverter(configValueWithDefault.getName(), configValueWithDefault.getValue(), config, kC, vC)));
        }
        return smallRyeConfig.convertValue(configValueWithDefault, ConfigProducerUtil.resolveConverter(type, smallRyeConfig));
    }

    private static <T> T convertValues(ConfigValue configValue, Type type, SmallRyeConfig config) {
        List<String> indexedProperties = config.getIndexedProperties(configValue.getName());
        if (configValue.getRawValue() != null || indexedProperties.isEmpty()) {
            return config.convertValue(configValue, ConfigProducerUtil.resolveConverter(type, config));
        }
        BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter = (itemConverter, collectionFactory) -> {
            Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
            for (String indexedProperty : indexedProperties) {
                collection.add(config.convertValue(ConfigProducerUtil.getConfigValue(indexedProperty, config), itemConverter));
            }
            return collection;
        };
        return (T)ConfigProducerUtil.resolveConverterForIndexed(type, config, indexedConverter).convert(" ");
    }

    static org.eclipse.microprofile.config.ConfigValue getConfigValue(InjectionPoint injectionPoint, SmallRyeConfig config) {
        String name = ConfigProducerUtil.getName(injectionPoint);
        if (name == null) {
            return null;
        }
        ConfigValue configValue = config.getConfigValue(name);
        if (configValue.getRawValue() == null) {
            configValue = configValue.withValue(ConfigProducerUtil.getDefaultValue(injectionPoint));
        }
        return configValue;
    }

    static ConfigValue getConfigValue(String name, SmallRyeConfig config) {
        return SecretKeys.doUnlocked(() -> config.getConfigValue(name));
    }

    private static String resolveDefault(String rawValue, String defaultValue) {
        return rawValue != null ? rawValue : defaultValue;
    }

    private static <T> Converter<T> resolveConverter(Type type, SmallRyeConfig config) {
        return ConfigProducerUtil.resolveConverter(type, config, Converters::newMapConverter);
    }

    private static <T> Converter<T> resolveConverter(Type type, SmallRyeConfig config, BiFunction<Converter<Object>, Converter<Object>, Converter<Map<Object, Object>>> mapConverterFactory) {
        Class rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), ArrayList::new);
            }
            if (rawType == Set.class) {
                return Converters.newCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), HashSet::new);
            }
            if (rawType == Map.class) {
                return mapConverterFactory.apply(ConfigProducerUtil.resolveConverter(typeArgs[0], config), ConfigProducerUtil.resolveConverter(typeArgs[1], config));
            }
            if (rawType == Optional.class) {
                return Converters.newOptionalConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config, mapConverterFactory));
            }
            if (rawType == Supplier.class) {
                return ConfigProducerUtil.resolveConverter(typeArgs[0], config, mapConverterFactory);
            }
        } else if (rawType == Map.class) {
            return mapConverterFactory.apply(ConfigProducerUtil.resolveConverter(String.class, config), ConfigProducerUtil.resolveConverter(String.class, config));
        }
        return config.getConverter(rawType).orElseThrow(() -> InjectionMessages.msg.noRegisteredConverter(rawType));
    }

    private static <T> Converter<T> resolveConverterForIndexed(Type type, SmallRyeConfig config, BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter) {
        Class<T> rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return new IndexedCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), ArrayList::new, indexedConverter);
            }
            if (rawType == Set.class) {
                return new IndexedCollectionConverter(ConfigProducerUtil.resolveConverter(typeArgs[0], config), HashSet::new, indexedConverter);
            }
            if (rawType == Optional.class) {
                return Converters.newOptionalConverter(ConfigProducerUtil.resolveConverterForIndexed(typeArgs[0], config, indexedConverter));
            }
            if (rawType == Supplier.class) {
                return ConfigProducerUtil.resolveConverterForIndexed(typeArgs[0], config, indexedConverter);
            }
        }
        throw new IllegalStateException();
    }

    private static <T> Class<T> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigProducerUtil.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigProducerUtil.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw InjectionMessages.msg.noRawType(type);
    }

    private static boolean hasMap(Type type) {
        Class rawType = ConfigProducerUtil.rawTypeOf(type);
        if (rawType == Map.class) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return ConfigProducerUtil.hasMap(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        return false;
    }

    private static <T> boolean hasCollection(Type type) {
        Class<T> rawType = ConfigProducerUtil.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type[] typeArgs = paramType.getActualTypeArguments();
            if (rawType == List.class) {
                return true;
            }
            if (rawType == Set.class) {
                return true;
            }
            return ConfigProducerUtil.hasCollection(typeArgs[0]);
        }
        return false;
    }

    private static String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            ConfigProperty configProperty = (ConfigProperty)qualifier;
            return ConfigProducerUtil.getConfigKey(injectionPoint, configProperty);
        }
        return null;
    }

    private static String getDefaultValue(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            String str = ((ConfigProperty)qualifier).defaultValue();
            if (!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(str)) {
                return str;
            }
            Class rawType = ConfigProducerUtil.rawTypeOf(injectionPoint.getType());
            if (rawType.isPrimitive()) {
                if (rawType == Character.TYPE) {
                    return null;
                }
                if (rawType == Boolean.TYPE) {
                    return "false";
                }
                return "0";
            }
            return null;
        }
        return null;
    }

    static String getConfigKey(InjectionPoint ip, ConfigProperty configProperty) {
        AnnotatedMember member;
        AnnotatedType declaringType;
        String key = configProperty.name();
        if (!key.trim().isEmpty()) {
            return key;
        }
        if (ip.getAnnotated() instanceof AnnotatedMember && (declaringType = (member = (AnnotatedMember)ip.getAnnotated()).getDeclaringType()) != null) {
            String[] parts = declaringType.getJavaClass().getCanonicalName().split("\\.");
            StringBuilder sb = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                sb.append(".").append(parts[i]);
            }
            sb.append(".").append(member.getJavaMember().getName());
            return sb.toString();
        }
        throw InjectionMessages.msg.noConfigPropertyDefaultName(ip);
    }

    static final class StaticMapConverter<K, V>
    extends AbstractConverter<Map<K, V>> {
        private static final long serialVersionUID = 402894491607011464L;
        private final String name;
        private final String defaultValue;
        private final Config config;
        private final Converter<K> keyConverter;
        private final Converter<V> valueConverter;

        StaticMapConverter(String name, String defaultValue, Config config, Converter<K> keyConverter, Converter<V> valueConverter) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.config = config;
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        public Map<K, V> convert(String value) throws IllegalArgumentException, NullPointerException {
            Map result = StaticMapConverter.getValues(this.name, this.config, this.keyConverter, this.valueConverter);
            if (result == null && this.defaultValue != null) {
                result = (Map)Converters.newMapConverter(this.keyConverter, this.valueConverter).convert(this.defaultValue);
            }
            return result;
        }

        private static <K, V> Map<K, V> getValues(String name, Config config, Converter<K> keyConverter, Converter<V> valueConverter) {
            return SecretKeys.doUnlocked(() -> ((SmallRyeConfig)config.unwrap(SmallRyeConfig.class)).getValuesAsMap(name, keyConverter, valueConverter));
        }
    }

    static final class IndexedCollectionConverter<T, C extends Collection<T>>
    extends AbstractDelegatingConverter<T, C> {
        private static final long serialVersionUID = 5186940408317652618L;
        private final IntFunction<Collection<T>> collectionFactory;
        private final BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter;

        public IndexedCollectionConverter(Converter<T> resolveConverter, IntFunction<Collection<T>> collectionFactory, BiFunction<Converter<T>, IntFunction<Collection<T>>, Collection<T>> indexedConverter) {
            super(resolveConverter);
            this.collectionFactory = collectionFactory;
            this.indexedConverter = indexedConverter;
        }

        public C convert(String value) throws IllegalArgumentException, NullPointerException {
            return (C)this.indexedConverter.apply(this.getDelegate(), this.collectionFactory);
        }
    }
}

