/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.AuthorizationValue;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.util.ClasspathHelper;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RemoteUrl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RefUtils {
    static final long serialVersionUID = 6151898718485678157L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String computeDefinitionName(String ref, Set<String> reserved) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split = plausibleName.split("\\.");
            plausibleName = split[0];
        }
        String tryName = plausibleName;
        int i = 2;
        while (reserved.contains(tryName)) {
            tryName = plausibleName + "_" + i;
            ++i;
        }
        return tryName;
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static RefFormat computeRefFormat(String ref) {
        RefFormat result = RefFormat.INTERNAL;
        if (ref.startsWith("http")) {
            result = RefFormat.URL;
        } else if (ref.startsWith("#/")) {
            result = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/")) {
            result = RefFormat.RELATIVE;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static String readExternalUrlRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat != RefFormat.URL) {
                String url = RefUtils.buildUrl(rootPath, file);
                return RefUtils.readExternalRef(url, RefFormat.URL, auths, null);
            }
            result = RemoteUrl.urlToString(file, auths);
        }
        catch (Exception url) {
            void e;
            FFDCFilter.processException((Throwable)url, (String)"com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils", (String)"100", null, (Object[])new Object[]{file, refFormat, auths, rootPath});
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, (Throwable)e);
        }
        return result;
    }

    public static String buildUrl(String rootPath, String relativePath) {
        int i;
        String[] rootPathParts = rootPath.split("/");
        String[] relPathParts = relativePath.split("/");
        if (rootPath == null || relativePath == null) {
            return null;
        }
        int trimRoot = 0;
        int trimRel = 0;
        if (!"".equals(rootPathParts[rootPathParts.length - 1])) {
            trimRoot = 1;
        }
        for (i = 0; i < rootPathParts.length && "".equals(rootPathParts[i]); ++i) {
            ++trimRel;
        }
        for (i = 0; i < relPathParts.length; ++i) {
            if (".".equals(relPathParts[i])) {
                ++trimRel;
                continue;
            }
            if (!"..".equals(relPathParts[i])) continue;
            ++trimRel;
        }
        Object[] outputParts = new String[rootPathParts.length + relPathParts.length - trimRoot - trimRel];
        System.arraycopy(rootPathParts, 0, outputParts, 0, rootPathParts.length - trimRoot);
        System.arraycopy(relPathParts, trimRel, outputParts, rootPathParts.length - trimRoot + trimRel - 1, relPathParts.length - trimRel);
        return StringUtils.join((Object[])outputParts, (String)"/");
    }

    /*
     * WARNING - void declaration
     */
    public static String readExternalRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            Path pathToUse;
            result = refFormat == RefFormat.URL ? RemoteUrl.urlToString(file, auths) : (Files.exists(pathToUse = parentDirectory.resolve(file).normalize(), new LinkOption[0]) ? IOUtils.toString((InputStream)new FileInputStream(pathToUse.toFile()), (Charset)StandardCharsets.UTF_8) : ClasspathHelper.loadFileFromClasspath(file));
        }
        catch (Exception pathToUse) {
            void e;
            FFDCFilter.processException((Throwable)pathToUse, (String)"com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils", (String)"171", null, (Object[])new Object[]{file, refFormat, auths, parentDirectory});
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, (Throwable)e);
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils", RefUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

