/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing;

import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.tracing.RESTEasyTracingLoggerImpl;
import org.jboss.resteasy.tracing.RESTEasyTracingUtils;
import org.jboss.resteasy.tracing.api.RESTEasyTracing;
import org.jboss.resteasy.tracing.api.RESTEasyTracingConfig;
import org.jboss.resteasy.tracing.api.RESTEasyTracingLevel;

public interface RESTEasyTracingLogger {
    public static final RESTEasyTracingLogger EMPTY = new RESTEasyTracingLogger(){

        @Override
        public void flush(MultivaluedMap<String, Object> headers) {
        }

        @Override
        public boolean isLogEnabled(String eventName) {
            return false;
        }

        @Override
        public void log(String eventName, Object ... args) {
        }

        @Override
        public void logDuration(String eventName, long fromTimestamp, Object ... args) {
        }

        @Override
        public long timestamp(String eventName) {
            return 0L;
        }
    };

    public boolean isLogEnabled(String var1);

    public void log(String var1, Object ... var2);

    public void logDuration(String var1, long var2, Object ... var4);

    public long timestamp(String var1);

    public void flush(MultivaluedMap<String, Object> var1);

    public static RESTEasyTracingLogger create(String requestId, String threshold, String loggerNameSuffix) {
        return RESTEasyTracingLogger.create(requestId, threshold, loggerNameSuffix, null);
    }

    public static RESTEasyTracingLogger create(String requestId, String tracingThreshold, String tracingLoggerNameSuffix, String tracingInfoFormat) {
        if (!TRACING.AVAILABLE) {
            return EMPTY;
        }
        return new RESTEasyTracingLoggerImpl(requestId, RESTEasyTracingLevel.valueOf(tracingThreshold), tracingLoggerNameSuffix, tracingInfoFormat);
    }

    public static RESTEasyTracingLogger create(String invocationId, Configuration configuration, String loggerNameSuffix) {
        if (!TRACING.AVAILABLE) {
            return EMPTY;
        }
        return new RESTEasyTracingLoggerImpl(invocationId, RESTEasyTracingUtils.getRESTEasyTracingThreshold(configuration), loggerNameSuffix);
    }

    public static RESTEasyTracingLogger getInstance(HttpRequest request) {
        if (request == null || !TRACING.AVAILABLE) {
            return EMPTY;
        }
        RESTEasyTracingLogger tracingLogger = (RESTEasyTracingLogger)request.getAttribute(RESTEasyTracing.PROPERTY_NAME);
        return tracingLogger == null ? EMPTY : tracingLogger;
    }

    public static RESTEasyTracingLogger empty() {
        return EMPTY;
    }

    public static void initTracingSupport(Configuration configuration, HttpRequest request) {
        if (!TRACING.AVAILABLE || request.getAttribute(RESTEasyTracing.PROPERTY_NAME) != null) {
            return;
        }
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingUtils.isTracingSupportEnabled(RESTEasyTracingUtils.getRESTEasyTracingConfig(configuration), request) ? RESTEasyTracingLogger.create(request.toString(), RESTEasyTracingUtils.getTracingThreshold(RESTEasyTracingUtils.getRESTEasyTracingThreshold(configuration), request), RESTEasyTracingUtils.getTracingLoggerNameSuffix(request), RESTEasyTracingUtils.getTracingInfoFormat(request)) : RESTEasyTracingLogger.empty();
        request.setAttribute(RESTEasyTracing.PROPERTY_NAME, tracingLogger);
    }

    public static void logStart(HttpRequest request) {
        StringBuilder text;
        if (!TRACING.AVAILABLE || request == null) {
            return;
        }
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
        if (tracingLogger.isLogEnabled("START")) {
            text = new StringBuilder();
            SecurityContext securityContext = ResteasyContext.getContextData(SecurityContext.class);
            text.append(String.format("baseUri=[%s] requestUri=[%s] method=[%s] authScheme=[%s]", request.getUri().getBaseUri(), request.getUri().getRequestUri(), request.getHttpMethod(), RESTEasyTracingUtils.toStringOrNA(securityContext == null ? null : securityContext.getAuthenticationScheme())));
            for (String header : RESTEasyTracingUtils.SUMMARY_HEADERS) {
                text.append(String.format(" %s=%s", header, RESTEasyTracingUtils.toStringOrNA(RESTEasyTracingUtils.getHeaderString(request, header))));
            }
            tracingLogger.log("START", text.toString());
        }
        if (tracingLogger.isLogEnabled("START_HEADERS")) {
            text = new StringBuilder();
            HttpHeaders headers = request.getHttpHeaders();
            if (headers != null) {
                for (String header : headers.getRequestHeaders().keySet()) {
                    if (RESTEasyTracingUtils.SUMMARY_HEADERS.contains(header)) continue;
                    text.append(String.format(" %s=%s", header, RESTEasyTracingUtils.toStringOrNA(headers.getRequestHeaders().get((Object)header))));
                }
                if (text.length() > 0) {
                    text.insert(0, "Other request headers:");
                }
                tracingLogger.log("START_HEADERS", text.toString());
            }
        }
    }

    public static boolean isTracingConfigALL(Configuration configuration) {
        return TRACING.AVAILABLE && RESTEasyTracingUtils.getRESTEasyTracingConfig(configuration) == RESTEasyTracingConfig.ALL;
    }

    public static String getTracingConfig(Configuration configuration) {
        return TRACING.AVAILABLE ? RESTEasyTracingUtils.getRESTEasyTracingConfig(configuration).toString() : null;
    }

    public static String getTracingThreshold(Configuration configuration) {
        return TRACING.AVAILABLE ? RESTEasyTracingUtils.getRESTEasyTracingThreshold(configuration).toString() : null;
    }

    public static class TRACING {
        public static final boolean AVAILABLE;

        static {
            boolean b;
            try {
                Class.forName("org.jboss.resteasy.tracing.api.RESTEasyTracing");
                b = true;
            }
            catch (Throwable t) {
                b = false;
            }
            AVAILABLE = b;
        }
    }
}

