/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OAuth20ClientMetatypeService.class}, name="oauth20ClientMetatypeService", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class OAuth20ClientMetatypeService {
    private static TraceComponent tc = Tr.register(OAuth20ClientMetatypeService.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String RESPONSE_KEY_ID = "id";
    public static final String RESPONSE_KEY_NAME = "name";
    public static final String RESPONSE_KEY_DESCRIPTION = "description";
    public static final String RESPONSE_KEY_TYPE = "type";
    public static final String RESPONSE_KEY_DEFAULT = "default";
    public static final String RESPONSE_KEY_OPTIONS = "options";
    public static final String RESPONSE_KEY_OPTIONS_LABEL = "label";
    public static final String RESPONSE_KEY_OPTIONS_VALUE = "value";
    public static final String RESPONSE_KEY_CARDINALITY = "cardinality";
    public static final String RESPONSE_KEY_REQUIRED = "required";
    public static final String RESPONSE_KEY_SEPARATION_CHAR = "separationChar";
    public static final String RESPONSE_KEY_ALLOW_USER_PROVIDED_VALUE = "allowUserProvidedValue";
    public static final String RESPONSE_KEY_REQUEST_PARAMETER_NAME = "requestParameterName";
    public static final String KEY_METATYPE_SERVICE = "metaTypeService";
    protected final AtomicServiceReference<MetaTypeService> metaTypeServiceRef = new AtomicServiceReference("metaTypeService");
    private Bundle thisBundle = null;
    private JsonObject allMetatypeData = new JsonObject();
    static final long serialVersionUID = -1991420527789932663L;

    @Reference(service=MetaTypeService.class, name="metaTypeService", policy=ReferencePolicy.DYNAMIC)
    protected void setMetaTypeService(ServiceReference<MetaTypeService> ref) {
        this.metaTypeServiceRef.setReference(ref);
    }

    protected void unsetMetaTypeService(ServiceReference<MetaTypeService> ref) {
        this.metaTypeServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.metaTypeServiceRef.activate(cc);
        this.thisBundle = cc.getBundleContext().getBundle();
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.metaTypeServiceRef.deactivate(cc);
    }

    public void sendClientMetatypeData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isSupportedHttpMethod(request.getMethod())) {
            response.sendError(405);
            return;
        }
        JsonArray metadataJson = this.getOAuthClientMetatypeData(this.getRequestLocales(request));
        this.writeMetatypeDataToResponse(response, metadataJson);
    }

    JsonArray getOAuthClientMetatypeData(List<String> locales) {
        MetaTypeInformation metatypeInfo = this.getMetaTypeInformation();
        if (metatypeInfo == null) {
            return null;
        }
        this.allMetatypeData = this.createMetatypeJson(metatypeInfo, locales);
        return this.putMetatypeDataInAppropriateOrder();
    }

    void writeMetatypeDataToResponse(HttpServletResponse response, JsonArray metadataJson) throws IOException {
        try {
            if (metadataJson == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Null metatype object was supplied; error response will be returned", (Object[])new Object[0]);
                }
                response.sendError(500);
                return;
            }
            response.setHeader("Content-Type", "application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            PrintWriter writer = response.getWriter();
            writer.println(new String(metadataJson.toString().getBytes(StandardCharsets.UTF_16.toString()), StandardCharsets.UTF_16));
            writer.flush();
            writer.close();
        }
        catch (IOException writer) {
            FFDCFilter.processException((Throwable)writer, (String)"com.ibm.ws.security.oauth20.web.OAuth20ClientMetatypeService", (String)"137", (Object)this, (Object[])new Object[]{response, metadataJson});
            response.sendError(500);
        }
    }

    private boolean isSupportedHttpMethod(String requestMethod) {
        return "GET".equalsIgnoreCase(requestMethod) || "HEAD".equalsIgnoreCase(requestMethod);
    }

    private List<String> getRequestLocales(HttpServletRequest request) {
        ArrayList<String> localesSet = new ArrayList<String>();
        Enumeration locales = request.getLocales();
        if (locales != null) {
            while (locales.hasMoreElements()) {
                localesSet.add(((Locale)locales.nextElement()).toString());
            }
        }
        return localesSet;
    }

    private MetaTypeInformation getMetaTypeInformation() {
        MetaTypeService metatypeService = (MetaTypeService)this.metaTypeServiceRef.getService();
        if (metatypeService == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to find MetaTypeService", (Object[])new Object[0]);
            }
            return null;
        }
        if (this.thisBundle == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Missing bundle information", (Object[])new Object[0]);
            }
            return null;
        }
        MetaTypeInformation metatypeInfo = metatypeService.getMetaTypeInformation(this.thisBundle);
        if (metatypeInfo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to find MetaTypeInformation for this bundle (" + this.thisBundle.getBundleId() + " - " + this.thisBundle.getSymbolicName() + ")"), (Object[])new Object[0]);
            }
            return null;
        }
        return metatypeInfo;
    }

    private JsonObject createMetatypeJson(MetaTypeInformation metatypeInfo, List<String> locales) {
        JsonObject metatypeJson = null;
        for (String thisLocale : locales) {
            ObjectClassDefinition ocd = metatypeInfo.getObjectClassDefinition("com.ibm.ws.security.oauth20.client", thisLocale);
            if (ocd == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Did not find translated metatype information for locale [" + thisLocale + "]"), (Object[])new Object[0]);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating metatype information based on locale [" + thisLocale + "]"), (Object[])new Object[0]);
            }
            metatypeJson = this.createMetatypeJsonForObjectClassDefinition(metatypeInfo, ocd);
            break;
        }
        return metatypeJson;
    }

    private JsonObject createMetatypeJsonForObjectClassDefinition(MetaTypeInformation metatypeInfo, ObjectClassDefinition ocd) {
        AttributeDefinition[] allAttributeDefs = ocd.getAttributeDefinitions(-1);
        if (allAttributeDefs == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to find any attribute definitions for OCD [" + ocd.getID() + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        List<String> requiredAttributeIds = this.getRequiredAttributeIds(ocd);
        JsonObject metatypeJson = new JsonObject();
        for (AttributeDefinition attrDef : allAttributeDefs) {
            if (this.isAttributeToIgnore(attrDef)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Attribute [" + attrDef.getID() + "] will not be included"), (Object[])new Object[0]);
                continue;
            }
            JsonObject attrJson = this.createJsonForConfigAttribute(attrDef, requiredAttributeIds);
            if (attrJson == null) continue;
            metatypeJson.add(attrDef.getID(), (JsonElement)attrJson);
        }
        return metatypeJson;
    }

    private List<String> getRequiredAttributeIds(ObjectClassDefinition ocd) {
        ArrayList<String> requiredAttributes = new ArrayList<String>();
        AttributeDefinition[] requiredAttrDefs = ocd.getAttributeDefinitions(1);
        if (requiredAttrDefs == null) {
            return requiredAttributes;
        }
        for (AttributeDefinition attrDef : requiredAttrDefs) {
            requiredAttributes.add(attrDef.getID());
        }
        return requiredAttributes;
    }

    @Trivial
    private boolean isAttributeToIgnore(AttributeDefinition attrDef) {
        return "internal".equals(attrDef.getName()) || this.isUnsupportedRegistrationAttribute(attrDef);
    }

    @Trivial
    private boolean isUnsupportedRegistrationAttribute(AttributeDefinition attrDef) {
        String attributeId = attrDef.getID();
        return "resourceIds".equals(attributeId) || "enabled".equals(attributeId) || "sessionManaged".equals(attributeId);
    }

    private JsonObject createJsonForConfigAttribute(AttributeDefinition attrDef, List<String> requiredAttributeIds) {
        JsonObject attributeJson = new JsonObject();
        this.addApiRequiredEntriesForConfigAttribute(attrDef, attributeJson);
        this.addApiOptionalEntriesForConfigAttribute(attrDef, attributeJson, requiredAttributeIds);
        this.addApiSpecificEntriesForConfigAttribute(attrDef, attributeJson);
        return attributeJson;
    }

    private void addApiRequiredEntriesForConfigAttribute(AttributeDefinition attrDef, JsonObject attributeJson) {
        attributeJson.addProperty(RESPONSE_KEY_ID, attrDef.getID());
        attributeJson.addProperty(RESPONSE_KEY_NAME, attrDef.getName());
        attributeJson.addProperty(RESPONSE_KEY_DESCRIPTION, attrDef.getDescription());
        attributeJson.addProperty(RESPONSE_KEY_TYPE, this.getAttributeTypeString(attrDef));
    }

    private String getAttributeTypeString(AttributeDefinition attrDef) {
        int typeNum = attrDef.getType();
        if (typeNum == 1) {
            return "String";
        }
        if (typeNum == 11) {
            return "Boolean";
        }
        if (typeNum == 6) {
            return "Byte";
        }
        if (typeNum == 5) {
            return "Character";
        }
        if (typeNum == 7) {
            return "Double";
        }
        if (typeNum == 8) {
            return "Float";
        }
        if (typeNum == 3) {
            return "Integer";
        }
        if (typeNum == 2) {
            return "Long";
        }
        if (typeNum == 12) {
            return "Password";
        }
        if (typeNum == 4) {
            return "Short";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Encountered unknown type value [" + typeNum + "]"), (Object[])new Object[0]);
        }
        return null;
    }

    private void addApiOptionalEntriesForConfigAttribute(AttributeDefinition attrDef, JsonObject attributeJson, List<String> requiredAttributeIds) {
        this.addAttributeEntryForDefault(attrDef, attributeJson);
        this.addAttributeEntryForOptions(attrDef, attributeJson);
        this.addAttributeEntryForCardinality(attrDef, attributeJson);
        this.addAttributeEntryForRequired(attrDef, attributeJson, requiredAttributeIds);
        this.addAttributeEntryForRequestParameterName(attrDef, attributeJson);
    }

    private void addAttributeEntryForDefault(AttributeDefinition attrDef, JsonObject attributeJson) {
        String[] defaults = attrDef.getDefaultValue();
        if (defaults == null) {
            return;
        }
        JsonArray defaultArray = new JsonArray();
        for (String def : defaults) {
            defaultArray.add((JsonElement)new JsonPrimitive(def));
        }
        attributeJson.add(RESPONSE_KEY_DEFAULT, (JsonElement)defaultArray);
    }

    private void addAttributeEntryForOptions(AttributeDefinition attrDef, JsonObject attributeJson) {
        Object[] optionLabels = attrDef.getOptionLabels();
        Object[] optionValues = attrDef.getOptionValues();
        if (optionLabels != null && optionValues != null) {
            if (optionLabels.length != optionValues.length) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Number of option labels " + Arrays.toString(optionLabels) + " did not match number of option values " + Arrays.toString(optionValues)), (Object[])new Object[0]);
                }
                return;
            }
            JsonArray optionsArray = new JsonArray();
            for (int i = 0; i < optionLabels.length; ++i) {
                JsonObject optionJson = new JsonObject();
                optionJson.addProperty(RESPONSE_KEY_OPTIONS_LABEL, (String)optionLabels[i]);
                optionJson.addProperty(RESPONSE_KEY_OPTIONS_VALUE, (String)optionValues[i]);
                optionsArray.add((JsonElement)optionJson);
            }
            attributeJson.add(RESPONSE_KEY_OPTIONS, (JsonElement)optionsArray);
        }
    }

    private void addAttributeEntryForCardinality(AttributeDefinition attrDef, JsonObject attributeJson) {
        int cardinality = attrDef.getCardinality();
        if (cardinality != 0) {
            attributeJson.addProperty(RESPONSE_KEY_CARDINALITY, (Number)cardinality);
        }
    }

    private void addAttributeEntryForRequired(AttributeDefinition attrDef, JsonObject attributeJson, List<String> requiredAttributeIds) {
        if (requiredAttributeIds.contains(attrDef.getID())) {
            attributeJson.addProperty(RESPONSE_KEY_REQUIRED, Boolean.valueOf(true));
        }
    }

    private void addAttributeEntryForRequestParameterName(AttributeDefinition attrDef, JsonObject attributeJson) {
        String registrationApiReqParamName = this.getRegistrationApiRequestParameterName(attrDef.getID());
        if (registrationApiReqParamName != null) {
            attributeJson.addProperty(RESPONSE_KEY_REQUEST_PARAMETER_NAME, registrationApiReqParamName);
        }
    }

    private String getRegistrationApiRequestParameterName(String attributeId) {
        Map<String, String> nameMap = this.getConfigAttributeNameToRegistrationApiParameterNameMap();
        return nameMap.get(attributeId);
    }

    private Map<String, String> getConfigAttributeNameToRegistrationApiParameterNameMap() {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put(RESPONSE_KEY_NAME, "client_id");
        nameMap.put("secret", "client_secret");
        nameMap.put("displayname", "client_name");
        nameMap.put("redirect", "redirect_uris");
        nameMap.put("scope", "scope");
        nameMap.put("grantTypes", "grant_types");
        nameMap.put("responseTypes", "response_types");
        nameMap.put("tokenEndpointAuthMethod", "token_endpoint_auth_method");
        nameMap.put("preAuthorizedScope", "preauthorized_scope");
        nameMap.put("applicationType", "application_type");
        nameMap.put("postLogoutRedirectUris", "post_logout_redirect_uris");
        nameMap.put("subjectType", "subject_type");
        nameMap.put("functionalUserId", "functional_user_id");
        nameMap.put("functionalUserGroupIds", "functional_user_groupIds");
        nameMap.put("introspectTokens", "introspect_tokens");
        nameMap.put("allowRegexpRedirects", "allow_regexp_redirects");
        nameMap.put("trustedUriPrefixes", "trusted_uri_prefixes");
        return nameMap;
    }

    private void addApiSpecificEntriesForConfigAttribute(AttributeDefinition attrDef, JsonObject attributeJson) {
        this.addAttributeEntryForValidation(attrDef, attributeJson);
        this.addAttributeEntryForSeparationChar(attrDef, attributeJson);
        this.addAttributeEntryForAllowUserProvidedValue(attrDef, attributeJson);
    }

    private void addAttributeEntryForValidation(AttributeDefinition attrDef, JsonObject attributeJson) {
        String attributeId = attrDef.getID();
        Object validationRegex = null;
        Object validationErrorMsg = null;
    }

    private void addAttributeEntryForSeparationChar(AttributeDefinition attrDef, JsonObject attributeJson) {
        String attributeId = attrDef.getID();
        String seperationChar = null;
        if (this.isSpaceSeparatedAttribute(attributeId)) {
            seperationChar = " ";
        }
        if (seperationChar != null) {
            attributeJson.addProperty(RESPONSE_KEY_SEPARATION_CHAR, seperationChar);
        }
    }

    private boolean isSpaceSeparatedAttribute(String attributeId) {
        return "scope".equals(attributeId) || "preAuthorizedScope".equals(attributeId);
    }

    private void addAttributeEntryForAllowUserProvidedValue(AttributeDefinition attrDef, JsonObject attributeJson) {
        String attributeId = attrDef.getID();
        if (this.isAttributeThatAllowsUserProvidedValues(attributeId)) {
            attributeJson.addProperty(RESPONSE_KEY_ALLOW_USER_PROVIDED_VALUE, Boolean.valueOf(true));
        }
    }

    private boolean isAttributeThatAllowsUserProvidedValues(String attributeId) {
        return "scope".equals(attributeId) || "preAuthorizedScope".equals(attributeId);
    }

    private JsonArray putMetatypeDataInAppropriateOrder() {
        JsonArray responseJson = new JsonArray();
        responseJson.addAll(this.getPrioritizedMetatypeData());
        responseJson.addAll(this.getUnprioritizedMetatypeData());
        return responseJson;
    }

    private JsonArray getPrioritizedMetatypeData() {
        JsonArray responseJson = new JsonArray();
        List<String> prioritizedEntries = this.getPrioritizedEntryOrder();
        for (String prioritizedEntryKey : prioritizedEntries) {
            JsonObject responseEntry = this.allMetatypeData.getAsJsonObject(prioritizedEntryKey);
            if (responseEntry == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Failed to find data corresponding to expected config attribute [" + prioritizedEntryKey + "]"), (Object[])new Object[0]);
                continue;
            }
            responseJson.add((JsonElement)this.processMetatypeDataEntryForResponse(prioritizedEntryKey, responseEntry));
        }
        return responseJson;
    }

    private JsonArray getUnprioritizedMetatypeData() {
        JsonArray responseJson = new JsonArray();
        List<String> unprioritizedMetatypeKeys = this.getMetatypeJsonObjectKeys();
        unprioritizedMetatypeKeys.removeAll(this.getPrioritizedEntryOrder());
        Collections.sort(unprioritizedMetatypeKeys);
        for (String unprioritizedKey : unprioritizedMetatypeKeys) {
            JsonObject responseEntry = this.allMetatypeData.getAsJsonObject(unprioritizedKey);
            if (responseEntry == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Failed to find data corresponding to expected config attribute [" + unprioritizedKey + "]"), (Object[])new Object[0]);
                continue;
            }
            responseJson.add((JsonElement)this.processMetatypeDataEntryForResponse(unprioritizedKey, responseEntry));
        }
        return responseJson;
    }

    private List<String> getMetatypeJsonObjectKeys() {
        ArrayList<String> jsonObjectKeys = new ArrayList<String>();
        for (Map.Entry entry : this.allMetatypeData.entrySet()) {
            jsonObjectKeys.add((String)entry.getKey());
        }
        return jsonObjectKeys;
    }

    private List<String> getPrioritizedEntryOrder() {
        ArrayList<String> responseEntryOrder = new ArrayList<String>();
        responseEntryOrder.add(RESPONSE_KEY_NAME);
        responseEntryOrder.add("secret");
        responseEntryOrder.add("displayname");
        responseEntryOrder.add("redirect");
        responseEntryOrder.add("scope");
        responseEntryOrder.add("grantTypes");
        responseEntryOrder.add("responseTypes");
        responseEntryOrder.add("tokenEndpointAuthMethod");
        responseEntryOrder.add("preAuthorizedScope");
        return responseEntryOrder;
    }

    private JsonObject processMetatypeDataEntryForResponse(String attributeId, JsonObject entry) {
        this.updateSpecialCaseEntries(attributeId, entry);
        return entry;
    }

    private void updateSpecialCaseEntries(String attributeId, JsonObject entry) {
        if ("scope".equals(attributeId)) {
            this.updateEntriesUniqueToScope(entry);
        }
        if ("grantTypes".equals(attributeId)) {
            this.updateEntriesUniqueToGrantTypes(entry);
        }
        if ("responseTypes".equals(attributeId)) {
            this.updateEntriesUniqueToResponseTypes(entry);
        }
    }

    private void updateEntriesUniqueToScope(JsonObject entry) {
        JsonArray defaults = entry.getAsJsonArray(RESPONSE_KEY_DEFAULT);
        if (defaults == null) {
            defaults = new JsonArray();
        }
        defaults.add((JsonElement)new JsonPrimitive("openid"));
        entry.add(RESPONSE_KEY_DEFAULT, (JsonElement)defaults);
    }

    private void updateEntriesUniqueToGrantTypes(JsonObject entry) {
        JsonArray defaults = new JsonArray();
        defaults.add((JsonElement)new JsonPrimitive("authorization_code"));
        entry.add(RESPONSE_KEY_DEFAULT, (JsonElement)defaults);
    }

    private void updateEntriesUniqueToResponseTypes(JsonObject entry) {
        JsonArray defaults = new JsonArray();
        defaults.add((JsonElement)new JsonPrimitive("code"));
        entry.add(RESPONSE_KEY_DEFAULT, (JsonElement)defaults);
    }
}

