/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationRecord;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.NotificationManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}/inbox"})
public class NotificationInboxHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(NotificationInboxHandler.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    static final long serialVersionUID = -2671683236911347798L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (RESTHelper.isGetMethod(method)) {
            this.fetchNotificationInbox(request, response);
        } else if (RESTHelper.isDeleteMethod(method)) {
            this.removeNotificationInboxLegacy(request, response);
        } else {
            throw new RESTHandlerMethodNotAllowedError("GET,DELETE");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fetchNotificationInbox(RESTRequest request, RESTResponse response) {
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationInboxHandler", (String)"72", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        NotificationRecord[] notificationRecords = NotificationManager.getNotificationManager().getClientInbox(clientID);
        OutputHelper.writeNotificationArrayOutput(response, notificationRecords, JSONConverter.getConverter());
    }

    /*
     * WARNING - void declaration
     */
    private void removeNotificationInboxLegacy(RESTRequest request, RESTResponse response) {
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationInboxHandler", (String)"91", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        NotificationManager.getNotificationManager().cleanUp(request, clientID);
        response.setStatus(204);
    }
}

