/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.model.responses;

import com.ibm.ws.microprofile.openapi.model.utils.OpenAPIUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;

public class APIResponseImpl
implements APIResponse {
    private String description = null;
    private Map<String, Header> headers = null;
    private Content content = null;
    private Map<String, Link> links = null;
    private Map<String, Object> extensions = null;
    private String $ref = null;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public APIResponse description(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = headers;
    }

    public APIResponse headers(Map<String, Header> headers) {
        this.headers = headers;
        return this;
    }

    public APIResponse addHeader(String name, Header header) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Header>();
        }
        this.headers.put(name, header);
        return this;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public APIResponse content(Content content) {
        this.content = content;
        return this;
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public APIResponse addLink(String name, Link link) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(name, link);
        return this;
    }

    public String getRef() {
        return this.$ref;
    }

    public void setRef(String ref) {
        if (ref != null && ref.indexOf(".") == -1 && ref.indexOf("/") == -1) {
            ref = "#/components/responses/" + ref;
        }
        this.$ref = ref;
    }

    public APIResponse ref(String $ref) {
        this.setRef($ref);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIResponseImpl apiResponse = (APIResponseImpl)o;
        return Objects.equals(this.description, apiResponse.description) && Objects.equals(this.headers, apiResponse.headers) && Objects.equals(this.content, apiResponse.content) && Objects.equals(this.links, apiResponse.links) && Objects.equals(this.extensions, apiResponse.extensions) && Objects.equals(this.$ref, apiResponse.$ref);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.headers, this.content, this.links, this.extensions, this.$ref);
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void addExtension(String name, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(name, value);
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiResponse {\n");
        sb = this.description != null ? sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n") : sb.append("");
        sb = this.headers != null ? sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n") : sb.append("");
        sb = this.content != null ? sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n") : sb.append("");
        sb = this.links != null ? sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n") : sb.append("");
        sb = this.$ref != null ? sb.append("    $ref: ").append(this.toIndentedString(this.$ref)).append("\n") : sb.append("");
        sb = this.headers != null ? sb.append("    headers: ").append(OpenAPIUtils.mapToString(this.headers)).append("\n") : sb.append("");
        sb = this.links != null ? sb.append("    links: ").append(OpenAPIUtils.mapToString(this.links)).append("\n") : sb.append("");
        sb = this.extensions != null ? sb.append("    extensions: ").append(OpenAPIUtils.mapToString(this.extensions)).append("\n") : sb.append("");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public APIResponse links(Map<String, Link> links) {
        this.links = links;
        return this;
    }
}

