/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.ws.container.Configuration;
import com.ibm.ws.container.Container;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Command;
import com.ibm.ws.webcontainer.exception.WebContainerUnavailableException;
import com.ibm.ws.webcontainer.servlet.IServletWrapperInternal;
import com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.ws.webcontainer.util.ApplicationErrorUtils;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent;
import com.ibm.wsspi.http.channel.exception.WriteBeyondContentLengthException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.webcontainer.ClosedConnectionException;
import com.ibm.wsspi.webcontainer.IPlatformHelper;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorInvocationEnum;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.IConnectionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppTransactionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.TxCollaboratorConfig;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletReferenceListener;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.beans.Beans;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ServletWrapper
extends GenericServlet
implements RequestProcessor,
Container,
IServletWrapper,
IServletWrapperInternal {
    private static final long serialVersionUID = -4479626085298397598L;
    private boolean notifyInvocationListeners;
    protected final byte UNINITIALIZED_STATE = (byte)-1;
    protected final byte AVAILABLE_STATE = 0;
    protected final byte UNAVAILABLE_STATE = 1;
    protected final byte UNAVAILABLE_PERMANENTLY_STATE = (byte)2;
    protected ICollaboratorHelper collabHelper;
    private AtomicInteger nServicing = new AtomicInteger(0);
    private long lastAccessTime = 0L;
    protected byte state = (byte)-1;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.servlet");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.servlet.ServletWrapper";
    private static TraceNLS nls = TraceNLS.getTraceNLS(ServletWrapper.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected IServletConfig servletConfig;
    protected WebApp context;
    protected Servlet target;
    private String metricsKey;
    private List cacheWrappers = null;
    protected ClassLoader targetLoader;
    protected WebAppEventSource evtSource;
    private ServletEvent event;
    protected String unavailableMessage;
    private long unavailableUntil = -1L;
    protected boolean isSTM = false;
    protected boolean internalServlet = false;
    protected IInvocationCollaborator[] webAppInvocationCollaborators;
    protected IPlatformHelper platformHelper;
    private IWebAppNameSpaceCollaborator webAppNameSpaceCollab;
    private IWebAppTransactionCollaborator txCollab;
    private IConnectionCollaborator connCollab;
    private static boolean suppressServletExceptionLogging = WCCustomProperties.SUPPRESS_SERVLET_EXCEPTION_LOGGING;
    private static EnumSet<CollaboratorInvocationEnum> throwExceptionEnum = EnumSet.of(CollaboratorInvocationEnum.EXCEPTION);
    private static boolean discernUnavailableServlet = WCCustomProperties.DISCERN_UNAVAILABLE_SERVLET;
    private static boolean reInitServletonInitUnavailableException = WCCustomProperties.REINIT_SERVLET_ON_INIT_UNAVAILABLE_EXCEPTION;
    private static boolean destroyServletonServiceUnavailableException = WCCustomProperties.DESTROY_SERVLET_ON_SERVICE_UNAVAILABLE_EXCEPTION;
    private boolean servlet23 = false;
    private static Class[] PARAMS_HEAD_TRACE = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private boolean defaultHeadMethodInUse = false;
    private boolean defaultTraceMethodInUse = false;
    private Boolean checkedForDefaultMethods = null;
    private static boolean defaultTraceRequestBehavior = WCCustomProperties.DEFAULT_TRACE_REQUEST_BEHAVIOR;
    private static boolean defaultHeadRequestBehavior = WCCustomProperties.DEFAULT_HEAD_REQUEST_BEHAVIOR;
    private static boolean useOriginalRequestState = WCCustomProperties.USE_ORIGINAL_REQUEST_STATE;
    private boolean warningStatusSet = false;

    public ServletWrapper(IServletContext parent) {
        this.context = (WebApp)parent;
        this.servlet23 = this.context.isServlet23();
        this.evtSource = (WebAppEventSource)this.context.getServletContextEventSource();
        this.notifyInvocationListeners = this.evtSource.hasServletInvocationListeners();
        this.lastAccessTime = System.currentTimeMillis();
        this.collabHelper = this.context.getCollaboratorHelper();
        this.webAppNameSpaceCollab = this.collabHelper.getWebAppNameSpaceCollaborator();
        this.txCollab = this.collabHelper.getWebAppTransactionCollaborator();
        this.platformHelper = WebContainer.getWebContainer().getPlatformHelper();
        this.connCollab = this.collabHelper.getWebAppConnectionCollaborator();
    }

    @Override
    public void setParent(IServletContext parent) {
        this.context = (WebApp)parent;
    }

    public synchronized void init(ServletConfig conf) throws ServletException {
        TxCollaboratorConfig txConfig;
        Object secObject;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "init", "ServletWrapper enter init for servletName--> [" + this.getServletName() + "] , state -->[" + this.getStateString(this.state) + "]");
        }
        if (this.state != -1) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "init", "ServletWrapper exit init for servletName--> [" + this.getServletName() + "] , state -->[" + this.getStateString(this.state) + "]");
            }
            return;
        }
        WebComponentMetaData cmd = null;
        cmd = ((IServletConfig)conf).getMetaData();
        HandleList _connectionHandleList = this.connCollab == null ? null : new HandleList();
        try {
            this.webAppNameSpaceCollab.preInvoke(cmd);
            secObject = this.collabHelper.getSecurityCollaborator().preInvoke(this.servletConfig.getServletName());
            String servletName = conf.getServletName();
            String appName = this.context.getApplicationName();
            this.metricsKey = appName + "." + servletName;
            this.collabHelper.doInvocationCollaboratorsPreInvoke(this.webAppInvocationCollaborators, this.getWebApp().getWebAppCmd());
            txConfig = this.txCollab.preInvoke(null, this.servlet23);
            if (this.connCollab != null) {
                this.connCollab.preInvoke(_connectionHandleList, true);
            }
        }
        catch (SecurityViolationException wse) {
            FFDCWrapper.processException(wse, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "227", this);
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "uncaught.init.exception.thrown.by.servlet", new Object[]{this.getServletName(), this.getWebApp().getApplicationName(), wse});
            ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), wse);
            this.evtSource.onServletInitError(errorEvent);
            this.evtSource.onServletUnloaded(errorEvent);
            throw new ServletException(nls.getString("preInvoke.Security.Exception", "preInvoke Security Exception"), (Throwable)wse);
        }
        catch (IOException ioe) {
            FFDCWrapper.processException(ioe, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "248", this);
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "uncaught.init.exception.thrown.by.servlet", new Object[]{this.getServletName(), this.getWebApp().getApplicationName(), ioe});
            ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), ioe);
            this.evtSource.onServletInitError(errorEvent);
            this.evtSource.onServletUnloaded(errorEvent);
            throw new ServletException(nls.getString("Uncaught.initialization.exception.thrown.by.servlet", "Uncaught initialization exception thrown by servlet"), (Throwable)ioe);
        }
        catch (Exception e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "181", this);
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "uncaught.init.exception.thrown.by.servlet", new Object[]{this.getServletName(), this.getWebApp().getApplicationName(), e});
            ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e);
            this.evtSource.onServletInitError(errorEvent);
            this.evtSource.onServletUnloaded(errorEvent);
            throw new ServletException(nls.getString("Uncaught.initialization.exception.thrown.by.servlet", "Uncaught initialization exception thrown by servlet"), (Throwable)e);
        }
        this.registerMBean();
        this.internalServlet = this.servletConfig.isInternal();
        ClassLoader origClassLoader = null;
        try {
            origClassLoader = ThreadContextHelper.getContextClassLoader();
            ClassLoader warClassLoader = this.context.getClassLoader();
            if (warClassLoader != origClassLoader) {
                ThreadContextHelper.setClassLoader(warClassLoader);
            } else {
                origClassLoader = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "ClassLoader set to: " + warClassLoader.toString());
            }
            this.evtSource.onServletStartInit(this.getServletEvent());
            this.target.init(conf);
            this.modifyTarget(this.target);
            logger.logp(Level.INFO, CLASS_NAME, "init", "[{0}].Initialization.successful", new Object[]{this.getServletName(), this.context.getContextPath(), this.context.getApplicationName()});
            this.evtSource.onServletFinishInit(this.getServletEvent());
            this.evtSource.onServletAvailableForService(this.getServletEvent());
            this.setAvailable();
        }
        catch (UnavailableException ue) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "init", "unavailableException throw by --> [" + this.getServletName(), ue);
            }
            FFDCWrapper.processException(ue, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "259", this);
            if (!reInitServletonInitUnavailableException) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", " Custom property reInitServletonInitUnavailableException is not set");
                }
                this.handleUnavailableException(ue, false);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", " Custom property reInitServletonInitUnavailableException is set");
                }
                this.handleUnavailableException(ue, true);
            }
            ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), ue);
            this.evtSource.onServletInitError(errorEvent);
            if (reInitServletonInitUnavailableException) {
                this.evtSource.onServletUnloaded(errorEvent);
                this.deregisterMBean();
            }
            if (destroyServletonServiceUnavailableException) {
                WebContainerRequestState UEfromInitRequestState = WebContainerRequestState.getInstance(true);
                UEfromInitRequestState.setAttribute("UEinInit", true);
            }
            if (discernUnavailableServlet) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "init", "Create WebContainerUnavailableException");
                }
                throw WebContainerUnavailableException.create(ue);
            }
            throw ue;
        }
        catch (ServletException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "172", this);
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "uncaught.init.exception.thrown.by.servlet", new Object[]{this.getServletName(), this.getWebApp().getApplicationName(), e});
            ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e);
            this.evtSource.onServletInitError(errorEvent);
            this.evtSource.onServletUnloaded(errorEvent);
            throw e;
        }
        catch (Throwable e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "181", this);
            logger.logp(Level.SEVERE, CLASS_NAME, "init", "uncaught.init.exception.thrown.by.servlet", new Object[]{this.getServletName(), this.getWebApp().getApplicationName(), e});
            ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e);
            this.evtSource.onServletInitError(errorEvent);
            this.evtSource.onServletUnloaded(errorEvent);
            throw new ServletException(nls.getString("Uncaught.initialization.exception.thrown.by.servlet", "Uncaught initialization exception thrown by servlet"), e);
        }
        finally {
            if (origClassLoader != null) {
                ClassLoader fOrigClassLoader = origClassLoader;
                ThreadContextHelper.setClassLoader(fOrigClassLoader);
            }
            if (this.connCollab != null) {
                try {
                    this.connCollab.postInvoke(_connectionHandleList, true);
                }
                catch (CSIException e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.WebAppServletManager.init", "260", this);
                }
            }
            try {
                this.txCollab.postInvoke(null, txConfig, this.servlet23);
            }
            catch (Exception e) {
                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "268", this);
            }
            this.collabHelper.doInvocationCollaboratorsPostInvoke(this.webAppInvocationCollaborators, this.getWebApp().getWebAppCmd());
            try {
                this.collabHelper.getSecurityCollaborator().postInvoke(secObject);
            }
            catch (Exception e) {
                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.init", "325", this);
            }
            this.webAppNameSpaceCollab.postInvoke();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "init", "ServletWrapper exit init for servletName--> [" + this.getServletName() + "] , state -->[" + this.getStateString(this.state) + "]");
            }
        }
    }

    protected void registerMBean() {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "registerMBean", "executing method stub");
        }
    }

    protected void deregisterMBean() {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "deregisterMBean", "executing method stub");
        }
    }

    @Override
    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        WebContainerRequestState reqStateSaveRequestResponse;
        ServletRequest httpreq = null;
        if (useOriginalRequestState && (reqStateSaveRequestResponse = WebContainerRequestState.getInstance(false)) != null) {
            httpreq = (ServletRequest)reqStateSaveRequestResponse.getAttribute("unFilteredRequestObject");
        }
        if (httpreq == null) {
            httpreq = req;
        }
        IExtendedRequest wasreq = ServletUtil.unwrapRequest(httpreq);
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)wasreq.getWebAppDispatcherContext();
        this.handleRequest(req, res, dispatchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ServletRequest req, ServletResponse res, WebAppDispatcherContext dispatchContext) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "handleRequest " + this.toString() + " ,request-> " + req + " ,response-> " + res);
        }
        HttpServletRequest httpRequest = null;
        IExtendedRequest wasreq = null;
        boolean filtersInvokedForRequest = false;
        WebContainerRequestState reqFilterState = WebContainerRequestState.getInstance(false);
        if (reqFilterState != null) {
            filtersInvokedForRequest = reqFilterState.isInvokedFilters();
            if (filtersInvokedForRequest) {
                reqFilterState.setInvokedFilters(false);
            }
            if (useOriginalRequestState && filtersInvokedForRequest) {
                httpRequest = (HttpServletRequest)reqFilterState.getAttribute("unFilteredRequestObject");
                reqFilterState.removeAttribute("unFilteredRequestObject");
                if (httpRequest != null) {
                    wasreq = ServletUtil.unwrapRequest((ServletRequest)httpRequest);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest ", " useOriginalRequestState request--->" + httpRequest.getRequestURI() + "<---");
                    }
                }
            }
        }
        if (httpRequest == null) {
            httpRequest = ServletUtil.unwrapRequest(req, HttpServletRequest.class);
            wasreq = ServletUtil.unwrapRequest(req);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest ", " request--->" + httpRequest.getRequestURI() + "<---");
            }
        }
        if (wasreq.isAsyncSupported()) {
            WebContainerRequestState reqState;
            boolean isAsyncSupported = this.servletConfig.isAsyncSupported();
            if (!isAsyncSupported && (reqState = WebContainerRequestState.getInstance(true)) != null) {
                reqState.setAttribute("resourceNotSupportAsync", "servlet[ " + this.getServletName() + " ]");
            }
            wasreq.setAsyncSupported(isAsyncSupported);
        }
        HttpServletResponse httpResponse = (HttpServletResponse)ServletUtil.unwrapResponse(res, HttpServletResponse.class);
        boolean isInclude = dispatchContext.isInclude();
        boolean isForward = dispatchContext.isForward();
        if (this.state == 2) {
            UnavailableException ue = new UnavailableException(this.unavailableMessage);
            ServletErrorReport errorReport = WebAppErrorReport.constructErrorReport((Throwable)ue, dispatchContext.getCurrentServletReference());
            if (isInclude || isForward) {
                if (discernUnavailableServlet) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "init", "Create WebContainerUnavailableException");
                    }
                    throw WebContainerUnavailableException.create(ue);
                }
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.exiting(CLASS_NAME, "handleRequest", "throw exception : " + ue.toString());
                }
                throw ue;
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleRequest", "throw error report : " + errorReport.getExceptionType());
            }
            throw errorReport;
        }
        boolean servletCalled = false;
        try {
            this.notifyInvocationListeners = this.evtSource.hasServletInvocationListeners();
            String nested = (String)req.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested");
            if (nested != null) {
                dispatchContext.pushServletReference(this);
            } else {
                dispatchContext.clearAndPushServletReference(this);
            }
            if (httpRequest.isSecure() && httpRequest.getAttribute("javax.servlet.request.cipher_suite") == null) {
                IExtendedRequest implRequest = ServletUtil.unwrapRequest((ServletRequest)httpRequest);
                String cipherSuite = ((ISRTServletRequest)((Object)implRequest)).getCipherSuite();
                ((ISRTServletRequest)((Object)implRequest)).setSSLAttributesInRequest(httpRequest, cipherSuite);
            }
            WebAppServletInvocationEvent invocationEvent = null;
            if (this.notifyInvocationListeners) {
                invocationEvent = new WebAppServletInvocationEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), (ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            this.target = this.loadServlet();
            if (this.target == null && !this.servletConfig.isClassDefined()) {
                throw new FileNotFoundException();
            }
            if (this.state == -1) {
                if (this.unavailableUntil == -1L) {
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", " state --> " + this.getStateString(this.state) + " ,  init");
                    }
                    this.init(this.servletConfig);
                } else {
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", " state --> " + this.getStateString(this.state) + "&& unavailableUntil --> " + this.unavailableUntil);
                    }
                    this.lastAccessTime = System.currentTimeMillis();
                    long timeDiff = this.unavailableUntil - this.lastAccessTime;
                    if (timeDiff <= 0L) {
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", " unavailable time expired , init ");
                        }
                        this.init(this.servletConfig);
                    } else {
                        int timeLeft = (int)timeDiff / 1000;
                        if (timeLeft == 0) {
                            timeLeft = 1;
                        }
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", " remaining unavailable time --> " + timeLeft);
                        }
                        UnavailableException ue = new UnavailableException(this.unavailableMessage, timeLeft);
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", " handle UnavailableException for TempUE ");
                        }
                        this.handleUnavailableException(ue, true);
                        throw ue;
                    }
                }
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "internal servlet --> " + this.servletConfig.isInternal());
            }
            if (this.context.isMimeFilteringEnabled()) {
                ChainedResponse chainedResp = new ChainedResponse(httpRequest, httpResponse);
                chainedResp.setContentType("text/html");
                Enumeration names = httpRequest.getHeaderNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = httpRequest.getHeader(name);
                    if (name.toLowerCase().startsWith("content")) continue;
                    chainedResp.setAutoTransferringHeader(name, value);
                }
                this.service((ServletRequest)httpRequest, chainedResp, invocationEvent);
                String _redirectURI = null;
                if (chainedResp.isRedirected()) {
                    _redirectURI = chainedResp.getRedirectURI();
                }
                String mimeType = chainedResp.getHeader("content-type");
                IServletWrapper wrapper = this.getMimeFilterWrapper(mimeType);
                while (wrapper != null) {
                    httpRequest = chainedResp.getChainedRequest();
                    ChainedResponse prevChainedResp = chainedResp;
                    chainedResp = new ChainedResponse(httpRequest, httpResponse);
                    chainedResp.setContentType(mimeType);
                    this.transferHeadersFromPrevChainedResp(chainedResp, prevChainedResp);
                    if (_redirectURI != null) {
                        chainedResp.setHeader("location", _redirectURI);
                        chainedResp.setStatus(302);
                    }
                    dispatchContext.pushServletReference(wrapper);
                    ((ServletWrapper)wrapper).service((ServletRequest)httpRequest, chainedResp, invocationEvent);
                    dispatchContext.popServletReference();
                    String newMimeType = chainedResp.getHeader("content-type");
                    String nMime = newMimeType.toLowerCase();
                    String oMime = mimeType.toLowerCase();
                    int icharset = nMime.indexOf(";");
                    if (icharset != -1) {
                        nMime = nMime.substring(0, icharset);
                    }
                    if ((icharset = oMime.indexOf(";")) != -1) {
                        oMime = oMime.substring(0, icharset);
                    }
                    if (nMime.equals(oMime)) {
                        wrapper = null;
                        continue;
                    }
                    mimeType = newMimeType;
                    wrapper = this.getMimeFilterWrapper(mimeType);
                }
                chainedResp.transferResponse(httpResponse);
            } else {
                servletCalled = true;
                this.service(req, res, invocationEvent);
                if (isTraceOn && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "isInclude->" + isInclude + " , res->" + res + " , httpResponse->" + httpResponse + " ,filtersInvokedForRequest-->" + filtersInvokedForRequest + " ,invokeFlushAfterService -->" + WCCustomProperties.INVOKE_FLUSH_AFTER_SERVICE);
                }
                if (!isInclude && !httpResponse.isCommitted() && WCCustomProperties.INVOKE_FLUSH_AFTER_SERVICE) {
                    WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
                    boolean isStartAsync = false;
                    boolean isComplete = false;
                    if (reqState != null) {
                        if (reqState.isAsyncMode()) {
                            isStartAsync = true;
                        }
                        if (reqState.isCompleted()) {
                            isComplete = true;
                        }
                    }
                    if (isTraceOn && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "isComplete->" + isComplete + ", isStartAsync->" + isStartAsync);
                    }
                    if (!(isStartAsync || isComplete || httpResponse instanceof IExtendedResponse)) {
                        httpResponse.flushBuffer();
                    }
                }
            }
        }
        catch (WriteBeyondContentLengthException clex) {
            FFDCWrapper.processException(clex, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "293");
            dispatchContext.pushException(clex);
            try {
                httpResponse.flushBuffer();
            }
            catch (IOException i) {
                ServletErrorReport errorReport = WebAppErrorReport.constructErrorReport((Throwable)i, dispatchContext.getCurrentServletReference());
                FFDCWrapper.processException(i, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "810");
                throw errorReport;
            }
        }
        catch (FileNotFoundException fnfe) {
            if (this.isRethrowOriginalException(req, isInclude, isForward)) {
                dispatchContext.pushException(fnfe);
                throw fnfe;
            }
            ServletErrorReport errorReport = WebAppErrorReport.constructErrorReport((Throwable)fnfe, dispatchContext.getCurrentServletReference());
            dispatchContext.pushException(fnfe);
            throw errorReport;
        }
        catch (IOException ioe) {
            if (this.isRethrowOriginalException(req, isInclude, isForward)) {
                dispatchContext.pushException(ioe);
                throw ioe;
            }
            if (com.ibm.ws.webcontainer.osgi.WebContainer.getServletContainerSpecLevel() >= 31 && ioe.getMessage() != null && ioe.getMessage().contains("SRVE0918E")) {
                throw ioe;
            }
            ServletErrorReport errorReport = WebAppErrorReport.constructErrorReport((Throwable)ioe, dispatchContext.getCurrentServletReference());
            dispatchContext.pushException(ioe);
            FFDCWrapper.processException(ioe, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "830");
            throw errorReport;
        }
        catch (UnavailableException ue) {
            ServletErrorReport errorReport = null;
            boolean caughtUEIsInstanceOfWUE = false;
            if (discernUnavailableServlet) {
                caughtUEIsInstanceOfWUE = ue instanceof WebContainerUnavailableException;
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "UnavailableException Caught : caughtUEIsInstanceOfWUE=" + caughtUEIsInstanceOfWUE + ", discernUnavailableServlet=" + discernUnavailableServlet + ", state = " + this.getStateString(this.state));
            }
            try {
                errorReport = WebAppErrorReport.constructErrorReport((Throwable)ue, dispatchContext.getCurrentServletReference());
                boolean UEfromService = false;
                if (destroyServletonServiceUnavailableException) {
                    WebContainerRequestState ueState = WebContainerRequestState.getInstance(true);
                    if (ueState != null && ueState.getAttribute("UEinService") != null) {
                        UEfromService = true;
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "UnavailableException Caught, getAttribute(UEinService): forward--> " + isForward + " ,include -->" + isInclude);
                        }
                        if (!isInclude && !isForward) {
                            ueState.removeAttribute("UEinService");
                        }
                    } else if (ueState != null && ueState.getAttribute("UEinInit") != null) {
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "UnavailableException Caught, getAttribute(UEinInit): forward--> " + isForward + "include -->" + isInclude);
                        }
                        if (!isInclude && !isForward) {
                            ueState.removeAttribute("UEinInit");
                        }
                    }
                }
                if (!UEfromService && reInitServletonInitUnavailableException && this.state == this.AVAILABLE_STATE) {
                    this.state = (byte)this.UNINITIALIZED_STATE;
                }
                if (!caughtUEIsInstanceOfWUE && this.state != -1) {
                    this.handleUnavailableException(ue, false);
                }
                if (isInclude || isForward) {
                    throw ue;
                }
                if (this.isRethrowOriginalException(req, isInclude, isForward)) {
                    throw ue;
                }
            }
            catch (UnavailableException une) {
                if (this.isRethrowOriginalException(req, isInclude, isForward)) {
                    if (discernUnavailableServlet) {
                        if (une instanceof WebContainerUnavailableException) {
                            throw une;
                        }
                        if (isTraceOn && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Create WebContainerUnavailableException");
                        }
                        throw WebContainerUnavailableException.create(ue);
                    }
                    throw une;
                }
                errorReport = WebAppErrorReport.constructErrorReport((Throwable)une, dispatchContext.getCurrentServletReference());
            }
            finally {
                if (!(caughtUEIsInstanceOfWUE && servletCalled || ue.isPermanent() || this.state != this.UNAVAILABLE_STATE && this.state != this.UNINITIALIZED_STATE)) {
                    httpResponse.setHeader("Retry-After", String.valueOf(ue.getUnavailableSeconds()));
                }
                dispatchContext.pushException(ue);
                FFDCWrapper.processException(ue, "com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", "302");
            }
            throw errorReport;
        }
        finally {
            dispatchContext.popServletReference();
            if (!(this.context.getJSPClassLoaderLimit() <= 0 || this.context.getJSPClassLoaderExclusionList() != null && this.context.getJSPClassLoaderExclusionList().contains(httpRequest.getRequestURI()) || !this.context.isJSPClassLoaderLimitTrackIF() && (isInclude || isForward))) {
                ClassLoader cl = this.getTargetClassLoader();
                Class jspClassLoaderClassName = this.context.getJSPClassLoaderClassName();
                if (cl != null && cl.getClass().isAssignableFrom(jspClassLoaderClassName)) {
                    this.context.addAndCheckJSPClassLoaderLimit(this);
                }
            }
            if (isTraceOn && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleRequest");
            }
        }
    }

    private boolean isRethrowOriginalException(ServletRequest req, boolean isInclude, boolean isForward) {
        return (isInclude || isForward) && req.getAttribute("com.ibm.wsspi.webcontainer.ignoreDispatchState") == null;
    }

    protected Object getTransaction() throws Exception {
        return null;
    }

    protected void checkTransaction(Object transaction) {
    }

    protected void checkForRollback() {
    }

    public void addCommand(Command command) {
    }

    @Override
    public String getName() {
        if (this.servletConfig == null) {
            return null;
        }
        return this.servletConfig.getServletName();
    }

    public void removeCommand(Command command) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doDestroy() {
        block51: {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.entering(CLASS_NAME, "doDestroy " + this.toString());
            }
            if (this.state != this.UNINITIALIZED_STATE) {
                HandleList _connectionHandleList;
                TxCollaboratorConfig txConfig;
                Object secObject;
                block49: {
                    Throwable t;
                    if (this.context != null && this.target != null && (t = this.context.invokeAnnotTypeOnObjectAndHierarchy(this.target, WebApp.ANNOT_TYPE.PRE_DESTROY)) != null && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "Exception caught during preDestroy processing: " + t);
                    }
                    WebComponentMetaData cmd = null;
                    cmd = this.servletConfig.getMetaData();
                    secObject = null;
                    txConfig = null;
                    _connectionHandleList = this.connCollab == null ? null : new HandleList();
                    this.webAppNameSpaceCollab.preInvoke(cmd);
                    secObject = this.collabHelper.getSecurityCollaborator().preInvoke(this.servletConfig.getServletName());
                    this.collabHelper.doInvocationCollaboratorsPreInvoke(this.webAppInvocationCollaborators, this.getWebApp().getWebAppCmd());
                    txConfig = this.txCollab.preInvoke(null, this.servlet23);
                    if (this.connCollab != null) {
                        this.connCollab.preInvoke(_connectionHandleList, true);
                    }
                    this.deregisterMBean();
                    ClassLoader origClassLoader = null;
                    try {
                        origClassLoader = ThreadContextHelper.getContextClassLoader();
                        ClassLoader warClassLoader = this.context.getClassLoader();
                        if (warClassLoader != origClassLoader) {
                            ThreadContextHelper.setClassLoader(warClassLoader);
                        } else {
                            origClassLoader = null;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "Servlet.unload.initiated:.{0}", this.getServletName());
                        }
                        this.setUnavailable();
                        this.evtSource.onServletStartDestroy(this.getServletEvent());
                        for (int i = 0; this.nServicing.get() > 0 && i < WCCustomProperties.SERVLET_DESTROY_WAIT_TIME; ++i) {
                            try {
                                if (i == 0) {
                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "servlet is still servicing...will wait up to 60 seconds for servlet to become idle: {0}", this.getServletName());
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "Waiting.servlet.to.finish.servicing.requests:.{0}", this.getServletName());
                                    }
                                }
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "377", this);
                            }
                        }
                        if (this.nServicing.get() > 0 && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "Servlet.wait.for.destroy.timeout.has.expired,.destroy.will.be.forced:.{0}", this.getServletName());
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "enter Servlet.destroy(): {0}", this.getServletName());
                        }
                        if (this.target != null) {
                            this.target.destroy();
                            logger.logp(Level.INFO, CLASS_NAME, "doDestroy", "[{0}].Destroy.successful", new Object[]{this.getServletName(), this.context.getContextPath(), this.context.getApplicationName()});
                        }
                        this.evtSource.onServletFinishDestroy(this.getServletEvent());
                        this.evtSource.onServletUnloaded(this.getServletEvent());
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "Servlet.unloaded:.{0}", this.getServletName());
                        }
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                    finally {
                        if (origClassLoader != null) {
                            ClassLoader fOrigClassLoader = origClassLoader;
                            ThreadContextHelper.setClassLoader(fOrigClassLoader);
                        }
                    }
                    if (this.connCollab == null) break block49;
                    try {
                        this.connCollab.postInvoke(_connectionHandleList, true);
                    }
                    catch (CSIException e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "260", this);
                    }
                }
                try {
                    this.txCollab.postInvoke(null, txConfig, this.servlet23);
                }
                catch (Exception e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "268", this);
                }
                this.collabHelper.doInvocationCollaboratorsPostInvoke(this.webAppInvocationCollaborators, this.getWebApp().getWebAppCmd());
                try {
                    this.collabHelper.getSecurityCollaborator().postInvoke(secObject);
                }
                catch (Exception e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "325", this);
                }
                this.webAppNameSpaceCollab.postInvoke();
                break block51;
                catch (Throwable e) {
                    block50: {
                        try {
                            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.destroy", "403", this);
                            logger.logp(Level.SEVERE, CLASS_NAME, "doDestroy", "Uncaught.destroy().exception.thrown.by.servlet", new Object[]{this.getServletName(), this.getWebApp().getApplicationName(), e});
                            this.evtSource.onServletDestroyError(new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e));
                            this.context.log("Error occurred while destroying servlet", e);
                            if (this.connCollab == null) break block50;
                        }
                        catch (Throwable throwable) {
                            if (this.connCollab != null) {
                                try {
                                    this.connCollab.postInvoke(_connectionHandleList, true);
                                }
                                catch (CSIException e2) {
                                    FFDCWrapper.processException(e2, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "260", this);
                                }
                            }
                            try {
                                this.txCollab.postInvoke(null, txConfig, this.servlet23);
                            }
                            catch (Exception e3) {
                                FFDCWrapper.processException(e3, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "268", this);
                            }
                            this.collabHelper.doInvocationCollaboratorsPostInvoke(this.webAppInvocationCollaborators, this.getWebApp().getWebAppCmd());
                            try {
                                this.collabHelper.getSecurityCollaborator().postInvoke(secObject);
                            }
                            catch (Exception e4) {
                                FFDCWrapper.processException(e4, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "325", this);
                            }
                            this.webAppNameSpaceCollab.postInvoke();
                            throw throwable;
                        }
                        try {
                            this.connCollab.postInvoke(_connectionHandleList, true);
                        }
                        catch (CSIException e5) {
                            FFDCWrapper.processException(e5, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "260", this);
                        }
                    }
                    try {
                        this.txCollab.postInvoke(null, txConfig, this.servlet23);
                    }
                    catch (Exception e6) {
                        FFDCWrapper.processException(e6, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "268", this);
                    }
                    this.collabHelper.doInvocationCollaboratorsPostInvoke(this.webAppInvocationCollaborators, this.getWebApp().getWebAppCmd());
                    try {
                        this.collabHelper.getSecurityCollaborator().postInvoke(secObject);
                    }
                    catch (Exception e7) {
                        FFDCWrapper.processException(e7, "com.ibm.ws.webcontainer.servlet.ServletWrapper.doDestroy", "325", this);
                    }
                    this.webAppNameSpaceCollab.postInvoke();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doDestroy", "exit Servlet.destroy(): {0}", this.getServletName());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doDestroy");
        }
    }

    @Override
    public void prepareForReload() {
        this.doDestroy();
        this.target = null;
        this.targetLoader = null;
        this.state = (byte)this.UNINITIALIZED_STATE;
    }

    @Override
    public void destroy() {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "destroy", "servlet destroy for -->" + this.getServletName() + ", state is -->" + this.getStateString(this.state));
            }
            try {
                if (this.state == -1 || this.state == 2) break block9;
                try {
                    this.doDestroy();
                }
                catch (Throwable th) {
                    try {
                        FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.servlet.ServletWrapper.destroy", "1152", this);
                        logger.logp(Level.SEVERE, CLASS_NAME, "destroy", "Exception.occured.during.servlet.destroy", th);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.state = (byte)this.UNAVAILABLE_PERMANENTLY_STATE;
                    }
                }
                this.state = (byte)this.UNAVAILABLE_PERMANENTLY_STATE;
            }
            finally {
                this.invalidateCacheWrappers();
            }
        }
    }

    @Override
    public IServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getName() + ":" + this.servletConfig.getClassName();
    }

    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        WebAppServletInvocationEvent evt = null;
        if (this.notifyInvocationListeners) {
            evt = new WebAppServletInvocationEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), req, res);
        }
        this.service(req, res, evt);
    }

    public void service(ServletRequest req, ServletResponse res, WebAppServletInvocationEvent evt) throws ServletException, IOException {
        boolean notify;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "service " + this.toString() + " ,req-->" + req + " ,res-->" + res);
        }
        boolean bl = notify = this.notifyInvocationListeners && evt != null;
        if (this.unavailableUntil != -1L) {
            this.lastAccessTime = System.currentTimeMillis();
            long timeDiff = this.unavailableUntil - this.lastAccessTime;
            if (timeDiff <= 0L) {
                this.setAvailable();
            } else {
                int timeLeft = (int)timeDiff / 1000;
                if (timeLeft == 0) {
                    timeLeft = 1;
                }
                throw new UnavailableException(this.unavailableMessage, timeLeft);
            }
        }
        try {
            if (this.target == null) {
                this.load();
            }
            try {
                if (notify) {
                    this.evtSource.onServletStartService(evt);
                }
            }
            finally {
                this.nServicing.getAndIncrement();
            }
            if (notify) {
                long curLastAccessTime;
                this.lastAccessTime = curLastAccessTime = System.currentTimeMillis();
                this.target.service(req, res);
                long endTime = System.currentTimeMillis();
                evt.setResponseTime(endTime - curLastAccessTime);
                this.evtSource.onServletFinishService(evt);
            } else {
                this.target.service(req, res);
            }
        }
        catch (UnavailableException e) {
            WebContainerRequestState UEServiceRequestState;
            if (destroyServletonServiceUnavailableException && (UEServiceRequestState = WebContainerRequestState.getInstance(true)).getAttribute("UEinInit") == null) {
                UEServiceRequestState.setAttribute("UEinService", true);
            }
            throw e;
        }
        catch (IOException ioe) {
            if (com.ibm.ws.webcontainer.osgi.WebContainer.getServletContainerSpecLevel() >= 31 && ioe.getMessage() != null && ioe.getMessage().contains("SRVE0918E")) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "service", "Caught BlockingWriteNotAllowedException for servlet [" + this.getServletName() + "]");
                }
            } else if (ioe instanceof ClosedConnectionException) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "service", "Caught ClosedConnectionException for servlet [" + this.getServletName() + "]");
                }
            } else {
                ApplicationErrorUtils.issueAppExceptionMessage("SRVE0777E", ioe);
            }
            if (notify) {
                ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), ioe);
                this.evtSource.onServletServiceError(errorEvent);
                this.evtSource.onServletFinishService(evt);
            }
            throw ioe;
        }
        catch (ServletException e) {
            if (!suppressServletExceptionLogging) {
                ApplicationErrorUtils.issueAppExceptionMessage("SRVE0777E", e);
            }
            if (notify) {
                ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e);
                this.evtSource.onServletServiceError(errorEvent);
                this.evtSource.onServletFinishService(evt);
            }
            throw e;
        }
        catch (UnsatisfiedLinkError e) {
            logger.logp(Level.SEVERE, CLASS_NAME, "service", "Place.servlet.class.on.classpath.of.the.application.server", new Object[]{this.getServletName(), this.getWebApp().getApplicationName(), e});
            if (notify) {
                ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e);
                this.evtSource.onServletServiceError(errorEvent);
                this.evtSource.onServletFinishService(evt);
            }
            throw new ServletException((Throwable)e);
        }
        catch (RuntimeException e) {
            if (!WCCustomProperties.SUPPRESS_LOGGING_SERVICE_RUNTIME_EXCEP) {
                ApplicationErrorUtils.issueAppExceptionMessage("SRVE0777E", e);
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "service", "Exception thrown while servicing the application servlet -->" + e.toString());
            }
            if (notify) {
                ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e);
                this.evtSource.onServletServiceError(errorEvent);
                this.evtSource.onServletFinishService(evt);
            }
            throw e;
        }
        catch (Throwable e) {
            ApplicationErrorUtils.issueAppExceptionMessage("SRVE0777E", e);
            if (notify) {
                this.evtSource.onServletFinishService(evt);
                ServletErrorEvent errorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), this.servletConfig.getClassName(), e);
                this.evtSource.onServletServiceError(errorEvent);
            }
            throw new ServletErrorReport(e);
        }
        finally {
            WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
            if (reqState != null && reqState.getAttribute("webcontainer.resetAsyncStartedOnExit") != null) {
                ServletUtil.unwrapRequest(req).setAsyncStarted(false);
                reqState.removeAttribute("webcontainer.resetAsyncStartedOnExit");
            }
            this.nServicing.getAndDecrement();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "service");
            }
        }
    }

    @Override
    public void initialize(IServletConfig config) throws Exception {
        this.servletConfig = config;
        this.webAppInvocationCollaborators = this.context.getWebAppInvocationCollaborators();
    }

    @Override
    public void loadOnStartupCheck() throws Exception {
        if (this.servletConfig.isLoadOnStartup()) {
            try {
                this.loadServlet();
            }
            catch (UnavailableException ue) {
                this.handleUnavailableException(ue, false);
                if (discernUnavailableServlet) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "handleRequest", "Create WebContainerUnavailableException");
                    }
                    throw WebContainerUnavailableException.create(ue);
                }
                throw ue;
            }
            this.init(this.servletConfig);
        }
    }

    @Override
    public void load() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "load");
        }
        this.loadServlet();
        if (this.target != null) {
            this.init(this.servletConfig);
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "load", "unable to load servlet's target so skipping init");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "load");
        }
    }

    public void unload() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "unload className-->[" + this.servletConfig.getClassName() + "], servletName[" + this.servletConfig.getServletName() + "]");
        }
        if (this.state == -1) {
            return;
        }
        try {
            this.doDestroy();
        }
        catch (Throwable th) {
            FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.servlet.ServletWrapper.unload", "1511", this);
            logger.logp(Level.SEVERE, CLASS_NAME, "unload", "Exception.occured.during.servlet.unload", th);
        }
        finally {
            this.invalidateCacheWrappers();
            this.state = (byte)-1;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "unload");
        }
    }

    protected synchronized Servlet loadServlet() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "loadServlet, className-->[" + this.servletConfig.getClassName() + "], servletName[" + this.servletConfig.getServletName() + "]");
        }
        if (this.target != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "loadServlet, Found target for className-->[" + this.servletConfig.getClassName() + "], servletName[" + this.servletConfig.getServletName() + "]");
            }
            return this.target;
        }
        Servlet servlet = this.servletConfig.getServlet();
        if (servlet != null) {
            this.target = servlet;
            return this.target;
        }
        final Class<? extends Servlet> servletClass = this.servletConfig.getServletClass();
        final String className = this.servletConfig.getClassName();
        final String servletName = this.servletConfig.getServletName();
        if (className == null) {
            logger.logp(Level.WARNING, CLASS_NAME, "run", "servlet.classname.is.null", new Object[]{servletName});
            return null;
        }
        ClassLoader origClassLoader = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            ClassLoader loader;
            origClassLoader = ThreadContextHelper.getContextClassLoader();
            if (this.targetLoader == null) {
                loader = this.context.getClassLoader();
                this.setTargetClassLoader(loader);
            } else {
                loader = this.targetLoader;
            }
            if (loader != origClassLoader) {
                ThreadContextHelper.setClassLoader(loader);
            } else {
                origClassLoader = null;
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ServletException {
                    try {
                        Servlet s = null;
                        if (className.equals("com.ibm.ws.webcontainer.servlet.SimpleFileServlet")) {
                            s = ServletWrapper.this.context.getSimpleFileServlet();
                            ServletWrapper.this.createTarget(s);
                        } else if (className.equals("com.ibm.ws.webcontainer.servlet.DirectoryBrowsingServlet")) {
                            s = ServletWrapper.this.context.getDirectoryBrowsingServlet();
                            ServletWrapper.this.createTarget(s);
                        } else if (servletClass != null) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, ServletWrapper.CLASS_NAME, "loadServlet:run", "Use CDI to create servlet from servletClass:" + servletClass);
                            }
                            ServletWrapper.this.createTarget(servletClass);
                        } else {
                            String serializedName = className.replace('.', '/').concat(".ser");
                            if (loader.getResourceAsStream(serializedName) != null) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, ServletWrapper.CLASS_NAME, "loadServlet:run", "A serialized object exists. Create an instance of it : " + serializedName);
                                }
                                s = (Servlet)Beans.instantiate(loader, className);
                                ServletWrapper.this.createTarget(s);
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, ServletWrapper.CLASS_NAME, "loadServlet:run", "use CDI to create servlet from className:" + className);
                                }
                                Class<?> sclass = loader.loadClass(className);
                                ServletWrapper.this.createTarget(sclass);
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", "208", this);
                        logger.logp(Level.SEVERE, ServletWrapper.CLASS_NAME, "run", "classnotfoundexception.loading.servlet.class", e);
                        throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.Could.not.find.required.servlet.class", "Servlet [{0}]: Could not find required servlet - {1}"), className, e.getMessage()));
                    }
                    catch (ClassCastException e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", "213", this);
                        throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.not.a.servlet.class", "Servlet [{0}]: not a servlet class"), className));
                    }
                    catch (NoClassDefFoundError e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", "218", this);
                        throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.was.found.but.is.missing.another.required.class", "Servlet [{0}]: {1} was found, but is missing another required class.\n"), servletName, className) + nls.getString("This.error.implies.servlet.was.originally.compiled.with.classes.which.cannot.be.located.by.server", "This error typically implies that the servlet was originally compiled with classes which cannot be located by the server.\n") + nls.getString("Check.your.classpath.ensure.all.classes.present", "Check your classpath to ensure that all classes required by the servlet are present.\n") + nls.getString("be.debugged.by.recompiling.the.servlet.using.only.the.classes.in.the.application's.runtime.classpath", "\n  This problem can be debugged by recompiling the servlet using only the classes in the application's runtime classpath\n") + MessageFormat.format(nls.getString("Application.classpath", "Application classpath=[{0}]"), ServletWrapper.this.context.getClasspath()));
                    }
                    catch (ClassFormatError e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", "227", this);
                        throw new UnavailableException(MessageFormat.format(nls.getString("Servlet.found.but.corrupt", "Servlet [{0}]: {1} was found, but is corrupt:\n"), servletName, className) + nls.getString("class.resides.in.proper.package.directory", "1. Check that the class resides in the proper package directory.\n") + nls.getString("classname.defined.in.server.using.proper.case.and.fully.qualified.package", "2. Check that the classname has been defined in the server using the proper case and fully qualified package.\n") + nls.getString("class.transfered.using.binary.mode", "3. Check that the class was transfered to the filesystem using a binary tranfer mode.\n") + nls.getString("class.compiled.using.proper.case", "4. Check that the class was compiled using the proper case (as defined in the class definition).\n") + nls.getString("class.not.renamed.after.compiled", "5. Check that the class file was not renamed after it was compiled."));
                    }
                    catch (IOException e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", "1349", this);
                        throw new ServletException(MessageFormat.format(nls.getString("IOException.loading.servlet"), servletName, className), (Throwable)e);
                    }
                    catch (InjectionException ie) {
                        FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", (String)"228", (Object)this);
                        logger.logp(Level.SEVERE, ServletWrapper.CLASS_NAME, "init", "Servlet.found.but.injection.failure", new Object[]{servletName, className, ie.getLocalizedMessage()});
                        String string = nls.getString("Servlet.found.but.injection.failure", "SRVE0319E: For the [{0}] servlet, {1} servlet class was found, but a resource injection failure has occurred. {2}");
                        String s = MessageFormat.format(string, servletName, className, ie.getLocalizedMessage());
                        throw new UnavailableException(s);
                    }
                    catch (IllegalAccessException e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", "1349", this);
                        throw new ServletException(MessageFormat.format(nls.getString("IllegalAccessException.loading.servlet"), servletName, className), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.servlet.ServletWrapper.loadServlet", "1349", this);
                        throw new ServletException(MessageFormat.format(nls.getString("InstantiationException.loading.servlet"), servletName, className), (Throwable)e);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.exiting(ServletWrapper.CLASS_NAME, "loadServlet");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable th = e.getCause();
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw new Exception(th);
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
            if (origClassLoader != null) {
                ClassLoader fOrigClassLoader = origClassLoader;
                ThreadContextHelper.setClassLoader(fOrigClassLoader);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "loadServlet");
            }
        }
        return this.target;
    }

    private ServletEvent getServletEvent() {
        if (this.event == null) {
            this.event = new ServletEvent(this, this.servletConfig.getServletContext(), this.servletConfig.getServletName(), this.servletConfig.getClassName());
        }
        return this.event;
    }

    private synchronized void handleUnavailableException(UnavailableException e, boolean isInit) throws UnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "handleUnavailableException", (Object)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "handleUnavailableException", "UnavailableException was thrown by servlet: " + this.getServletName() + " reason:" + e.getMessage());
        }
        if (this.state == 2) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "handleUnavailableException", "state is already permanently unavailable, throw ue");
            }
            throw new UnavailableException(this.unavailableMessage);
        }
        if (e.isPermanent()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleUnavailableException", "exception is permanent");
            }
            if (this.state == 0) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleUnavailableException", "state is available so destroy the servlet");
                }
                if (!this.context.removeServlet(this.getServletName())) {
                    // empty if block
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "handleUnavailableException", "removeServlet didn't destroy. destroy from handleUnavailableException");
                }
                this.destroy();
            }
            this.unavailableMessage = e.getMessage();
            if (isInit) {
                this.setUninitialize();
            } else {
                this.setUnavailable();
            }
        } else {
            long time;
            int secs = e.getUnavailableSeconds();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "handleUnavailableException", "ue is not permanent, unavailable secs -->[" + secs + "]");
            }
            if (secs > 0 && (time = System.currentTimeMillis() + (long)(secs * 1000)) > this.unavailableUntil) {
                this.unavailableMessage = e.getMessage();
                this.setUnavailableUntil(time, isInit);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "handleUnavailableException");
        }
    }

    private void setUnavailableUntil(long time, boolean isInit) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setUnavailableUntil", "setUnavailableUntil() : " + time);
        }
        this.state = isInit ? (byte)-1 : (byte)1;
        this.unavailableUntil = time;
        this.evtSource.onServletUnavailableForService(this.getServletEvent());
    }

    protected void setUninitialize() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setUninitialized ", "" + this.toString());
        }
        this.state = (byte)-1;
    }

    protected void setUnavailable() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setUnavailable", "" + this.toString());
        }
        this.state = (byte)2;
        this.evtSource.onServletUnavailableForService(this.getServletEvent());
    }

    private void setAvailable() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "setAvailable " + this.toString());
        }
        this.evtSource.onServletAvailableForService(this.getServletEvent());
        this.state = 0;
        this.unavailableMessage = null;
        this.unavailableUntil = -1L;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "setAvailable");
        }
    }

    protected synchronized void invalidateCacheWrappers() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "invalidateCacheWrappers");
        }
        if (this.cacheWrappers != null) {
            for (ServletReferenceListener w : this.cacheWrappers) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "invalidateCacheWrappers", "servlet reference listener -->[" + w + "]");
                }
                w.invalidate();
            }
            this.cacheWrappers = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "invalidateCacheWrappers");
        }
    }

    @Override
    public void addSubContainer(Container con) {
    }

    @Override
    public Container getParent() {
        return this.context;
    }

    @Override
    public Container getSubContainer(String name) {
        return null;
    }

    @Override
    public void initialize(Configuration config) {
    }

    public boolean isActive() {
        return this.state != -1;
    }

    @Override
    public boolean isAlive() {
        return this.state != this.UNAVAILABLE_PERMANENTLY_STATE && this.state != this.UNAVAILABLE_STATE;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public Container removeSubContainer(String name) {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Iterator subContainers() {
        return null;
    }

    public void execute(IExtendedRequest req, IExtendedResponse res) {
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public WebApp getWebApp() {
        return this.context;
    }

    @Override
    public String getServletName() {
        if (this.servletConfig == null) {
            return null;
        }
        return this.servletConfig.getServletName();
    }

    public String getMetricsKey() {
        return this.metricsKey;
    }

    private IServletWrapper getMimeFilterWrapper(String mimeType) {
        try {
            if (mimeType.indexOf(";") != -1) {
                mimeType = mimeType.substring(0, mimeType.indexOf(";"));
            }
            return this.context.getMimeFilterWrapper(mimeType);
        }
        catch (ServletException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.webcontainer.servlet.ServletWrapper.getMimeFilterWrapper", (String)"834", (Object)this);
            this.context.logError("Failed to load filter for mime-type: " + mimeType, e);
            return null;
        }
    }

    private void transferHeadersFromPrevChainedResp(ChainedResponse current, ChainedResponse previous) {
        Collection headers = previous.getHeaderNames();
        for (String name : headers) {
            String value = previous.getHeader(name);
            current.setHeader(name, value);
        }
        Cookie[] theCookies = previous.getCookies();
        for (int i = 0; i < theCookies.length; ++i) {
            Cookie currCookie = theCookies[i];
            current.addCookie(currCookie);
        }
    }

    @Override
    public synchronized void addServletReferenceListener(ServletReferenceListener listener) {
        if (this.cacheWrappers == null) {
            this.cacheWrappers = new ArrayList();
        }
        this.cacheWrappers.add(listener);
    }

    @Override
    public void setTargetClassLoader(ClassLoader loader) {
        this.targetLoader = loader;
    }

    @Override
    public Servlet getTarget() {
        return this.target;
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return this.targetLoader;
    }

    @Override
    public void setTarget(Servlet target) {
        this.target = target;
    }

    public String toString() {
        Collection mappings = null;
        if (this.state == 2) {
            return "ServletWrapper[Servlet is permanently unavailable]";
        }
        if (this.servletConfig != null) {
            mappings = this.servletConfig.getMappings();
        }
        return "ServletWrapper[" + this.getServletName() + ":" + mappings + "]";
    }

    @Override
    public boolean hitWarningStatus() {
        if (!this.warningStatusSet) {
            this.warningStatusSet = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    protected synchronized void createTarget(Servlet s) throws InjectionException {
        if (com.ibm.ws.webcontainer.osgi.WebContainer.getServletContainerSpecLevel() < 60 && s instanceof SingleThreadModel) {
            this.isSTM = true;
            this.servletConfig.setSingleThreadModelServlet(this.isSTM);
            this.target = new SingleThreadModelServlet(s.getClass());
        } else {
            this.target = s;
        }
    }

    protected void createTarget(Class<?> Klass) throws InjectionException, InstantiationException, IllegalAccessException {
        this.createTarget((Servlet)Klass.newInstance());
    }

    public boolean isDefaultServlet() {
        boolean result = false;
        if (this.servletConfig != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isDefaultServlet", " : mappings:" + this.servletConfig.getMappings());
            }
            for (String curMapping : this.servletConfig.getMappings()) {
                if (!curMapping.equals("/")) continue;
                result = true;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() & logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isDefaultServlet", " result=" + result);
        }
        return result;
    }

    @Override
    public boolean isInternal() {
        return this.servletConfig.isInternal();
    }

    @Override
    public void modifyTarget(Servlet s) {
    }

    public void startRequest(ServletRequest request) {
        boolean checkTraceRequest;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "startRequest", "state = " + this.getStateString(this.state));
        }
        HttpServletRequest httpServletReq = ServletUtil.unwrapRequest(request, HttpServletRequest.class);
        String method = httpServletReq.getMethod();
        boolean checkHeadRequest = !defaultHeadRequestBehavior && method.equals("HEAD");
        boolean bl = checkTraceRequest = !defaultTraceRequestBehavior && method.equals("TRACE");
        if (checkHeadRequest || checkTraceRequest) {
            if (this.checkedForDefaultMethods == null) {
                this.checkForDefaultImplementation();
                this.checkedForDefaultMethods = new Boolean(Boolean.TRUE);
            }
            if (checkHeadRequest && this.defaultHeadMethodInUse) {
                request.setAttribute("com.ibm.ws.webcontainer.security.checkdefaultmethod", (Object)"HEAD");
            } else if (checkTraceRequest && this.defaultTraceMethodInUse) {
                request.setAttribute("com.ibm.ws.webcontainer.security.checkdefaultmethod", (Object)"TRACE");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "startRequest", " method = " + method);
        }
    }

    public void finishRequest(ServletRequest request) {
        request.removeAttribute("com.ibm.ws.webcontainer.security.checkdefaultmethod");
    }

    public void checkForDefaultImplementation() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.entering(CLASS_NAME, "checkForDefaultMethods", "already checked = " + this.checkedForDefaultMethods);
            }
            if (this.checkedForDefaultMethods == null) {
                final String targetClassName = this.servletConfig.getClassName();
                final ClassLoader targetClassLoader = this.context.getClassLoader();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            Class<?> targetClass;
                            try {
                                targetClass = Class.forName(targetClassName, false, targetClassLoader);
                            }
                            catch (ClassNotFoundException exc) {
                                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                    logger.logp(Level.FINE, ServletWrapper.CLASS_NAME, "checkForDefaultMethods", "Class not found when checking for default implementations. Class = " + targetClassName);
                                }
                                return null;
                            }
                            if (!defaultHeadRequestBehavior) {
                                ServletWrapper.this.defaultHeadMethodInUse = ServletWrapper.this.checkForDefaultImplementation(targetClass, "doHead", PARAMS_HEAD_TRACE);
                            }
                            if (!defaultTraceRequestBehavior) {
                                ServletWrapper.this.defaultTraceMethodInUse = ServletWrapper.this.checkForDefaultImplementation(targetClass, "doTrace", PARAMS_HEAD_TRACE);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException exc) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block5;
                    logger.logp(Level.FINE, CLASS_NAME, "checkForDefaultMethods", "PrivelegedActionException when checking for default implementations. Class = " + targetClassName);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "checkForDefaultMethods", "Default's in use? doHead = " + (defaultHeadRequestBehavior ? "not checked" : (this.defaultHeadMethodInUse ? "true" : "false")) + ", doTrace = " + (defaultTraceRequestBehavior ? "not checked" : (this.defaultTraceMethodInUse ? "true" : "false")));
        }
    }

    private boolean checkForDefaultImplementation(Class checkClass, String checkMethod, Class[] methodParams) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "checkForDefaultImplementation", "Method : " + checkMethod + ", Class : " + checkClass.getName());
        }
        boolean defaultMethodInUse = true;
        while (defaultMethodInUse && checkClass != null && !checkClass.getName().equals("javax.servlet.http.HttpServlet")) {
            block8: {
                try {
                    checkClass.getDeclaredMethod(checkMethod, methodParams);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "checkForDefaultImplementation", "Class implementing " + checkMethod + " is " + checkClass.getName());
                    }
                    defaultMethodInUse = false;
                    break;
                }
                catch (NoSuchMethodException exc) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "checkForDefaultImplementation", checkMethod + " is not implemented by class " + checkClass.getName());
                    }
                }
                catch (SecurityException exc) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block8;
                    logger.logp(Level.FINE, CLASS_NAME, "checkForDefaultImplementation", "Cannot determine if " + checkMethod + " is implemented by class " + checkClass.getName());
                }
            }
            checkClass = checkClass.getSuperclass();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "checkForDefaultImplementation", "Result : " + defaultMethodInUse);
        }
        return defaultMethodInUse;
    }

    private String getStateString(byte state) {
        switch (state) {
            case 0: {
                return "Available";
            }
            case -1: {
                return "Uninitialized";
            }
            case 1: {
                return "Unavailable";
            }
            case 2: {
                return "Permanently unavailable";
            }
        }
        return "" + state;
    }
}

