/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.ScheduledCustomExecutorTask;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import io.openliberty.concurrent.internal.cdi.ConcurrencyExtensionMetadata;
import io.openliberty.concurrent.internal.cdi.interceptor.AsyncInterceptor;
import io.openliberty.concurrent.internal.cdi.interceptor.ScheduleCronTrigger;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ScheduledAsyncMethod
implements Callable<CompletableFuture<Object>>,
ScheduledCustomExecutorTask {
    private static final TraceComponent tc = Tr.register(ScheduledAsyncMethod.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    static final ThreadLocal<CompletableFuture<?>> inlineExecutionFuture = new ThreadLocal();
    private final ThreadContextDescriptor contextDescriptor;
    private final InvocationContext firstInvocation;
    final CompletableFuture<Object> future;
    private final AsyncInterceptor interceptor;
    private boolean isFirstExecution = true;
    private long nextExecutionSkipIfLateBySeconds;
    private ZonedDateTime nextExecutionTime;
    private final List<Long> skipIfLateBySeconds;
    private final List<ScheduleCronTrigger> triggers;
    private final Executor virtualThreadExecutor;
    static final long serialVersionUID = -9192240494861909360L;

    ScheduledAsyncMethod(InvocationContext firstInvocation, AsyncInterceptor interceptor, WSManagedExecutorService managedExecutor, List<ScheduleCronTrigger> triggers, List<Long> skipIfLateBySeconds) {
        this.contextDescriptor = managedExecutor.captureThreadContext(null);
        this.firstInvocation = firstInvocation;
        this.future = ((ManagedExecutorService)managedExecutor).newIncompleteFuture();
        this.interceptor = interceptor;
        this.triggers = triggers;
        this.skipIfLateBySeconds = skipIfLateBySeconds;
        this.virtualThreadExecutor = managedExecutor.getNormalPolicyExecutor().getVirtualThreadExecutor();
        ConcurrencyExtensionMetadata.scheduledExecutor.schedule(this, this.computeDelayNanos(), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public CompletableFuture<Object> call() {
        CompletionStage cs;
        Throwable failure;
        boolean trace;
        block53: {
            Method method = this.firstInvocation.getMethod();
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)("call " + method.getName() + "(" + Arrays.toString(method.getGenericParameterTypes()) + ")"), (Object[])new Object[]{method.getDeclaringClass().getName(), method.getGenericReturnType().getTypeName()});
            }
            if (this.future.isDone()) {
                if (!trace) return this.future;
                if (!tc.isEntryEnabled()) return this.future;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"call: ignore, already complete");
                return this.future;
            }
            long secondsLate = this.nextExecutionTime.until(ZonedDateTime.now(this.nextExecutionTime.getZone()), ChronoUnit.SECONDS);
            if (secondsLate > this.nextExecutionSkipIfLateBySeconds) {
                try {
                    long delayNanos = this.computeDelayNanos();
                    ConcurrencyExtensionMetadata.scheduledExecutor.schedule(this, delayNanos, TimeUnit.NANOSECONDS);
                    if (!trace) return this.future;
                    if (!tc.isEntryEnabled()) return this.future;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)("call: skip because late by " + secondsLate + " seconds"));
                    return this.future;
                }
                catch (Throwable x2) {
                    FFDCFilter.processException((Throwable)x2, (String)this.getClass().getName(), (String)"128", (Object)this);
                    this.future.completeExceptionally(x2);
                    if (!trace) return this.future;
                    if (!tc.isEntryEnabled()) return this.future;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"call", (Object)x2);
                }
                return this.future;
            }
            failure = null;
            ArrayList contextApplied = null;
            cs = null;
            try {
                if (this.contextDescriptor != null) {
                    contextApplied = this.contextDescriptor.taskStarting();
                }
                if (this.isFirstExecution) {
                    try {
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("proceed with " + method.getName()), (Object[])new Object[0]);
                        }
                        cs = this.interceptor.invoke(this.firstInvocation, this.future);
                    }
                    finally {
                        this.isFirstExecution = false;
                    }
                }
                inlineExecutionFuture.set(this.future);
                try {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("invoke " + method.getName() + " on bean instance"), (Object[])this.firstInvocation.getParameters());
                    }
                    method.setAccessible(true);
                    cs = (CompletionStage)method.invoke(this.firstInvocation.getTarget(), this.firstInvocation.getParameters());
                }
                finally {
                    inlineExecutionFuture.remove();
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("completion stage from invocation is " + String.valueOf(cs)), (Object[])new Object[0]);
                }
            }
            catch (Throwable x32) {
                try {
                    boolean appException = false;
                    failure = x32;
                    if (failure instanceof InvocationTargetException) {
                        appException = true;
                        failure = failure.getCause();
                    }
                    if (failure instanceof CompletionException) {
                        appException = true;
                        if (failure.getCause() != null) {
                            failure = failure.getCause();
                        }
                    }
                    if (!appException) {
                        FFDCFilter.processException((Throwable)x32, (String)this.getClass().getName(), (String)"183", (Object)this);
                    }
                    break block53;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (contextApplied != null) {
                            this.contextDescriptor.taskStopping(contextApplied);
                        }
                    }
                    catch (RuntimeException x32) {
                        FFDCFilter.processException((Throwable)x32, (String)"io.openliberty.concurrent.internal.cdi.interceptor.ScheduledAsyncMethod", (String)"188", (Object)this, (Object[])new Object[0]);
                        failure = x32;
                    }
                    finally {
                        if (failure != null) {
                            this.future.completeExceptionally(failure);
                        }
                    }
                }
            }
            try {
                if (contextApplied != null) {
                    this.contextDescriptor.taskStopping(contextApplied);
                }
            }
            catch (RuntimeException runtimeException) {
                void x4;
                FFDCFilter.processException((Throwable)runtimeException, (String)"io.openliberty.concurrent.internal.cdi.interceptor.ScheduledAsyncMethod", (String)"188", (Object)this, (Object[])new Object[0]);
                failure = x4;
            }
            finally {
                if (failure != null) {
                    this.future.completeExceptionally(failure);
                }
            }
        }
        if (!this.future.isDone()) {
            if (cs == null) {
                try {
                    ConcurrencyExtensionMetadata.scheduledExecutor.schedule(this, this.computeDelayNanos(), TimeUnit.NANOSECONDS);
                }
                catch (Exception x5) {
                    FFDCFilter.processException((Throwable)x5, (String)"io.openliberty.concurrent.internal.cdi.interceptor.ScheduledAsyncMethod", (String)"201", (Object)this, (Object[])new Object[0]);
                    this.future.completeExceptionally(x5);
                }
            } else {
                cs.whenComplete((result, x) -> {
                    if (x == null) {
                        this.future.complete(result);
                    } else {
                        this.future.completeExceptionally((Throwable)x);
                    }
                });
            }
        }
        if (!trace) return this.future;
        if (!tc.isEntryEnabled()) return this.future;
        if (!this.future.isCompletedExceptionally()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"call", this.future);
            return this.future;
        }
        if (failure == null) {
            try {
                this.future.getNow(null);
            }
            catch (Throwable x6) {
                failure = x6;
            }
        }
        Tr.exit((Object)this, (TraceComponent)tc, (String)"call", (Object)new Object[]{this.future, failure});
        return this.future;
    }

    @Trivial
    @ManualTrace
    private long computeDelayNanos() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"computeDelayNanos", (Object[])new Object[0]);
        }
        ZonedDateTime now = null;
        this.nextExecutionTime = null;
        for (int i = 0; i < this.triggers.size(); ++i) {
            ScheduleCronTrigger trigger = this.triggers.get(i);
            now = now == null ? ZonedDateTime.now(trigger.getZoneId()) : now;
            ZonedDateTime time = trigger.next(now);
            if (this.nextExecutionTime != null && !this.nextExecutionTime.isAfter(time)) continue;
            this.nextExecutionTime = time;
            this.nextExecutionSkipIfLateBySeconds = this.skipIfLateBySeconds.get(i);
        }
        long delayNanos = ZonedDateTime.now(this.nextExecutionTime.getZone()).until(this.nextExecutionTime, ChronoUnit.NANOS);
        long l = delayNanos = delayNanos < 0L ? 0L : delayNanos;
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"computeDelayNanos", (Object)(delayNanos / 1000000000L + "s " + delayNanos % 1000000000L / 1000000L + "ms " + delayNanos % 1000000L + "ns"));
        }
        return delayNanos;
    }

    @Trivial
    public Executor getExecutor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getExecutor for virtual threads: " + String.valueOf(this.virtualThreadExecutor)), (Object[])new Object[0]);
        }
        return this.virtualThreadExecutor;
    }
}

