/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.tasks;

import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.crypto.certificateutil.DefaultSSLCertificateCreator;
import com.ibm.ws.crypto.certificateutil.DefaultSubjectDN;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.security.utility.IFileUtility;
import com.ibm.ws.security.utility.SecurityUtilityReturnCodes;
import com.ibm.ws.security.utility.tasks.BaseCommandTask;
import com.ibm.ws.security.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class CreateSSLCertificateTask
extends BaseCommandTask {
    static final String SLASH = String.valueOf(File.separatorChar);
    static final String ARG_SERVER = "--server";
    static final String ARG_CLIENT = "--client";
    static final String ARG_VALIDITY = "--validity";
    static final String ARG_SUBJECT = "--subject";
    static final String ARG_CREATE_CONFIG_FILE = "--createConfigFile";
    static final String ARG_KEYSIZE = "--keySize";
    static final String ARG_SIGALG = "--sigAlg";
    static final String ARG_KEY_TYPE = "--keyType";
    static final String ARG_EXT = "--extInfo";
    static final String JKS_KEYFILE = "key.jks";
    static final String PKCS12_KEYFILE = "key.p12";
    static final String JKS = "jks";
    static final String PKCS12 = "pkcs12";
    private static final List<String> BETA_ARG_TABLE = Arrays.asList("--passwordBase64Key", "--aesConfigFile");
    private static final List<String> BETA_OPTS = BETA_ARG_TABLE.stream().map(s -> s.startsWith("--") ? s.substring(2) : s).collect(Collectors.toList());
    private final DefaultSSLCertificateCreator creator;
    private final IFileUtility fileUtility;
    protected ConsoleWrapper stdin;
    protected PrintStream stdout;
    protected PrintStream stderr;
    private static final List<Set<String>> EXCLUSIVE_ARGUMENTS = Arrays.asList(new HashSet<String>(Arrays.asList("--passwordKey", "--passwordBase64Key", "--aesConfigFile")), new HashSet<String>(Arrays.asList("--server", "--client")));

    public CreateSSLCertificateTask(DefaultSSLCertificateCreator creator, IFileUtility fileUtility, String scriptName) {
        super(scriptName);
        this.creator = creator;
        this.fileUtility = fileUtility;
    }

    @Override
    public String getTaskName() {
        return "createSSLCertificate";
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("sslCert.desc", true, new Object[0]);
    }

    @Override
    public String getTaskHelp() {
        return this.getTaskHelp("sslCert.desc", "sslCert.usage.options", "sslCert.required-key.", "sslCert.required-desc.", "sslCert.option-key.", "sslCert.option-desc.", "sslCert.option.addon", null, this.scriptName, 6, 365, 15, "default", "RSA", "SHA256withRSA", 2048, "SHA256withRSA");
    }

    @Override
    public SecurityUtilityReturnCodes handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.validateArgumentList(args, Arrays.asList("--password"));
        String serverName = this.getArgumentValue(ARG_SERVER, args, null);
        String clientName = this.getArgumentValue(ARG_CLIENT, args, null);
        String ou_name = null;
        String dir = null;
        if (serverName != null) {
            String usrServers = this.fileUtility.getServersDirectory();
            String serverDir = usrServers + serverName + SLASH;
            if (!this.fileUtility.exists(serverDir)) {
                usrServers = this.fileUtility.resolvePath(usrServers);
                stdout.println(CreateSSLCertificateTask.getMessage("sslCert.abort", new Object[0]));
                stdout.println(CreateSSLCertificateTask.getMessage("serverNotFound", serverName, usrServers));
                return SecurityUtilityReturnCodes.ERR_SERVER_NOT_FOUND;
            }
            dir = serverDir;
            ou_name = serverName;
        }
        if (clientName != null) {
            String usrClients = this.fileUtility.getClientsDirectory();
            String clientDir = usrClients + clientName + SLASH;
            if (!this.fileUtility.exists(clientDir)) {
                usrClients = this.fileUtility.resolvePath(usrClients);
                stdout.println(CreateSSLCertificateTask.getMessage("sslCert.abort", new Object[0]));
                stdout.println(CreateSSLCertificateTask.getMessage("sslCert.clientNotFound", clientName, usrClients));
                return SecurityUtilityReturnCodes.ERR_CLIENT_NOT_FOUND;
            }
            dir = clientDir;
            ou_name = clientName;
        }
        String location = null;
        String keyType = this.getArgumentValue(ARG_KEY_TYPE, args, null);
        if (keyType != null) {
            if (keyType.equalsIgnoreCase(JKS)) {
                location = dir + "resources" + SLASH + "security" + SLASH + JKS_KEYFILE;
            } else if (keyType.equalsIgnoreCase(PKCS12)) {
                location = dir + "resources" + SLASH + "security" + SLASH + PKCS12_KEYFILE;
            }
        } else {
            location = dir + "resources" + SLASH + "security" + SLASH + PKCS12_KEYFILE;
        }
        File fLocation = new File(location);
        location = this.fileUtility.resolvePath(fLocation);
        if (!this.fileUtility.createParentDirectory(stdout, fLocation)) {
            stdout.println(CreateSSLCertificateTask.getMessage("sslCert.abort", new Object[0]));
            stdout.println(CreateSSLCertificateTask.getMessage("file.requiredDirNotCreated", location));
            return SecurityUtilityReturnCodes.ERR_PATH_CANNOT_BE_CREATED;
        }
        if (fLocation.exists()) {
            stdout.println(CreateSSLCertificateTask.getMessage("sslCert.abort", new Object[0]));
            stdout.println(CreateSSLCertificateTask.getMessage("file.exists", location));
            return SecurityUtilityReturnCodes.ERR_FILE_EXISTS;
        }
        String password = this.getArgumentValue("--password", args, null);
        int validity = Integer.valueOf(this.getArgumentValue(ARG_VALIDITY, args, String.valueOf(365)));
        String subjectDN = this.getArgumentValue(ARG_SUBJECT, args, new DefaultSubjectDN(null, ou_name).getSubjectDN());
        int keySize = Integer.valueOf(this.getArgumentValue(ARG_KEYSIZE, args, String.valueOf(2048)));
        String sigAlg = this.getArgumentValue(ARG_SIGALG, args, "SHA256withRSA");
        List<String> extInfo = this.getExtInfoArgumentValues(ARG_EXT, args);
        try {
            HashMap<String, String> argProps = new HashMap<String, String>();
            String encoding = this.getArgumentValue("--passwordEncoding", args, PasswordUtil.getDefaultEncoding());
            argProps.put("--passwordKey", this.getArgumentValue("--passwordKey", args, null));
            argProps.put("--aesConfigFile", this.getArgumentValue("--aesConfigFile", args, null));
            argProps.put("--passwordBase64Key", this.getArgumentValue("--passwordBase64Key", args, null));
            Map<String, String> props = BaseCommandTask.convertToProperties(argProps, stdout);
            stdout.println(CreateSSLCertificateTask.getMessage("sslCert.createKeyStore", location));
            String encodedPassword = PasswordUtil.encode((String)password, (String)encoding, props);
            this.creator.createDefaultSSLCertificate(location, password, keyType, null, validity, subjectDN, keySize, sigAlg, extInfo);
            String xmlSnippet = null;
            if (serverName != null) {
                stdout.println(CreateSSLCertificateTask.getMessage("sslCert.serverXML", serverName, subjectDN));
                xmlSnippet = "    <featureManager>" + NL + "        <feature>transportSecurity-1.0</feature>" + NL + "    </featureManager>" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedPassword + "\" />" + NL;
            } else {
                stdout.println(CreateSSLCertificateTask.getMessage("sslCert.clientXML", clientName, subjectDN));
                xmlSnippet = "    <featureManager>" + NL + "        <feature>appSecurityClient-1.0</feature>" + NL + "    </featureManager>" + NL + "    <keyStore id=\"defaultKeyStore\" password=\"" + encodedPassword + "\" />" + NL;
            }
            stdout.println(NL + this.createConfigFileIfNeeded(dir, args, xmlSnippet) + NL);
        }
        catch (CertificateException e) {
            stdout.println(CreateSSLCertificateTask.getMessage("sslCert.createFailed", e.getMessage()));
            throw e;
        }
        catch (InvalidPasswordEncodingException e) {
            stdout.println(CreateSSLCertificateTask.getMessage("sslCert.errorEncodePassword", e.getMessage()));
            throw e;
        }
        catch (UnsupportedCryptoAlgorithmException e) {
            stdout.println(CreateSSLCertificateTask.getMessage("sslCert.errorEncodePassword", e.getMessage()));
            throw e;
        }
        return SecurityUtilityReturnCodes.OK;
    }

    @Override
    boolean isKnownArgument(String arg) {
        boolean isKnown;
        boolean bl = isKnown = arg.equals(ARG_SERVER) || arg.equals("--password") || arg.equals(ARG_VALIDITY) || arg.equals(ARG_SUBJECT) || arg.equals("--passwordEncoding") || arg.equals("--passwordKey") || arg.equals(ARG_CREATE_CONFIG_FILE) || arg.equals(ARG_KEYSIZE) || arg.equals(ARG_CLIENT) || arg.equals(ARG_SIGALG) || arg.equals(ARG_KEY_TYPE) || arg.equals(ARG_EXT);
        if (!isKnown && ProductInfo.getBetaEdition()) {
            isKnown = arg.equals("--passwordBase64Key") || arg.equals("--aesConfigFile");
        }
        return isKnown;
    }

    @Override
    void checkRequiredArguments(String[] args) {
        String message = "";
        if (args.length < 3) {
            message = CreateSSLCertificateTask.getMessage("insufficientArgs", new Object[0]);
        }
        boolean serverFound = false;
        boolean clientFound = false;
        boolean passwordFound = false;
        for (String arg : args) {
            if (arg.startsWith(ARG_SERVER)) {
                serverFound = true;
            }
            if (arg.startsWith(ARG_CLIENT)) {
                clientFound = true;
            }
            if (!arg.startsWith("--password")) continue;
            passwordFound = true;
        }
        if (!serverFound && !clientFound) {
            message = message + " " + CreateSSLCertificateTask.getMessage("missingArg2", ARG_SERVER, ARG_CLIENT);
        }
        if (!passwordFound) {
            message = message + " " + CreateSSLCertificateTask.getMessage("missingArg", "--password");
        }
        if (!message.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private String getArgumentValue(String arg, String[] args, String defalt) {
        return this.getArgumentValue(arg, args, defalt, "--password", this.stdin, this.stdout);
    }

    private List<String> getExtInfoArgumentValues(String arg, String[] args) {
        String defaultSAN;
        boolean addSAN = true;
        ArrayList<String> extArgs = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            String key = args[i].split("=")[0];
            if (!key.equals(arg)) continue;
            String value = this.getValue(args[i]);
            if (value.substring(0, 3).equalsIgnoreCase("SAN")) {
                addSAN = false;
            }
            extArgs.add(value);
        }
        if (addSAN && (defaultSAN = this.defaultExtInfo()) != null) {
            extArgs.add(defaultSAN);
        }
        return extArgs;
    }

    public String defaultExtInfo() {
        String hostname = this.getHostName();
        String ext = null;
        try {
            InetAddress addr = InetAddress.getByName(hostname);
            ext = "SAN=";
            ext = addr != null && addr.toString().startsWith("/") ? ext + "ip:" + hostname : ext + "dns:" + hostname;
            String ipAddresses = DefaultSubjectDN.buildSanIpStringFromNetworkInterface();
            if (ipAddresses != null) {
                ext = ext + "," + ipAddresses;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ext;
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    protected String createConfigFileIfNeeded(String serverDir, String[] commandLine, String xmlSnippet) {
        String utilityName = this.scriptName;
        String taskName = this.getTaskName();
        String MAGICAL_SENTINEL = "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
        String targetFilepath = this.getArgumentValue(ARG_CREATE_CONFIG_FILE, commandLine, "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345");
        if (targetFilepath == "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345") {
            return xmlSnippet;
        }
        File outputFile = this.generateConfigFileName(utilityName, taskName, serverDir, targetFilepath);
        String xmlTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + NL + "<server description=\"This file was generated by the ''{0} {1}'' command on {2,date,yyyy-MM-dd HH:mm:ss z}.\">" + NL + "{3}" + NL + "</server>" + NL;
        String xmlData = MessageFormat.format(xmlTemplate, utilityName, taskName, Calendar.getInstance().getTime(), xmlSnippet);
        this.fileUtility.createParentDirectory(this.stdout, outputFile);
        this.fileUtility.writeToFile(this.stderr, xmlData, outputFile);
        String includeSnippet = "    <include location=\"" + outputFile.getAbsolutePath() + "\" />" + NL;
        return includeSnippet;
    }

    protected File generateConfigFileName(String utilityName, String taskName, String serverDir, String targetFilepath) {
        File outputFile;
        if (targetFilepath == null || targetFilepath.equals("")) {
            targetFilepath = serverDir + SLASH;
        }
        if (this.fileUtility.isDirectory(outputFile = new File(targetFilepath))) {
            outputFile = new File(outputFile, utilityName + "-" + taskName + "-include.xml");
        }
        if (this.fileUtility.exists(outputFile)) {
            String filePath = FilenameUtils.removeExtension((String)outputFile.getPath());
            String fileExt = FilenameUtils.getExtension((String)outputFile.getPath());
            int counter = 1;
            do {
                outputFile = new File(filePath + counter + "." + fileExt);
                ++counter;
            } while (this.fileUtility.exists(outputFile));
        }
        return outputFile;
    }

    @Override
    protected List<String> getBetaOptions() {
        return BETA_OPTS;
    }

    @Override
    protected List<Set<String>> getExclusiveArguments() {
        return EXCLUSIVE_ARGUMENTS;
    }
}

