/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class GuardedPattern
extends Pattern {
    public Pattern primaryPattern;
    public Expression condition;
    int thenInitStateIndex1 = -1;
    int thenInitStateIndex2 = -1;
    public int restrictedIdentifierStart = -1;

    public GuardedPattern(Pattern primaryPattern, Expression conditionalAndExpression) {
        this.primaryPattern = primaryPattern;
        this.condition = conditionalAndExpression;
        this.sourceStart = primaryPattern.sourceStart;
        this.sourceEnd = conditionalAndExpression.sourceEnd;
    }

    @Override
    public void collectPatternVariablesToScope(LocalVariableBinding[] variables, BlockScope scope) {
        this.primaryPattern.collectPatternVariablesToScope(variables, scope);
        this.addPatternVariablesWhenTrue(this.primaryPattern.getPatternVariablesWhenTrue());
        this.condition.collectPatternVariablesToScope(this.getPatternVariablesWhenTrue(), scope);
        this.addPatternVariablesWhenTrue(this.condition.getPatternVariablesWhenTrue());
    }

    @Override
    public LocalDeclaration getPatternVariable() {
        return this.primaryPattern.getPatternVariable();
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.primaryPattern.analyseCode(currentScope, flowContext, flowInfo);
        this.thenInitStateIndex1 = currentScope.methodScope().recordInitializationStates(flowInfo);
        FlowInfo mergedFlow = this.condition.analyseCode(currentScope, flowContext, flowInfo);
        mergedFlow = mergedFlow.safeInitsWhenTrue();
        this.thenInitStateIndex2 = currentScope.methodScope().recordInitializationStates(mergedFlow);
        return mergedFlow;
    }

    @Override
    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, BranchLabel trueLabel, BranchLabel falseLabel) {
        this.thenTarget = new BranchLabel(codeStream);
        this.elseTarget = new BranchLabel(codeStream);
        this.primaryPattern.generateOptimizedBoolean(currentScope, codeStream, this.thenTarget, this.elseTarget);
        Constant cst = this.condition.optimizedBooleanConstant();
        this.setGuardedElseTarget(currentScope, this.elseTarget);
        this.condition.generateOptimizedBoolean(currentScope, codeStream, this.thenTarget, null, cst == Constant.NotAConstant);
        if (this.thenInitStateIndex2 != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex2);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex2);
        }
    }

    private void setGuardedElseTarget(BlockScope currentScope, BranchLabel guardedElseTarget) {
        class PatternsCollector
        extends ASTVisitor {
            BranchLabel guardedElseTarget1;

            public PatternsCollector(BranchLabel guardedElseTarget1) {
                this.guardedElseTarget1 = guardedElseTarget1;
            }

            @Override
            public boolean visit(RecordPattern recordPattern, BlockScope scope1) {
                recordPattern.guardedElseTarget = this.guardedElseTarget1;
                return true;
            }
        }
        PatternsCollector patCollector = new PatternsCollector(guardedElseTarget);
        this.condition.traverse((ASTVisitor)patCollector, currentScope);
    }

    @Override
    public boolean isAlwaysTrue() {
        Constant cst = this.condition.optimizedBooleanConstant();
        return cst != Constant.NotAConstant && cst.booleanValue();
    }

    @Override
    public boolean coversType(TypeBinding type) {
        return this.primaryPattern.coversType(type) && this.isAlwaysTrue();
    }

    @Override
    public Pattern primary() {
        return this.primaryPattern;
    }

    @Override
    public void resolve(BlockScope scope) {
        this.resolveType(scope);
    }

    @Override
    public boolean dominates(Pattern p) {
        if (this.isAlwaysTrue()) {
            return this.primaryPattern.dominates(p);
        }
        return false;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        if (this.resolvedType != null || this.primaryPattern == null) {
            return this.resolvedType;
        }
        this.resolvedType = this.primaryPattern.resolveType(scope);
        this.condition.resolveTypeExpecting(scope, TypeBinding.BOOLEAN);
        Constant cst = this.condition.optimizedBooleanConstant();
        if (cst.typeID() == 5 && !cst.booleanValue()) {
            scope.problemReporter().falseLiteralInGuard(this.condition);
        }
        this.condition.traverse(new ASTVisitor(){

            @Override
            public boolean visit(SingleNameReference ref, BlockScope skope) {
                LocalVariableBinding local = ref.localVariableBinding();
                if (local != null) {
                    ref.bits |= 0x40;
                }
                return false;
            }

            @Override
            public boolean visit(QualifiedNameReference ref, BlockScope skope) {
                if ((ref.bits & 7) == 2) {
                    ref.bits |= 0x40;
                }
                return false;
            }
        }, scope);
        this.resolvedType = this.primaryPattern.resolvedType;
        return this.resolvedType;
    }

    @Override
    public TypeBinding resolveAtType(BlockScope scope, TypeBinding u) {
        if (this.resolvedType == null || this.primaryPattern == null) {
            return null;
        }
        if (this.primaryPattern.coversType(u)) {
            return this.primaryPattern.resolveAtType(scope, u);
        }
        return this.resolvedType;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        this.primaryPattern.print(indent, output).append(" when ");
        return this.condition.print(indent, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.primaryPattern != null) {
                this.primaryPattern.traverse(visitor, scope);
            }
            if (this.condition != null) {
                this.condition.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public void suspendVariables(CodeStream codeStream, BlockScope scope) {
        codeStream.removeNotDefinitelyAssignedVariables(scope, this.thenInitStateIndex1);
        this.primaryPattern.suspendVariables(codeStream, scope);
    }

    @Override
    public void resumeVariables(CodeStream codeStream, BlockScope scope) {
        codeStream.addDefinitelyAssignedVariables(scope, this.thenInitStateIndex2);
        this.primaryPattern.resumeVariables(codeStream, scope);
    }

    @Override
    public void resolveWithExpression(BlockScope scope, Expression expression) {
        this.primaryPattern.resolveWithExpression(scope, expression);
    }

    @Override
    protected boolean isPatternTypeCompatible(TypeBinding other, BlockScope scope) {
        return this.primaryPattern.isPatternTypeCompatible(other, scope);
    }

    @Override
    public void wrapupGeneration(CodeStream codeStream) {
        this.primaryPattern.wrapupGeneration(codeStream);
    }

    @Override
    protected void generatePatternVariable(BlockScope currentScope, CodeStream codeStream, BranchLabel trueLabel, BranchLabel falseLabel) {
        this.primaryPattern.generatePatternVariable(currentScope, codeStream, trueLabel, falseLabel);
    }
}

