/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.common.export;

import io.opentelemetry.sdk.common.export.RetryPolicy;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Predicate;

final class AutoValue_RetryPolicy
extends RetryPolicy {
    private final int maxAttempts;
    private final Duration initialBackoff;
    private final Duration maxBackoff;
    private final double backoffMultiplier;
    @Nullable
    private final Predicate<IOException> retryExceptionPredicate;

    private AutoValue_RetryPolicy(int maxAttempts, Duration initialBackoff, Duration maxBackoff, double backoffMultiplier, @Nullable Predicate<IOException> retryExceptionPredicate) {
        this.maxAttempts = maxAttempts;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.backoffMultiplier = backoffMultiplier;
        this.retryExceptionPredicate = retryExceptionPredicate;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public Duration getInitialBackoff() {
        return this.initialBackoff;
    }

    @Override
    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    @Override
    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    @Override
    @Nullable
    public Predicate<IOException> getRetryExceptionPredicate() {
        return this.retryExceptionPredicate;
    }

    public String toString() {
        return "RetryPolicy{maxAttempts=" + this.maxAttempts + ", initialBackoff=" + this.initialBackoff + ", maxBackoff=" + this.maxBackoff + ", backoffMultiplier=" + this.backoffMultiplier + ", retryExceptionPredicate=" + this.retryExceptionPredicate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RetryPolicy) {
            RetryPolicy that = (RetryPolicy)o;
            return this.maxAttempts == that.getMaxAttempts() && this.initialBackoff.equals(that.getInitialBackoff()) && this.maxBackoff.equals(that.getMaxBackoff()) && Double.doubleToLongBits(this.backoffMultiplier) == Double.doubleToLongBits(that.getBackoffMultiplier()) && (this.retryExceptionPredicate == null ? that.getRetryExceptionPredicate() == null : this.retryExceptionPredicate.equals(that.getRetryExceptionPredicate()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.maxAttempts;
        h$ *= 1000003;
        h$ ^= this.initialBackoff.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBackoff.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.backoffMultiplier) >>> 32 ^ Double.doubleToLongBits(this.backoffMultiplier));
        h$ *= 1000003;
        return h$ ^= this.retryExceptionPredicate == null ? 0 : this.retryExceptionPredicate.hashCode();
    }

    @Override
    public RetryPolicy.RetryPolicyBuilder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RetryPolicy.RetryPolicyBuilder {
        private int maxAttempts;
        private Duration initialBackoff;
        private Duration maxBackoff;
        private double backoffMultiplier;
        private Predicate<IOException> retryExceptionPredicate;
        private byte set$0;

        Builder() {
        }

        Builder(RetryPolicy source) {
            this.maxAttempts = source.getMaxAttempts();
            this.initialBackoff = source.getInitialBackoff();
            this.maxBackoff = source.getMaxBackoff();
            this.backoffMultiplier = source.getBackoffMultiplier();
            this.retryExceptionPredicate = source.getRetryExceptionPredicate();
            this.set$0 = (byte)3;
        }

        @Override
        public RetryPolicy.RetryPolicyBuilder setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public RetryPolicy.RetryPolicyBuilder setInitialBackoff(Duration initialBackoff) {
            if (initialBackoff == null) {
                throw new NullPointerException("Null initialBackoff");
            }
            this.initialBackoff = initialBackoff;
            return this;
        }

        @Override
        public RetryPolicy.RetryPolicyBuilder setMaxBackoff(Duration maxBackoff) {
            if (maxBackoff == null) {
                throw new NullPointerException("Null maxBackoff");
            }
            this.maxBackoff = maxBackoff;
            return this;
        }

        @Override
        public RetryPolicy.RetryPolicyBuilder setBackoffMultiplier(double backoffMultiplier) {
            this.backoffMultiplier = backoffMultiplier;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public RetryPolicy.RetryPolicyBuilder setRetryExceptionPredicate(Predicate<IOException> retryExceptionPredicate) {
            this.retryExceptionPredicate = retryExceptionPredicate;
            return this;
        }

        @Override
        RetryPolicy autoBuild() {
            if (this.set$0 != 3 || this.initialBackoff == null || this.maxBackoff == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" maxAttempts");
                }
                if (this.initialBackoff == null) {
                    missing.append(" initialBackoff");
                }
                if (this.maxBackoff == null) {
                    missing.append(" maxBackoff");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" backoffMultiplier");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RetryPolicy(this.maxAttempts, this.initialBackoff, this.maxBackoff, this.backoffMultiplier, this.retryExceptionPredicate);
        }
    }
}

