/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulws.mpmetrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs.monitor.metrics.service.RestMetricsCallback;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics.internal.monitor.computed.internal.ComputedMonitorMetricsHandler;
import io.openliberty.restfulws.mpmetrics.MetricsRestfulWsEMCallbackImpl;
import io.openliberty.restfulws.mpmetrics.MonitorAppStateListener;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RestMetricsCallback.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class RestMetricsCallbackImpl
implements RestMetricsCallback {
    private static final TraceComponent tc = Tr.register(RestMetricsCallbackImpl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    static final ConcurrentHashMap<String, RestMetricInfo> appMetricInfos = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, Timer> timerMap = new ConcurrentHashMap();
    static final String REST_REQUEST_DESCRIPTION = "The number of invocations and total response time of this RESTful resource method since the start of the server. The metric will not record the elapsed time nor count of a REST request if it resulted in an unmapped exception. Also tracks the highest recorded time duration within the previous completed full minute and lowest recorded time duration within the previous completed full minute.";
    static final long serialVersionUID = 8638956201919978842L;

    public void createRestMetric(String classMethodParamSignature, String statsKey) {
        if (!timerMap.contains(statsKey)) {
            String appName = this.resolveAppNameFromStatsKey(statsKey);
            if (appName == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)String.format("Encountered issue when validating REST stats key: [%s]. REST metric will not be created.", new Object[0]), (Object[])new Object[]{statsKey});
                }
                return;
            }
            this.addKeyToMetricInfo(appName, statsKey);
            String className = this.getClassTagValue(classMethodParamSignature);
            String methodName = this.getMethodTagValue(classMethodParamSignature);
            MetricRegistry baseMetricRegistry = MonitorAppStateListener.sharedMetricRegistries.getOrCreate("base");
            Metadata metricMetadata = Metadata.builder().withName("REST.request").withDescription(REST_REQUEST_DESCRIPTION).build();
            Tag classTag = new Tag("class", className);
            Tag methodTag = new Tag("method", methodName);
            Timer restTimer = baseMetricRegistry.timer(metricMetadata, new Tag[]{classTag, methodTag});
            MetricID metricID = new MetricID("REST.request", new Tag[]{classTag, methodTag});
            MonitorAppStateListener.sharedMetricRegistries.associateMetricIDToApplication(metricID, appName, baseMetricRegistry);
            timerMap.put(statsKey, restTimer);
            MetricsRestfulWsEMCallbackImpl.registerOrRetrieveRESTUnmappedExceptionMetric(className, methodName, appName);
            ComputedMonitorMetricsHandler cmmh = MonitorAppStateListener.monitorMetricsHandler.getComputedMonitorMetricsHandler();
            String mpAppNameConfigValue = this.resolveMPAppNameFromMPConfig();
            cmmh.createRESTComputedMetrics("RESTStats", metricID, appName, mpAppNameConfigValue);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("REST metric for stats key: [%s] has already been created.", statsKey), (Object[])new Object[0]);
        }
    }

    public void updateRestMetric(String classMethodParamSignature, String statsKey, Duration duration) {
        if (!timerMap.containsKey(statsKey)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)String.format("REST metric for stats key: [%s] has not been created and can not be updated.", statsKey), (Object[])new Object[0]);
            }
            return;
        }
        Timer restTimer = timerMap.get(statsKey);
        restTimer.update(duration);
    }

    protected String resolveMPAppNameFromMPConfig() {
        Optional applicationName = null;
        String mpAppName = null;
        applicationName = ConfigProvider.getConfig().getOptionalValue("mp.metrics.appName", String.class);
        if (applicationName.isPresent() && !((String)applicationName.get()).isEmpty()) {
            mpAppName = (String)applicationName.get();
        } else {
            applicationName = ConfigProvider.getConfig().getOptionalValue("mp.metrics.defaultAppName", String.class);
            if (applicationName.isPresent() && !((String)applicationName.get()).isEmpty()) {
                mpAppName = (String)applicationName.get();
            }
        }
        return mpAppName;
    }

    private void addKeyToMetricInfo(String appName, String key) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            rMetricInfo.setKey(key);
        }
    }

    static RestMetricInfo getMetricInfo(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo == null) {
            rMetricInfo = new RestMetricInfo();
            appMetricInfos.put(appName, rMetricInfo);
        }
        return rMetricInfo;
    }

    static void cleanApplication(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            HashSet<String> keys = rMetricInfo.getKeys();
            if (!keys.isEmpty()) {
                Iterator<String> keyIterator = keys.iterator();
                String key = null;
                while (keyIterator.hasNext()) {
                    key = keyIterator.next();
                    timerMap.remove(key);
                }
            }
            appMetricInfos.remove(appName);
        }
    }

    private String resolveAppNameFromStatsKey(String statsKey) {
        if (statsKey == null || statsKey.isBlank()) {
            return null;
        }
        String[] keyComponents = statsKey.split("/");
        if (keyComponents.length == 0 || keyComponents.length > 4) {
            return null;
        }
        return keyComponents[0];
    }

    private String getClassTagValue(String classMethodParamSignature) {
        return classMethodParamSignature.split("/")[0];
    }

    private String getMethodTagValue(String classMethodParamSignature) {
        String methodTag = classMethodParamSignature.split("/")[1];
        methodTag = methodTag.replaceAll("\\(\\)", "");
        methodTag = methodTag.replaceAll("\\(", "_");
        methodTag = methodTag.replaceAll("\\)", "");
        return methodTag;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class RestMetricInfo {
        boolean isEar = false;
        HashSet<String> keys = new HashSet();
        static final long serialVersionUID = -1290380817170688609L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RestMetricInfo() {
        }

        static void init() {
        }

        void setIsEar() {
            this.isEar = true;
        }

        void setKey(String key) {
            this.keys.add(key);
        }

        HashSet<String> getKeys() {
            return this.keys;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.restfulws.mpmetrics.RestMetricsCallbackImpl$RestMetricInfo", RestMetricInfo.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
        }
    }
}

