/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.RichClientFramework;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ChannelFramework;
import java.util.List;
import java.util.Optional;

public abstract class ServerConnectionManager {
    private static final TraceComponent tc = SibTr.register(ServerConnectionManager.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static boolean initialised = false;
    private static volatile OutboundConnectionTracker connectionTracker;

    public static void initialise(ChannelFramework chfw) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise");
        }
        if (!initialised) {
            block6: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"not previously initialised");
                }
                try {
                    RichClientFramework framework = new RichClientFramework(chfw);
                    connectionTracker = new OutboundConnectionTracker((Framework)framework);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.ServerConnectionManager.{}", (String)"00010001");
                    SibTr.error((TraceComponent)tc, (String)"EXCP_DURING_INIT_SICJ0003", (Object)new Object[]{ServerConnectionManager.class, e});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
            initialised = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public static List<Conversation> getActiveOutboundMEtoMEConversations() {
        return Optional.ofNullable(connectionTracker).map(OutboundConnectionTracker::getAllOutboundConversations).orElse(null);
    }
}

