/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import jakarta.annotation.CheckForNull;
import jakarta.annotation.ParametersAreNonnullByDefault;
import java.net.URL;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;

@ParametersAreNonnullByDefault
public interface Connection
extends AutoCloseable {
    public void resetNonce(Session var1) throws AcmeException;

    public void sendRequest(URL var1, Session var2) throws AcmeException;

    public int sendCertificateRequest(URL var1, Login var2) throws AcmeException;

    public int sendSignedPostAsGetRequest(URL var1, Login var2) throws AcmeException;

    public int sendSignedRequest(URL var1, JSONBuilder var2, Login var3) throws AcmeException;

    public int sendSignedRequest(URL var1, JSONBuilder var2, Session var3, KeyPair var4) throws AcmeException;

    @CheckForNull
    public JSON readJsonResponse() throws AcmeException;

    public List<X509Certificate> readCertificates() throws AcmeException;

    public void handleRetryAfter(String var1) throws AcmeException;

    @CheckForNull
    public String getNonce();

    @CheckForNull
    public URL getLocation();

    public Collection<URL> getLinks(String var1);

    @Override
    public void close();
}

