/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.contextpropagation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.contextpropagation.ContextManagerProviderImpl;
import com.ibm.ws.microprofile.contextpropagation.MPConfigAccessor;
import com.ibm.ws.microprofile.contextpropagation.ManagedExecutorBuilderImpl;
import com.ibm.ws.microprofile.contextpropagation.ThreadContextBuilderImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContextManagerImpl
implements ContextManager,
Iterable<ThreadContextProvider> {
    private static final TraceComponent tc = Tr.register(ContextManagerImpl.class, (String)"concurrent", (String)"com.ibm.ws.microprofile.context.resources.CWWKCMessages");
    static final AtomicInteger instanceCount = new AtomicInteger();
    final String appName;
    final ContextManagerProviderImpl cmProvider;
    private final ArrayList<ThreadContextProvider> contextProviders = new ArrayList();
    private final AtomicReference<Object> mpConfigRef = new AtomicReference<Boolean>(Boolean.FALSE);
    static final long serialVersionUID = -7095012187622416079L;

    ContextManagerImpl(ContextManagerProviderImpl cmProvider, ClassLoader classloader) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.cmProvider = cmProvider;
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        this.appName = cData == null ? null : cData.getJ2EEName().getApplication();
        HashSet<String> available = new HashSet<String>();
        this.contextProviders.add(cmProvider.applicationContextProvider);
        available.add("Application");
        this.contextProviders.add(cmProvider.cdiContextProvider);
        available.add("CDI");
        this.contextProviders.add(cmProvider.securityContextProvider);
        available.add("Security");
        this.contextProviders.add(cmProvider.threadIdendityContextProvider);
        available.add("SyncToOSThread");
        this.contextProviders.add(cmProvider.transactionContextProvider);
        available.add("Transaction");
        this.contextProviders.add(cmProvider.wlmContextProvider);
        available.add("Classification");
        this.contextProviders.add(cmProvider.emptyHandleListContextProvider);
        available.add("EmptyHandleList");
        for (ThreadContextProvider provider : ServiceLoader.load(ThreadContextProvider.class, classloader)) {
            String type = provider.getThreadContextType();
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("context type " + type + " provided by " + provider), (Object[])new Object[0]);
            }
            if (available.add(type)) {
                this.contextProviders.add(provider);
                continue;
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1150.duplicate.context", (Object[])new Object[]{type, provider, this.findConflictingProvider(provider, classloader)}));
        }
    }

    private ThreadContextProvider findConflictingProvider(ThreadContextProvider provider, ClassLoader classloader) {
        String conflictingType = provider.getThreadContextType();
        for (ThreadContextProvider p : ServiceLoader.load(ThreadContextProvider.class, classloader)) {
            if (!conflictingType.equals(p.getThreadContextType()) || provider.equals(p)) continue;
            return p;
        }
        if ("Application".equals(conflictingType)) {
            return this.cmProvider.applicationContextProvider;
        }
        if ("CDI".equals(conflictingType)) {
            return this.cmProvider.cdiContextProvider;
        }
        if ("Security".equals(conflictingType)) {
            return this.cmProvider.securityContextProvider;
        }
        if ("Transaction".equals(conflictingType)) {
            return this.cmProvider.transactionContextProvider;
        }
        if ("Classification".equals(conflictingType)) {
            return this.cmProvider.wlmContextProvider;
        }
        throw new IllegalStateException(conflictingType);
    }

    <T> T getDefault(String mpConfigPropName, T defaultValue) {
        MPConfigAccessor accessor = this.cmProvider.mpConfigAccessor;
        if (accessor != null) {
            Object mpConfig = this.mpConfigRef.get();
            if (mpConfig == Boolean.FALSE && !this.mpConfigRef.compareAndSet(Boolean.FALSE, mpConfig = accessor.getConfig())) {
                mpConfig = this.mpConfigRef.get();
            }
            if (mpConfig != null) {
                defaultValue = accessor.get(mpConfig, mpConfigPropName, defaultValue);
            }
        }
        return defaultValue;
    }

    @Override
    public Iterator<ThreadContextProvider> iterator() {
        return this.contextProviders.iterator();
    }

    public ManagedExecutor.Builder newManagedExecutorBuilder() {
        return new ManagedExecutorBuilderImpl(this, this.contextProviders);
    }

    public ThreadContext.Builder newThreadContextBuilder() {
        return new ThreadContextBuilderImpl(this, this.contextProviders);
    }
}

