/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.interceptor;

import com.ibm.tx.remote.RemoteTransactionController;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.wsat.interceptor.WSATCompleteTransInterceptor;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WSATUtil;
import com.ibm.ws.wsat.utils.WSCoorUtil;
import com.ibm.ws.wsat.webservice.client.wscoor.CoordinationContext;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class CoorContextOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    final TraceComponent tc = Tr.register(CoorContextOutInterceptor.class, (String)"WSAT", null);
    private Constants.AssertionStatus isOptional;
    private final RemoteTransactionController tranService = this.getService(RemoteTransactionController.class);

    private <T> T getService(Class<T> service) {
        Object impl = null;
        BundleContext context = FrameworkUtil.getBundle(service).getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        if (ref != null) {
            impl = context.getService(ref);
        } else if (this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)"Unable to locate service: {0}", (Object[])new Object[]{service});
        }
        return (T)impl;
    }

    public CoorContextOutInterceptor(String phase) {
        super(phase);
        this.getBefore().add(SoapOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        this.isOptional = !WSCoorUtil.assertAT(message) ? Constants.AssertionStatus.FALSE : WSCoorUtil.isOptional(message, false);
        boolean inTrans = false;
        WSCoorUtil.checkHandlerServiceReady();
        inTrans = WSCoorUtil.getHandlerService().isTranActive();
        if (inTrans) {
            SoapHeader header = null;
            JAXBDataBinding dataBinding = null;
            if (message.getExchange().isOneWay()) {
                throw new Fault((Throwable)new WSATException("WS-AT can not work on ONE-WAY webservice method"));
            }
            try {
                String regHost = WSCoorUtil.getConfigService().getWSATUrl() + "/" + "RegistrationService";
                String recoveryId = this.tranService != null ? this.tranService.getRecoveryId() : null;
                WSATContext ctx = WSCoorUtil.getHandlerService().handleClientRequest();
                EndpointReferenceType localRegEpr = WSATUtil.createEpr((String)regHost, (String)ctx.getId(), (String)recoveryId);
                CoordinationContext cc = WSCoorUtil.createCoordinationContext(ctx, localRegEpr);
                dataBinding = new JAXBDataBinding(new Class[]{CoordinationContext.class});
                QName qname = new QName("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
                header = new SoapHeader(qname, (Object)cc, (DataBinding)dataBinding);
                header.setMustUnderstand(true);
                WSATCompleteTransInterceptor _comTransIn = new WSATCompleteTransInterceptor("pre-protocol", LibertyApplicationBus.Type.CLIENT);
                Exchange ex = message.getExchange();
                Endpoint ep = (Endpoint)ex.get(Endpoint.class);
                ep.getInInterceptors().add(_comTransIn);
                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)"handleMessage", (Object[])new Object[]{"Generate a new CoordinationContext", header.toString(), header.getName()});
                }
                ArrayList headers = (ArrayList)message.get((Object)"org.apache.cxf.headers.Header.list");
                headers.add(header);
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.interceptor.CoorContextOutInterceptor", (String)"119");
                throw new Fault(e);
            }
        } else if (this.isOptional == Constants.AssertionStatus.FALSE) {
            throw new Fault((Throwable)new WSATException("Detected WS-AT policy, however there is no active transaction in current thread."));
        }
    }

    public void handleFault(Message message) {
        WSCoorUtil.checkHandlerServiceReady();
        try {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)this.tc, (String)"handleFault", (Object[])new Object[]{message, new Exception("Stack trace for CoorContextOutInterceptor.handleFault()")});
            }
            WSCoorUtil.getHandlerService().handleClientFault();
        }
        catch (WSATException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsat.interceptor.CoorContextOutInterceptor", (String)"201");
        }
    }
}

