/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.utils.JweHelper;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.UserInfoException;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UserInfoHelper {
    private static final TraceComponent tc = Tr.register(UserInfoHelper.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private ConvergedClientConfig clientConfig = null;
    private Jose4jUtil jose4jUtil = null;
    static final long serialVersionUID = -5922940492667056556L;

    public UserInfoHelper(ConvergedClientConfig config, SSLSupport sslSupport) {
        this.clientConfig = config;
        this.jose4jUtil = new Jose4jUtil(sslSupport);
    }

    public boolean willRetrieveUserInfo() {
        return this.clientConfig.getUserInfoEndpointUrl() != null && this.clientConfig.isUserInfoEnabled();
    }

    public boolean getUserInfoIfPossible(ProviderAuthenticationResult oidcResult, Map<String, String> tokens, SSLSocketFactory sslsf, OidcClientRequest oidcClientRequest) {
        if (!this.willRetrieveUserInfo()) {
            return false;
        }
        OidcTokenImplBase idToken = null;
        if (oidcResult.getCustomProperties() != null) {
            idToken = (OidcTokenImplBase)oidcResult.getCustomProperties().get("id_token_object");
        }
        String subjFromIdToken = null;
        if (idToken != null) {
            subjFromIdToken = idToken.getSubject();
        }
        if (subjFromIdToken != null) {
            return this.getUserInfoIfPossible(oidcResult, tokens.get("access_token"), subjFromIdToken, sslsf, oidcClientRequest);
        }
        return false;
    }

    public boolean getUserInfoIfPossible(ProviderAuthenticationResult oidcResult, String accessToken, String subject, SSLSocketFactory sslsf, OidcClientRequest oidcClientRequest) {
        if (!this.willRetrieveUserInfo()) {
            return false;
        }
        if (subject != null && accessToken != null) {
            return this.getUserInfo(oidcResult, sslsf, accessToken, subject, oidcClientRequest);
        }
        return false;
    }

    public boolean getUserInfo(ProviderAuthenticationResult oidcResult, SSLSocketFactory sslSocketFactory, String accessToken, String subjectFromIdToken, OidcClientRequest oidcClientRequest) {
        if (!this.willRetrieveUserInfo() || accessToken == null) {
            return false;
        }
        String userInfoStr = this.getUserInfoFromURL(this.clientConfig, sslSocketFactory, accessToken, oidcClientRequest);
        if (userInfoStr == null) {
            return false;
        }
        if (!this.isUserInfoValid(userInfoStr, subjectFromIdToken)) {
            return false;
        }
        this.updateAuthenticationResultPropertiesWithUserInfo(oidcResult, userInfoStr);
        return true;
    }

    protected void updateAuthenticationResultPropertiesWithUserInfo(ProviderAuthenticationResult oidcResult, String userInfoStr) {
        oidcResult.getCustomProperties().put("userinfo_string", userInfoStr);
    }

    public boolean isUserInfoValid(String userInfoStr, String subClaim) {
        String userInfoSubClaim = this.getUserInfoSubClaim(userInfoStr);
        if (userInfoSubClaim == null || subClaim == null || userInfoSubClaim.compareTo(subClaim) != 0) {
            Tr.error((TraceComponent)tc, (String)"USERINFO_INVALID", (Object[])new Object[]{userInfoStr, subClaim});
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected String getUserInfoSubClaim(String userInfo) {
        JSONObject jobj = null;
        try {
            jobj = JSONObject.parse((String)userInfo);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper", (String)"142", (Object)this, (Object[])new Object[]{userInfo});
            Tr.error((TraceComponent)tc, (String)"USERINFO_CLAIMS_FORMAT_NOT_VALID", (Object[])new Object[]{userInfo, e.getMessage()});
        }
        return jobj == null ? null : (String)jobj.get((Object)"sub");
    }

    /*
     * WARNING - void declaration
     */
    protected String getUserInfoFromURL(ConvergedClientConfig config, SSLSocketFactory sslsf, String accessToken, OidcClientRequest oidcClientRequest) {
        String url = config.getUserInfoEndpointUrl();
        boolean hostnameVerification = config.isHostNameVerificationEnabled();
        if (!url.toLowerCase().startsWith("https:") && config.isHttpsRequired()) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{url});
            return null;
        }
        OidcClientUtil oidccu = new OidcClientUtil();
        int statusCode = 0;
        String responseStr = null;
        try {
            boolean useSysProps = config.getUseSystemPropertiesForHttpClientConnections();
            Map<String, Object> resultMap = oidccu.getUserinfo(url, accessToken, sslsf, hostnameVerification, useSysProps);
            if (resultMap == null) {
                throw new Exception("result map from getUserinfo is null");
            }
            HttpResponse response = (HttpResponse)resultMap.get("RESPONSEMAP_CODE");
            if (response == null) {
                throw new Exception("HttpResponse from getUserinfo is null");
            }
            statusCode = response.getStatusLine().getStatusCode();
            responseStr = this.extractClaimsFromResponse(response, config.getOidcClientConfig(), oidcClientRequest);
        }
        catch (Exception useSysProps) {
            void ex;
            FFDCFilter.processException((Throwable)useSysProps, (String)"com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper", (String)"178", (Object)this, (Object[])new Object[]{config, sslsf, accessToken, oidcClientRequest});
            Tr.error((TraceComponent)tc, (String)"ERROR_GETTING_USERINFO_OR_EXTRACTING_CLAIMS", (Object[])new Object[]{config.getId(), ex.getMessage()});
        }
        if (statusCode != 200) {
            Tr.error((TraceComponent)tc, (String)"USERINFO_RETREIVE_FAILED", (Object[])new Object[]{url, Integer.toString(statusCode), responseStr});
            return null;
        }
        return responseStr;
    }

    String extractClaimsFromResponse(HttpResponse response, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        HttpEntity entity = response.getEntity();
        String jresponse = null;
        if (entity != null) {
            jresponse = EntityUtils.toString((HttpEntity)entity);
        }
        if (jresponse == null || jresponse.isEmpty()) {
            return null;
        }
        String contentType = this.getContentType(entity);
        if (contentType == null) {
            return null;
        }
        String claimsStr = null;
        if (contentType.contains("application/json")) {
            claimsStr = jresponse;
        } else if (contentType.contains("application/jwt")) {
            claimsStr = this.extractClaimsFromJwtResponse(jresponse, clientConfig, oidcClientRequest);
        }
        return claimsStr;
    }

    String getContentType(HttpEntity entity) {
        Header contentTypeHeader = entity.getContentType();
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    @FFDCIgnore(value={Exception.class})
    public String extractClaimsFromJwtResponse(String responseString, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        if (responseString == null || responseString.isEmpty()) {
            return null;
        }
        boolean isJwe = false;
        try {
            if (JweHelper.isJwe((String)responseString)) {
                responseString = JweHelper.extractPayloadFromJweToken((String)responseString, (JwtConsumerConfig)clientConfig, null);
                isJwe = true;
            }
            if (JweHelper.isJws((String)responseString)) {
                return this.extractClaimsFromJwsResponse(responseString, clientConfig, oidcClientRequest);
            }
            if (isJwe) {
                return responseString;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_RESPONSE_STRING_NOT_IN_JWT_FORMAT", (Object[])new Object[]{responseString});
            throw new UserInfoException(msg);
        }
        catch (Exception e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_ERROR_EXTRACTING_JWT_CLAIMS_FROM_WEB_RESPONSE", (Object[])new Object[]{clientConfig.getId(), e.getMessage()});
            throw new UserInfoException(msg, e);
        }
    }

    String extractClaimsFromJwsResponse(String responseString, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        JwtClaims claims;
        JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)responseString);
        if (jwtContext != null && (claims = this.jose4jUtil.validateJwsSignature(jwtContext, clientConfig, oidcClientRequest)) != null) {
            return claims.toJson();
        }
        return null;
    }

    public String getUserInfoIfPossible(String sub, String accessToken, SSLSocketFactory sslsf, OidcClientRequest oidcClientRequest) {
        String userInfoStr;
        if (!this.willRetrieveUserInfo() || accessToken == null) {
            return null;
        }
        if (sub != null && (userInfoStr = this.getUserInfoFromURL(this.clientConfig, sslsf, accessToken, oidcClientRequest)) != null && this.isUserInfoValid(userInfoStr, sub)) {
            return userInfoStr;
        }
        return null;
    }
}

