/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.opentracing30.internal.rest.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.opentracing30.internal.rest.client.OpentracingRestClient30Filter;
import io.openliberty.opentracing.internal.OpentracingClientFilter;
import org.eclipse.microprofile.opentracing.Traced;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingRestClient30Listener
implements RestClientListener {
    private static final TraceComponent tc = Tr.register(OpentracingRestClient30Listener.class, (String)"OPENTRACING", null);
    static final long serialVersionUID = 6378478301103329254L;

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder builder) {
        Traced traced = serviceInterface.getAnnotation(Traced.class);
        if (traced != null && !traced.value()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Traced(false) specified on service interface", (Object[])new Object[0]);
            }
            builder.property(OpentracingClientFilter.CLIENT_FILTER_ENABLED_ID, (Object)false);
        } else {
            builder.register(OpentracingRestClient30Filter.class);
        }
    }
}

