/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.OIDCConstants;
import com.ibm.ws.security.openidconnect.server.internal.HttpUtils;
import com.ibm.ws.security.openidconnect.server.internal.OidcDiscoveryProviderConfig;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCWASDiscoveryModel;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Discovery {
    private static TraceComponent tc = Tr.register(Discovery.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    static final long serialVersionUID = -8421968146174768528L;

    public void processRequest(OidcServerConfig provider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        OIDCWASDiscoveryModel discoveryObj = new OIDCWASDiscoveryModel();
        OidcDiscoveryProviderConfig discoverConfig = new OidcDiscoveryProviderConfig(provider.getProviderId(), request);
        String issuerFromConfig = provider.getIssuerIdentifier();
        discoveryObj.setIssuer(issuerFromConfig == null || issuerFromConfig.isEmpty() ? discoverConfig.getIssuerId() : issuerFromConfig);
        discoveryObj.setAuthorizationEndpoint(discoverConfig.getEndpoint("oidc.provider.authorizationEndpoint"));
        discoveryObj.setTokenEndpoint(discoverConfig.getEndpoint("oidc.provider.tokenEndpoint"));
        discoveryObj.setJwks_uri(discoverConfig.getEndpoint("oidc.provider.jwksURI"));
        discoveryObj.setResponseTypesSupported(provider.getResponseTypesSupported());
        discoveryObj.setSubjectTypesSupported(provider.getSubjectTypesSupported());
        discoveryObj.setIdTokenSigningAlgValuesSupported(new String[]{provider.getIdTokenSigningAlgValuesSupported()});
        discoveryObj.setUserinfoEndpoint(discoverConfig.getEndpoint("oidc.provider.userinfoEndpoint"));
        discoveryObj.setRegistrationEndpoint(discoverConfig.getEndpoint("oidc.provider.registrationEndpoint"));
        discoveryObj.setScopesSupported(provider.getScopesSupported());
        discoveryObj.setClaimsSupported(provider.getClaimsSupported());
        discoveryObj.setResponseModesSupported(provider.getResponseModesSupported());
        discoveryObj.setGrantTypesSupported(provider.getGrantTypesSupported());
        discoveryObj.setTokenEndpointAuthMethodsSupported(provider.getTokenEndpointAuthMethodsSupported());
        discoveryObj.setDisplayValuesSupported(provider.getDisplayValuesSupported());
        discoveryObj.setClaimTypesSupported(provider.getClaimTypesSupported());
        discoveryObj.setClaimsParameterSupported(provider.isClaimsParameterSupported());
        discoveryObj.setRequestParameterSupported(provider.isRequestParameterSupported());
        discoveryObj.setRequestUriParameterSupported(provider.isRequestUriParameterSupported());
        discoveryObj.setRequireRequestUriRegistration(provider.isRequireRequestUriRegistration());
        discoveryObj.setCheckSessionIframe(discoverConfig.getEndpoint("oidc.provider.checkSessionIframe"));
        discoveryObj.setEndSessionEndpoint(discoverConfig.getEndpoint("oidc.provider.endSessionEndpoint"));
        discoveryObj.setIntrospectionEndpoint(discoverConfig.getEndpoint("oidc.provider.introspectionEndpoint"));
        discoveryObj.setCoverageMapEndpoint(discoverConfig.getEndpoint("oidc.provider.coverageMapEndpoint"));
        discoveryObj.setBackingIdpUriPrefix(provider.getBackingIdpUriPrefix());
        discoveryObj.setProxyEndpoint(provider.getAuthProxyEndpointUrl());
        discoveryObj.setRevocationEndpoint(discoverConfig.getEndpoint("oidc.provider.revocationEndpoint"));
        discoveryObj.setAppPasswordsEndpoint(discoverConfig.getEndpoint("oidc.provider.appPasswordsEndpoint"));
        discoveryObj.setAppTokensEndpoint(discoverConfig.getEndpoint("oidc.provider.appTokensEndpoint"));
        discoveryObj.setPersonalTokenMgmtEndpoint(discoverConfig.getEndpoint("oidc.provider.personalTokenMgmtEndpoint"));
        discoveryObj.setUsersTokenMgmtEndpoint(discoverConfig.getEndpoint("oidc.provider.usersTokenMgmtEndpoint"));
        discoveryObj.setClientMgmtEndpoint(discoverConfig.getEndpoint("oidc.provider.clientMgmtEndpoint"));
        discoveryObj.setPkceCodeChallengeMethodsSupported(OIDCConstants.OIDC_DISC_PKCE_CODE_CHALLENGE_METHODS_SUPPORTED);
        String discoverJSONString = discoveryObj.toJSONString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)new StringBuffer().append("Discover response for provider ").append(provider.getProviderId()).append(" :").append(discoverJSONString).toString(), (Object[])new Object[0]);
        }
        response.setContentType("application/json");
        response.setStatus(200);
        String cacheCtrHdr = HttpUtils.constructCacheControlHeaderWithMaxAge(true, "3600");
        response.setHeader("Cache-Control", cacheCtrHdr);
        response.getWriter().print(discoverJSONString);
        response.flushBuffer();
    }
}

