/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.routers;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericNameAddressHeaderImpl;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.SIPConnectionsModel;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.util.HashSet;
import java.util.Iterator;

public class SLSPRouter {
    private static final LogMgr c_logger = Log.get(SLSPRouter.class);
    private static SLSPRouter s_instance = new SLSPRouter();
    private Hop m_outboundProxy = null;
    private HashSet m_slsps = null;
    private Iterator m_roundRobin = null;

    public static SLSPRouter getInstance() {
        return s_instance;
    }

    protected SLSPRouter() {
        if (s_instance != null && s_instance != this && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Warning: SLSPRouter instantiated again");
        }
        s_instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(Request request) throws SipParseException {
        boolean known;
        if (this.m_slsps == null) {
            return;
        }
        ViaHeader topVia = (ViaHeader)request.getHeader("Via", true);
        Hop slsp = new Hop(topVia);
        SLSPRouter sLSPRouter = this;
        synchronized (sLSPRouter) {
            known = this.m_slsps.contains(slsp);
        }
        if (!known && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Warning: incoming request from unknown SLSP [" + slsp.toString() + ']');
        }
    }

    public synchronized void removeConnectionHop(Hop connectionHop) {
        if (this.m_slsps == null) {
            return;
        }
        if (this.m_slsps.remove(connectionHop)) {
            this.resetRoundRobin();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("removed SLSP [" + connectionHop.toString() + ']');
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Warning: attempt to remove unknown SLSP [" + connectionHop.toString() + ']');
        }
    }

    public Hop getOutboundProxy() {
        return this.m_outboundProxy;
    }

    public void setOutboundProxy(Hop proxy) {
        this.m_outboundProxy = proxy;
    }

    public Hop getNextHop(Request request, Hop originalHop) {
        if (this.m_outboundProxy != null) {
            return this.m_outboundProxy;
        }
        if (this.m_slsps == null && originalHop != null) {
            return originalHop;
        }
        SipURL url = this.getRemoteTarget(request);
        Hop hop = url == null ? null : this.getNextHop(url);
        return hop;
    }

    public Hop getNextHop(Response response) {
        ViaHeader topVia;
        Hop hop;
        block8: {
            hop = null;
            SipURL url = this.getRemoteTarget(response);
            if (url != null) {
                hop = this.getNextHop(url);
            }
            if (hop != null) {
                return hop;
            }
            topVia = null;
            try {
                topVia = (ViaHeader)response.getHeader("Via", true);
            }
            catch (SipParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block8;
                c_logger.traceDebug(this, "getNextHop", "Error parsing top Via", e2);
            }
        }
        if (topVia == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getNextHop", "Error: cannot reply with no Via");
            }
            return null;
        }
        hop = new Hop(topVia);
        if (this.m_slsps != null && !this.m_slsps.contains(hop)) {
            if (c_logger.isTraceFailureEnabled()) {
                c_logger.traceFailure(this, "getNextHop", "Warning: routing response by round-robin because original request proxy [" + hop + "] is gone");
            }
            String transport = topVia.getTransport().toUpperCase();
            hop = this.getRoundRobin(transport);
        }
        return hop;
    }

    protected Hop getNextHop(SipURL url) {
        Hop hop;
        if (this.m_slsps == null) {
            hop = Hop.getHop(url);
        } else {
            String transport = SLSPRouter.getTransport(url).toUpperCase();
            boolean outboundExtension = url.hasParameter("ibm-ob");
            if (outboundExtension) {
                String host = url.getParameter("ibm-proxyhost");
                String portStr = url.getParameter("ibm-proxyport");
                int port = Integer.parseInt(portStr);
                hop = this.getSLSP(transport, host, port);
            } else {
                if (url.hasParameter("ob")) {
                    url.removeParameter("ob");
                }
                hop = this.getRoundRobin(transport);
            }
        }
        return hop;
    }

    private synchronized Hop getRoundRobin(String transport) {
        Hop firstSlsp;
        if (this.m_slsps.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getNextHop", "Error: No known SLSPs");
            }
            return null;
        }
        if (!this.m_roundRobin.hasNext()) {
            this.resetRoundRobin();
            if (!this.m_roundRobin.hasNext()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getNextHop", "Error: No round-robin SLSP");
                }
                return null;
            }
        }
        Hop hop = firstSlsp = (Hop)this.m_roundRobin.next();
        boolean found = false;
        do {
            if (hop.getTrasport().equals(transport)) {
                found = true;
                break;
            }
            if (this.m_roundRobin.hasNext()) continue;
            this.resetRoundRobin();
        } while ((hop = (Hop)this.m_roundRobin.next()) != firstSlsp);
        if (!found) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("No SLSP for transport [" + transport + ']');
            }
            return null;
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buf = new StringBuffer("Round-robin SLSP for [");
            buf.append(transport);
            buf.append("] is [");
            buf.append(hop);
            buf.append(']');
            c_logger.traceDebug(this, "getRoundRobinSLSP", buf.toString());
        }
        return hop;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SipURL getRemoteTarget(Message message) {
        try {
            URI uri = null;
            GenericNameAddressHeaderImpl nameAddress = (GenericNameAddressHeaderImpl)message.getHeader("IBM-Destination", true);
            if (nameAddress == null) {
                if (!(message instanceof Request)) return null;
                NameAddressHeader topRoute = (NameAddressHeader)message.getHeader("Route", true);
                uri = topRoute == null ? ((Request)message).getRequestURI() : topRoute.getNameAddress().getAddress();
            } else {
                uri = nameAddress.getNameAddress().getAddress();
            }
            if (uri instanceof SipURL) {
                return (SipURL)uri;
            }
            if (!c_logger.isTraceDebugEnabled()) return null;
            c_logger.traceDebug("Error: getRemoteTarget - uri is not a SipURL");
            return null;
        }
        catch (SipParseException e2) {
            if (!c_logger.isTraceDebugEnabled()) return null;
            c_logger.traceDebug((Object)SLSPRouter.class.getName(), "getNextHops", e2.getMessage(), e2);
            return null;
        }
    }

    private static String getTransport(SipURL url) {
        String transport = url.getTransport();
        if (transport == null) {
            transport = url.getScheme().equalsIgnoreCase("sips") ? SIPConnectionsModel.instance().getDefaultSecureTransport() : "udp";
        }
        return transport;
    }

    private void resetRoundRobin() {
        this.m_roundRobin = this.m_slsps.iterator();
    }

    private Hop getSLSP(String transport, String host, int port) {
        if (this.m_slsps == null) {
            return null;
        }
        Hop hop = new Hop(transport, host, port);
        return this.m_slsps.contains(hop) ? hop : null;
    }

    public synchronized void addSLSP(Hop slsp) {
        if (this.m_outboundProxy != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Error: attempt to dynamically add SLSP with static OUTBOUND_PROXY configuration");
            }
            return;
        }
        if (this.m_slsps == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SLSPRouter switching to SLSP mode");
            }
            this.m_slsps = new HashSet();
        }
        if (this.m_slsps.add(slsp)) {
            this.resetRoundRobin();
        }
    }

    public synchronized void removeSLSP(Hop slsp) {
        if (this.m_slsps == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Error: attempt to remove SLSP [" + slsp.toString() + "] in standalone mode");
            }
            return;
        }
        this.removeConnectionHop(slsp);
    }

    public synchronized void removeSLSPs() {
        if (this.m_slsps == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Error: removeSLSPs called in standalone mode");
            }
            return;
        }
        this.m_slsps.clear();
        this.resetRoundRobin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hop switchTransport(Hop udpHop) {
        Hop hop;
        if (this.m_slsps == null) {
            Hop tcpHop = new Hop("TCP", udpHop.getHost(), udpHop.getPort());
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "switchTransport", "created new hop [" + tcpHop + "] in standalone mode");
            }
            return tcpHop;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "switchTransport", "finding suitable TCP hop in SLSP mode for [" + udpHop + ']');
        }
        Hop tcpHopOnSameHost = null;
        Hop tlsHopOnSameHost = null;
        Hop tcpHopOnDifferentHost = null;
        Hop tlsHopOnDifferentHost = null;
        String host = udpHop.getHost();
        SLSPRouter sLSPRouter = this;
        synchronized (sLSPRouter) {
            Hop firstSlsp;
            if (this.m_slsps.isEmpty()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "switchTransport", "Warning: no known SLSPs");
                }
                return udpHop;
            }
            if (!this.m_roundRobin.hasNext()) {
                this.resetRoundRobin();
                if (!this.m_roundRobin.hasNext()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "switchTransport", "Error: No round-robin SLSP");
                    }
                    return udpHop;
                }
            }
            hop = firstSlsp = (Hop)this.m_roundRobin.next();
            do {
                if (hop.getTrasport().equals("TCP")) {
                    if (hop.getHost().equals(host)) {
                        tcpHopOnSameHost = hop;
                        break;
                    }
                    tcpHopOnDifferentHost = hop;
                } else if (hop.getTrasport().equals("TLS")) {
                    if (hop.getHost().equals(host)) {
                        tlsHopOnSameHost = hop;
                    } else {
                        tlsHopOnDifferentHost = hop;
                    }
                }
                if (this.m_roundRobin.hasNext()) continue;
                this.resetRoundRobin();
            } while ((hop = (Hop)this.m_roundRobin.next()) != firstSlsp);
        }
        hop = null;
        if (tcpHopOnSameHost != null) {
            hop = tcpHopOnSameHost;
        } else if (tlsHopOnSameHost != null) {
            hop = tlsHopOnSameHost;
        } else if (tcpHopOnDifferentHost != null) {
            hop = tcpHopOnDifferentHost;
        } else if (tlsHopOnDifferentHost != null) {
            hop = tlsHopOnDifferentHost;
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "switchTransport", "Warning: no TCP/TLS-enabled SLSPs for switching transport");
            }
            hop = udpHop;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "switchTransport", "switched from [" + udpHop + "] to [" + hop + ']');
        }
        return hop;
    }

    public boolean isStandAloneMode() {
        return this.m_slsps == null;
    }
}

