/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsJMSProducer;
import com.ibm.ws.sib.api.jms.impl.JmsBytesMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMapMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsMsgProducerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsObjectMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTextMessageImpl;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.MessageProducer;

public class JmsJMSProducerImpl
implements JmsJMSProducer {
    private static TraceComponent tc = SibTr.register(JmsJMSProducerImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private final JmsMsgProducerImpl messageProducer;
    private HashMap<String, Object> jmsProducerProperties;
    private String jmsCorrelationID;
    private boolean jmsCorrelationIDSet = false;
    private byte[] jmsCorrelationIDAsBytes;
    private boolean jmsCorrelationIDAsBytesSet = false;
    private Destination jmsReplyTo;
    private boolean replyToSet = false;
    private String jmsType;
    private boolean jmsTypeSet = false;
    private static final String ID_STRING = "ID:";
    private volatile CompletionListener _completionListerner = null;

    public JmsJMSProducerImpl(MessageProducer messageProducer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsJMSProducerImpl", (Object)messageProducer);
        }
        this.messageProducer = (JmsMsgProducerImpl)messageProducer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsJMSProducerImpl");
        }
    }

    public JMSProducer clearProperties() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearProperties");
        }
        if (this.jmsProducerProperties != null) {
            this.jmsProducerProperties.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearProperties");
        }
        return this;
    }

    public CompletionListener getAsync() throws JMSRuntimeException {
        return this._completionListerner;
    }

    public boolean getBooleanProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBooleanProperty");
        }
        Object obj = null;
        boolean value = false;
        try {
            obj = this.getObjByName(name);
            value = JmsMessageImpl.parseBoolean(obj, name);
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBooleanProperty", (Object)value);
            }
        }
        return value;
    }

    public byte getByteProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getByteProperty");
        }
        Object obj = null;
        byte value = 0;
        try {
            obj = this.getObjByName(name);
            value = JmsMessageImpl.parseByte(obj, name);
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getByteProperty", (Object)value);
            }
        }
        return value;
    }

    public long getDeliveryDelay() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDeliveryDelay");
        }
        long deliveryDelay = -1L;
        try {
            deliveryDelay = this.messageProducer.getDeliveryDelay();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDeliveryDelay", (Object)deliveryDelay);
            }
        }
        return deliveryDelay;
    }

    public int getDeliveryMode() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDeliveryMode");
        }
        int deliveryMode = -1;
        try {
            deliveryMode = this.messageProducer.getDeliveryMode();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDeliveryMode", (Object)deliveryMode);
            }
        }
        return deliveryMode;
    }

    public boolean getDisableMessageID() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDisableMessageID");
        }
        boolean disableMessageID = false;
        try {
            disableMessageID = this.messageProducer.getDisableMessageID();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDisableMessageID", (Object)disableMessageID);
            }
        }
        return disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDisableMessageTimestamp");
        }
        boolean disableMessageTimestamp = false;
        try {
            disableMessageTimestamp = this.messageProducer.getDisableMessageTimestamp();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDisableMessageTimestamp", (Object)disableMessageTimestamp);
            }
        }
        return disableMessageTimestamp;
    }

    public double getDoubleProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDoubleProperty");
        }
        Object obj = null;
        double value = 0.0;
        try {
            obj = this.getObjByName(name);
            value = JmsMessageImpl.parseDouble(obj, name);
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDoubleProperty", (Object)value);
            }
        }
        return value;
    }

    public float getFloatProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFloatProperty");
        }
        Object obj = null;
        float value = 0.0f;
        try {
            obj = this.getObjByName(name);
            value = JmsMessageImpl.parseFloat(obj, name);
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFloatProperty", (Object)Float.valueOf(value));
            }
        }
        return value;
    }

    public int getIntProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getIntProperty");
        }
        Object obj = null;
        int value = 0;
        try {
            obj = this.getObjByName(name);
            value = JmsMessageImpl.parseInt(obj, name);
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getIntProperty", (Object)value);
            }
        }
        return value;
    }

    public String getJMSCorrelationID() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSCorrelationID");
        }
        String correl = null;
        if (this.jmsCorrelationID != null) {
            correl = this.jmsCorrelationID;
        } else if (this.jmsCorrelationIDAsBytes != null) {
            StringBuffer sbuf = new StringBuffer(this.jmsCorrelationIDAsBytes.length * 2 + 3);
            sbuf.append(ID_STRING);
            HexString.binToHex((byte[])this.jmsCorrelationIDAsBytes, (int)0, (int)this.jmsCorrelationIDAsBytes.length, (StringBuffer)sbuf);
            correl = sbuf.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSCorrelationID", (Object)correl);
        }
        return correl;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSCorrelationIDAsBytes");
        }
        byte[] value = null;
        if (this.jmsCorrelationIDAsBytes != null) {
            byte[] temp = this.jmsCorrelationIDAsBytes;
            value = new byte[temp.length];
            System.arraycopy(temp, 0, value, 0, temp.length);
        } else if (this.jmsCorrelationID != null) {
            String strValue = this.jmsCorrelationID;
            value = strValue.startsWith(ID_STRING) ? HexString.hexToBin((String)strValue, (int)3) : strValue.getBytes(StandardCharsets.UTF_8);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSCorrelationIDAsBytes", (Object)this.jmsCorrelationIDAsBytes);
        }
        return value;
    }

    public Destination getJMSReplyTo() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSReplyTo");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSReplyTo", (Object)this.jmsReplyTo);
        }
        return this.jmsReplyTo;
    }

    public String getJMSType() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getJMSType");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getJMSType", (Object)this.jmsType);
        }
        return this.jmsType;
    }

    public long getLongProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLongProperty");
        }
        Object obj = null;
        long value = 0L;
        try {
            obj = this.getObjByName(name);
            value = JmsMessageImpl.parseLong(obj, name);
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLongProperty", (Object)value);
            }
        }
        return value;
    }

    public Object getObjectProperty(String name) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObjectProperty", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.getObjByName(name);
            if (name.equals("JMS_IBM_Character_Set") && obj instanceof Integer) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"special case for charset, setting as string");
                }
                obj = String.valueOf(obj);
            }
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObjectProperty", (Object)obj);
            }
        }
        return obj;
    }

    public int getPriority() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPriority");
        }
        int priority = -1;
        try {
            priority = this.messageProducer.getPriority();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPriority", (Object)priority);
            }
        }
        return priority;
    }

    public Set<String> getPropertyNames() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPropertyNames");
        }
        Set<String> propNames = null;
        try {
            if (this.jmsProducerProperties != null) {
                propNames = Collections.unmodifiableSet(this.jmsProducerProperties.keySet());
            }
        }
        catch (Exception e) {
            throw (JMSRuntimeException)JmsErrorUtils.newThrowable(JMSRuntimeException.class, "INTERNAL_ERROR_CWSIA0386", null, e, null, this, tc);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPropertyNames", propNames);
            }
        }
        return propNames;
    }

    public short getShortProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getShortProperty");
        }
        Object obj = null;
        short value = 0;
        try {
            obj = this.getObjByName(name);
            value = JmsMessageImpl.parseShort(obj, name);
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getShortProperty", (Object)value);
            }
        }
        return value;
    }

    public String getStringProperty(String name) throws JMSRuntimeException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStringProperty");
        }
        Object obj = null;
        String value = null;
        try {
            obj = this.getObjByName(name);
            value = obj instanceof String || obj == null ? (String)obj : obj.toString();
        }
        catch (MessageFormatException mfe) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStringProperty", (Object)value);
            }
        }
        return value;
    }

    public long getTimeToLive() throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTimeToLive");
        }
        long ttl = -1L;
        try {
            ttl = this.messageProducer.getTimeToLive();
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTimeToLive");
            }
        }
        return ttl;
    }

    public boolean propertyExists(String name) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"propertyExists", (Object)name);
        }
        boolean exists = false;
        try {
            if (this.jmsProducerProperties != null) {
                exists = this.jmsProducerProperties.containsKey(name);
            }
        }
        catch (Exception e) {
            throw (JMSRuntimeException)JmsErrorUtils.newThrowable(JMSRuntimeException.class, "INTERNAL_ERROR_CWSIA0386", null, e, null, this, tc);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"propertyExists", (Object)exists);
            }
        }
        return exists;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSProducer send(Destination dest, byte[] body) throws MessageFormatRuntimeException, InvalidDestinationRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dest, body});
        }
        try {
            JmsBytesMessageImpl msg = new JmsBytesMessageImpl();
            if (body != null) {
                msg.writeBytes(body);
            }
            this.inheritProducerProperties(msg);
            this.messageProducer.send_internal(dest, msg, this._completionListerner);
        }
        catch (MessageFormatException mfe) {
            try {
                throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
                catch (InvalidDestinationException ide) {
                    throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return this;
        if (!tc.isEntryEnabled()) return this;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSProducer send(Destination dest, Map<String, Object> body) throws MessageFormatRuntimeException, InvalidDestinationRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dest, body});
        }
        try {
            JmsMapMessageImpl msg = new JmsMapMessageImpl();
            if (body != null) {
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    msg.setObject(entry.getKey(), entry.getValue());
                }
            }
            this.inheritProducerProperties(msg);
            this.messageProducer.send_internal(dest, msg, this._completionListerner);
        }
        catch (MessageFormatException mfe) {
            try {
                throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
                catch (InvalidDestinationException ide) {
                    throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return this;
        if (!tc.isEntryEnabled()) return this;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSProducer send(Destination dest, Message msg) throws MessageFormatRuntimeException, InvalidDestinationRuntimeException, MessageNotWriteableRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dest, msg});
        }
        try {
            this.inheritProducerProperties(msg);
            this.messageProducer.send_internal(dest, msg, this._completionListerner);
        }
        catch (MessageFormatException mfe) {
            try {
                throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
                catch (InvalidDestinationException ide) {
                    throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                }
                catch (MessageNotWriteableException mnwe) {
                    throw (MessageNotWriteableRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mnwe), MessageNotWriteableRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return this;
        if (!tc.isEntryEnabled()) return this;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSProducer send(Destination dest, Serializable body) throws MessageFormatRuntimeException, InvalidDestinationRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dest, body});
        }
        try {
            JmsObjectMessageImpl msg = null;
            msg = body != null ? new JmsObjectMessageImpl(body) : new JmsObjectMessageImpl();
            this.inheritProducerProperties(msg);
            this.messageProducer.send_internal(dest, msg, this._completionListerner);
        }
        catch (MessageFormatException mfe) {
            try {
                throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
                catch (InvalidDestinationException ide) {
                    throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return this;
        if (!tc.isEntryEnabled()) return this;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSProducer send(Destination dest, String body) throws MessageFormatRuntimeException, InvalidDestinationRuntimeException, JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{dest, body});
        }
        try {
            JmsTextMessageImpl msg = null;
            msg = body != null ? new JmsTextMessageImpl(body) : new JmsTextMessageImpl();
            this.inheritProducerProperties(msg);
            this.messageProducer.send_internal(dest, msg, this._completionListerner);
        }
        catch (MessageFormatException mfe) {
            try {
                throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)mfe), MessageFormatRuntimeException.class);
                catch (InvalidDestinationException ide) {
                    throw (InvalidDestinationRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)ide), InvalidDestinationRuntimeException.class);
                }
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return this;
        if (!tc.isEntryEnabled()) return this;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{this});
        return this;
    }

    private void inheritProducerProperties(Message msg) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"inheritProducerProperties", (Object)new Object[]{msg});
        }
        if (msg != null) {
            if (this.jmsCorrelationIDSet) {
                msg.setJMSCorrelationID(this.jmsCorrelationID);
            }
            if (this.jmsCorrelationIDAsBytesSet) {
                msg.setJMSCorrelationIDAsBytes(this.jmsCorrelationIDAsBytes);
            }
            if (this.replyToSet) {
                msg.setJMSReplyTo(this.jmsReplyTo);
            }
            if (this.jmsTypeSet) {
                msg.setJMSType(this.jmsType);
            }
            if (this.jmsProducerProperties != null) {
                Set<String> producerProperties = this.jmsProducerProperties.keySet();
                for (String key : producerProperties) {
                    msg.setObjectProperty(key, this.jmsProducerProperties.get(key));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"inheritProducerProperties", (Object)new Object[]{msg});
        }
    }

    public JMSProducer setAsync(CompletionListener cListerner) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAsync", (Object)cListerner);
        }
        if (this.messageProducer.isManaged()) {
            JMSException jmse = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "MGD_ENV_CWSIA0084", new Object[]{"JMSProducer.setAsync"}, tc);
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        this._completionListerner = cListerner;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAsync");
        }
        return this;
    }

    public JMSProducer setDeliveryDelay(long value) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay", (Object)value);
        }
        try {
            this.messageProducer.setDeliveryDelay(value);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay", (Object)new Object[]{this});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay", (Object)new Object[]{this});
        }
        return this;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryMode", (Object)deliveryMode);
        }
        try {
            this.messageProducer.setDeliveryMode(deliveryMode);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryMode", (Object)new Object[]{this});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryMode", (Object)new Object[]{this});
        }
        return this;
    }

    public JMSProducer setDisableMessageID(boolean value) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDisableMessageID", (Object)value);
        }
        try {
            this.messageProducer.setDisableMessageID(value);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageID", (Object)new Object[]{this});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageID", (Object)new Object[]{this});
        }
        return this;
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDisableMessageTimestamp", (Object)value);
        }
        try {
            this.messageProducer.setDisableMessageTimestamp(value);
        }
        catch (JMSException jmse) {
            try {
                throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageTimestamp", (Object)new Object[]{this});
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDisableMessageTimestamp", (Object)new Object[]{this});
        }
        return this;
    }

    public JMSProducer setJMSCorrelationID(String value) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSCorrelationID", (Object)value);
        }
        try {
            if (value != null && value.startsWith(ID_STRING)) {
                boolean needsConvert = false;
                int length = value.length();
                if (length % 2 == 0) {
                    String nlsMsg = nls.getFormattedMessage("BAD_HEX_STRING_CWSIF0191", new Object[]{value}, "The hexadecimal string " + value + " is incorrectly formatted for a Correlation Id");
                    JMSException e = new JMSException(nlsMsg);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCorrelationId", (Object)((Object)e));
                    }
                    throw e;
                }
                for (int i = 3; i < length; ++i) {
                    char ch = value.charAt(i);
                    if (Character.digit(ch, 16) < 0) {
                        String nlsMsg = nls.getFormattedMessage("BAD_HEX_STRING_CWSIF0191", new Object[]{value}, "The hexadecimal string " + value + " is incorrectly formatted for a Correlation Id");
                        JMSException e = new JMSException(nlsMsg);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCorrelationId", (Object)((Object)e));
                        }
                        throw e;
                    }
                    if (!Character.isUpperCase(ch)) continue;
                    needsConvert = true;
                }
                if (needsConvert) {
                    value = ID_STRING + value.substring(3).toLowerCase();
                }
            }
            this.jmsCorrelationID = value;
            this.jmsCorrelationIDSet = true;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSCorrelationID");
            }
        }
        return this;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] value) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCorrelationIdAsBytes", (Object)value);
        }
        try {
            if (value != null) {
                byte[] copy = new byte[value.length];
                System.arraycopy(value, 0, copy, 0, value.length);
                this.jmsCorrelationIDAsBytes = copy;
            } else {
                this.jmsCorrelationIDAsBytes = null;
            }
            this.jmsCorrelationIDAsBytesSet = true;
        }
        catch (Exception e) {
            throw (JMSRuntimeException)JmsErrorUtils.newThrowable(JMSRuntimeException.class, "INTERNAL_ERROR_CWSIA0386", null, e, null, this, tc);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCorrelationIdAsBytes");
            }
        }
        return this;
    }

    public JMSProducer setJMSReplyTo(Destination destination) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSReplyTo", (Object)destination);
        }
        try {
            if (destination instanceof JmsDestinationImpl) {
                this.jmsReplyTo = destination;
            } else if (destination == null) {
                this.jmsReplyTo = null;
            } else {
                throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0116", new Object[]{"JMSReplyTo", destination.getClass().toString()}, null, "JmsMessageImpl.setJMSReplyTo#1", this, tc);
            }
            this.replyToSet = true;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSReplyTo");
            }
        }
        return this;
    }

    public JMSProducer setJMSType(String jmsType) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJMSType", (Object)new Object[]{jmsType});
        }
        this.jmsType = jmsType;
        this.jmsTypeSet = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJMSType");
        }
        return this;
    }

    public JMSProducer setPriority(int priority) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)new Object[]{priority});
        }
        try {
            this.messageProducer.setPriority(priority);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, boolean value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Boolean.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, value);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, byte value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Byte.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, value);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, double value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Double.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, value);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, float value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, Float.valueOf(value)});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Float.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, Float.valueOf(value));
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, int value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Integer.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, value);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, long value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Long.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, value);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, Object value) throws JMSRuntimeException, IllegalArgumentException, MessageFormatRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            Class<?> type = null;
            if (value != null) {
                type = value.getClass();
            }
            JmsMessageImpl.checkSettablePropertyNameAndType(name, type);
            if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof byte[])) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("value is bad type: " + value.getClass().getName()));
                }
                throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "BAD_OBJECT_CWSIA0188", new Object[]{value.getClass().getName()}, tc);
            }
            if (value instanceof byte[]) {
                byte[] v = (byte[])value;
                byte[] tmp = new byte[v.length];
                System.arraycopy(v, 0, tmp, 0, v.length);
                value = tmp;
            }
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, value);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (MessageFormatException jmse) {
            throw (MessageFormatRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)jmse), MessageFormatRuntimeException.class);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, short value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, Short.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, value);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    public JMSProducer setProperty(String name, String value) throws JMSRuntimeException, IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProperty", (Object)new Object[]{name, value});
        }
        try {
            JmsMessageImpl.checkPropName(name, "setProperty");
            JmsMessageImpl.checkSettablePropertyNameAndType(name, String.class);
            if (this.jmsProducerProperties == null) {
                this.jmsProducerProperties = new HashMap();
            }
            this.jmsProducerProperties.put(name, String.valueOf(value));
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProperty");
            }
        }
        return this;
    }

    private Object getObjByName(String name) throws JMSException {
        Object obj = null;
        if (name == null) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{null}, tc);
        }
        if ("".equals(name)) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_PROPNAME_CWSIA0112", new Object[]{"\"\""}, tc);
        }
        if (this.jmsProducerProperties != null && this.jmsProducerProperties.containsKey(name)) {
            obj = this.jmsProducerProperties.get(name);
        }
        return obj;
    }

    public JMSProducer setTimeToLive(long ttl) throws JMSRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)new Object[]{ttl});
        }
        try {
            this.messageProducer.setTimeToLive(ttl);
        }
        catch (JMSException jmse) {
            throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive");
            }
        }
        return this;
    }
}

