/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.validator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.sso.common.SsoService;
import com.ibm.ws.wssecurity.token.TokenUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.opensaml.saml.common.SAMLVersion;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WssSamlAssertionValidator
extends SamlAssertionValidator {
    private static final TraceComponent tc = Tr.register(WssSamlAssertionValidator.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    List<String> audienceRestrictions = new ArrayList<String>();
    int iFutureTTL = 300;
    int ttl = 1800;
    static final long serialVersionUID = -5753842956052502654L;

    public WssSamlAssertionValidator(Map<String, Object> configMap) {
        this.setValidateSignatureAgainstProfile(true);
        this.setRequireStandardSubjectConfirmationMethod(true);
        if (configMap != null) {
            String[] restrictions;
            this.setRequiredSubjectConfirmationMethod((String)configMap.get("requiredSubjectConfirmationMethod"));
            this.setRequireBearerSignature((Boolean)configMap.get("wantAssertionsSigned"));
            this.iFutureTTL = ((Long)configMap.get("clockSkew")).intValue();
            this.setFutureTTL(this.iFutureTTL);
            this.ttl = ((Long)configMap.get("timeToLive")).intValue();
            this.setTtl(this.ttl);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("futureTTL:" + this.iFutureTTL + " ttl:" + this.ttl), (Object[])new Object[0]);
            }
            if ((restrictions = (String[])configMap.get("audienceRestrictions")) != null) {
                this.audienceRestrictions = new ArrayList<String>();
                for (int iI = 0; iI < restrictions.length; ++iI) {
                    this.audienceRestrictions.add(restrictions[iI]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("audienceRestriction:" + restrictions[iI]), (Object[])new Object[0]);
                }
            }
        }
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        SsoService wssSamlService = TokenUtils.getCommonSsoService("wssSaml");
        if (wssSamlService == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "No wsSecuritySaml-1.1 feature is up. Make sure your server.xml has wsSecuritySaml-1.1 feature set up properly");
        }
        data.setAudienceRestrictions(this.audienceRestrictions);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" audienceRestriction:" + this.audienceRestrictions), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)(" audienceRestriction:" + this.audienceRestrictions.isEmpty()), (Object[])new Object[0]);
        }
        return super.validate(credential, data);
    }

    protected void checkConditions(SamlAssertionWrapper assertion) throws WSSecurityException {
        Instant earliestAllowedIssuance;
        Instant currentTime;
        Instant currentTimePlusSkew;
        Instant validFrom = null;
        Instant validTill = null;
        Instant issueInstant = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && assertion.getSaml2().getConditions() != null) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
            issueInstant = assertion.getSaml2().getIssueInstant();
        } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) && assertion.getSaml1().getConditions() != null) {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
            issueInstant = assertion.getSaml1().getIssueInstant();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("futureTTL(clockSkew):" + this.iFutureTTL + " ttl:" + this.ttl), (Object[])new Object[0]);
        }
        if (validFrom != null && validFrom.isAfter(currentTimePlusSkew = (currentTime = Instant.now()).plusSeconds(this.iFutureTTL))) {
            Tr.error((TraceComponent)tc, (String)"saml_token_not_yet_valid", (Object[])new Object[]{validFrom, currentTime, this.iFutureTTL});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (validTill != null) {
            Instant validTillPlusSkew = validTill.plusSeconds(this.iFutureTTL);
            Instant currentTime2 = Instant.now();
            if (validTillPlusSkew.isBefore(Instant.now())) {
                Tr.error((TraceComponent)tc, (String)"saml_token_expired", (Object[])new Object[]{validTill, currentTime2, this.iFutureTTL});
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        } else if (issueInstant != null && issueInstant.isBefore(earliestAllowedIssuance = (currentTime = Instant.now()).minusSeconds(this.ttl + this.iFutureTTL))) {
            Tr.error((TraceComponent)tc, (String)"saml_token_issued_too_long_ago", (Object[])new Object[]{issueInstant, currentTime, this.iFutureTTL});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (issueInstant != null && issueInstant.isAfter(currentTimePlusSkew = (currentTime = Instant.now()).plusSeconds(this.iFutureTTL))) {
            Tr.error((TraceComponent)tc, (String)"saml_token_issue_instant_in_future", (Object[])new Object[]{issueInstant, currentTime, this.iFutureTTL});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }
}

