/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.setup;

import com.ibm.ws.common.crypto.CryptoUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ext.WSSConfigurationException;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.wss4j.stax.setup.InboundWSSec;
import org.apache.wss4j.stax.setup.OutboundWSSec;
import org.apache.xml.security.binding.xmldsig.ObjectFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.config.Init;
import org.apache.xml.security.stax.ext.SecurePart;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.impl.util.ConcreteLSInput;
import org.apache.xml.security.utils.ClassLoaderUtils;
import org.glassfish.jaxb.runtime.v2.JAXBContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class WSSec {
    private static final Logger LOG;

    public static void init() {
    }

    public static OutboundWSSec getOutboundWSSec(WSSSecurityProperties securityProperties) throws WSSecurityException {
        if (securityProperties == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "missingSecurityProperties");
        }
        securityProperties = WSSec.validateAndApplyDefaultsToOutboundSecurityProperties(securityProperties);
        return new OutboundWSSec(securityProperties);
    }

    public static InboundWSSec getInboundWSSec(WSSSecurityProperties securityProperties) throws WSSecurityException {
        return WSSec.getInboundWSSec(securityProperties, false);
    }

    public static InboundWSSec getInboundWSSec(WSSSecurityProperties securityProperties, boolean initiator) throws WSSecurityException {
        return WSSec.getInboundWSSec(securityProperties, false, false);
    }

    public static InboundWSSec getInboundWSSec(WSSSecurityProperties securityProperties, boolean initiator, boolean returnSecurityError) throws WSSecurityException {
        if (securityProperties == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "missingSecurityProperties");
        }
        securityProperties = WSSec.validateAndApplyDefaultsToInboundSecurityProperties(securityProperties);
        return new InboundWSSec(securityProperties, initiator, returnSecurityError);
    }

    public static WSSSecurityProperties validateAndApplyDefaultsToOutboundSecurityProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        if (securityProperties.getActions() == null || securityProperties.getActions().isEmpty()) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noOutputAction");
        }
        if (new HashSet(securityProperties.getActions()).size() != securityProperties.getActions().size()) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "stax.duplicateActions");
        }
        for (XMLSecurityConstants.Action action : securityProperties.getActions()) {
            if (WSSConstants.TIMESTAMP.equals((Object)action)) {
                if (securityProperties.getTimestampTTL() != null) continue;
                securityProperties.setTimestampTTL(300);
                continue;
            }
            if (WSSConstants.SIGNATURE.equals((Object)action)) {
                WSSec.checkOutboundSignatureProperties(securityProperties);
                continue;
            }
            if (WSSConstants.ENCRYPT.equals((Object)action)) {
                WSSec.checkOutboundEncryptionProperties(securityProperties);
                continue;
            }
            if (WSSConstants.USERNAMETOKEN.equals((Object)action)) {
                if (securityProperties.getTokenUser() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noTokenUser");
                }
                if (securityProperties.getCallbackHandler() == null && WSSConstants.UsernameTokenPasswordType.PASSWORD_NONE != securityProperties.getUsernameTokenPasswordType()) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getUsernameTokenPasswordType() != null) continue;
                securityProperties.setUsernameTokenPasswordType(WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST);
                continue;
            }
            if (WSSConstants.USERNAMETOKEN_SIGNED.equals((Object)action)) {
                if (securityProperties.getTokenUser() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noTokenUser");
                }
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm(WSSec.getHmacSignatureAlgorithm());
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm(WSSec.getSignatureDigestAlgorithm());
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KEYIDENTIFIER_USERNAME_TOKEN_REFERENCE);
                if (securityProperties.getUsernameTokenPasswordType() == null) {
                    securityProperties.setUsernameTokenPasswordType(WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST);
                }
                WSSec.checkDefaultSecureParts(true, securityProperties);
                continue;
            }
            if (WSSConstants.SIGNATURE_WITH_DERIVED_KEY.equals((Object)action)) {
                WSSec.checkOutboundSignatureDerivedProperties(securityProperties);
                continue;
            }
            if (WSSConstants.ENCRYPTION_WITH_DERIVED_KEY.equals((Object)action)) {
                WSSec.checkOutboundEncryptionDerivedProperties(securityProperties);
                continue;
            }
            if (WSSConstants.SAML_TOKEN_SIGNED.equals((Object)action)) {
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getSamlCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noSAMLCallbackHandler");
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm(WSSec.getRsaSignatureAlgorithm());
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm(WSSec.getSignatureDigestAlgorithm());
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                if (securityProperties.getSignatureKeyIdentifiers().isEmpty()) {
                    securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KEYIDENTIFIER_SECURITY_TOKEN_DIRECT_REFERENCE);
                }
                WSSec.checkDefaultSecureParts(true, securityProperties);
                continue;
            }
            if (WSSConstants.SAML_TOKEN_UNSIGNED.equals((Object)action) && securityProperties.getSamlCallbackHandler() == null) {
                throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noSAMLCallbackHandler");
            }
            if (WSSConstants.SIGNATURE_WITH_KERBEROS_TOKEN.equals((Object)action)) {
                if (securityProperties.getCallbackHandler() == null) {
                    throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
                }
                if (securityProperties.getSignatureAlgorithm() == null) {
                    securityProperties.setSignatureAlgorithm(WSSec.getHmacSignatureAlgorithm());
                }
                if (securityProperties.getSignatureDigestAlgorithm() == null) {
                    securityProperties.setSignatureDigestAlgorithm(WSSec.getSignatureDigestAlgorithm());
                }
                if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
                    securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                }
                if (securityProperties.getSignatureKeyIdentifiers().isEmpty()) {
                    securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KEYIDENTIFIER_SECURITY_TOKEN_DIRECT_REFERENCE);
                }
                WSSec.checkDefaultSecureParts(true, securityProperties);
                continue;
            }
            if (!WSSConstants.ENCRYPTION_WITH_KERBEROS_TOKEN.equals((Object)action)) continue;
            if (securityProperties.getCallbackHandler() == null) {
                throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
            }
            if (securityProperties.getEncryptionSymAlgorithm() == null) {
                securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            }
            if (securityProperties.getSignatureKeyIdentifiers().isEmpty()) {
                securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KEYIDENTIFIER_SECURITY_TOKEN_DIRECT_REFERENCE);
            }
            WSSec.checkDefaultSecureParts(false, securityProperties);
        }
        return new WSSSecurityProperties(securityProperties);
    }

    private static void checkOutboundSignatureProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        if (!"http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(securityProperties.getSignatureAlgorithm())) {
            if (securityProperties.getSignatureKeyStore() == null && securityProperties.getSignatureCryptoProperties() == null && securityProperties.getSignatureCrypto() == null) {
                throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "signatureKeyStoreNotSet");
            }
            if (securityProperties.getSignatureUser() == null) {
                throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noSignatureUser");
            }
            if (securityProperties.getCallbackHandler() == null) {
                throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
            }
        }
        if (securityProperties.getSignatureAlgorithm() == null) {
            securityProperties.setSignatureAlgorithm(WSSec.getRsaSignatureAlgorithm());
        }
        if (securityProperties.getSignatureDigestAlgorithm() == null) {
            securityProperties.setSignatureDigestAlgorithm(WSSec.getSignatureDigestAlgorithm());
        }
        if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
            securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        if (securityProperties.getSignatureKeyIdentifiers().isEmpty()) {
            securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_IssuerSerial);
        }
        WSSec.checkDefaultSecureParts(true, securityProperties);
    }

    private static void checkOutboundSignatureDerivedProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        if (securityProperties.getCallbackHandler() == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
        }
        if (securityProperties.getSignatureAlgorithm() == null) {
            securityProperties.setSignatureAlgorithm(WSSec.getHmacSignatureAlgorithm());
        }
        if (securityProperties.getSignatureDigestAlgorithm() == null) {
            securityProperties.setSignatureDigestAlgorithm(WSSec.getSignatureDigestAlgorithm());
        }
        if (securityProperties.getSignatureCanonicalizationAlgorithm() == null) {
            securityProperties.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        if (securityProperties.getSignatureKeyIdentifiers().isEmpty()) {
            securityProperties.setSignatureKeyIdentifier(WSSecurityTokenConstants.KEYIDENTIFIER_SECURITY_TOKEN_DIRECT_REFERENCE);
        }
        if (securityProperties.getEncryptionSymAlgorithm() == null) {
            securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        }
        if (securityProperties.getEncryptionKeyTransportAlgorithm() == null) {
            securityProperties.setEncryptionKeyTransportAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        }
        if (securityProperties.getEncryptionKeyIdentifier() == null) {
            securityProperties.setEncryptionKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
        }
        if (securityProperties.getDerivedKeyKeyIdentifier() == null) {
            securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
        }
        if (securityProperties.getDerivedKeyTokenReference() == null) {
            securityProperties.setDerivedKeyTokenReference(WSSConstants.DerivedKeyTokenReference.DirectReference);
        }
        if (securityProperties.getDerivedKeyTokenReference() != WSSConstants.DerivedKeyTokenReference.DirectReference) {
            securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KEYIDENTIFIER_SECURITY_TOKEN_DIRECT_REFERENCE);
        }
        WSSec.checkDefaultSecureParts(true, securityProperties);
    }

    private static void checkOutboundEncryptionProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        if (securityProperties.getEncryptionUseThisCertificate() == null && securityProperties.getEncryptionKeyStore() == null && securityProperties.getEncryptionCryptoProperties() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncryptionKey() && securityProperties.getEncryptionCrypto() == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "encryptionKeyStoreNotSet");
        }
        if (securityProperties.getEncryptionUser() == null && securityProperties.getEncryptionUseThisCertificate() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncryptionKey()) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noEncryptionUser");
        }
        if (securityProperties.getEncryptionSymAlgorithm() == null) {
            securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        }
        if (securityProperties.getEncryptionKeyTransportAlgorithm() == null) {
            securityProperties.setEncryptionKeyTransportAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        }
        if (securityProperties.getEncryptionKeyIdentifier() == null) {
            securityProperties.setEncryptionKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_IssuerSerial);
        }
        WSSec.checkDefaultSecureParts(false, securityProperties);
    }

    private static void checkOutboundEncryptionDerivedProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        if (securityProperties.getCallbackHandler() == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
        }
        if (securityProperties.getEncryptionUseThisCertificate() == null && securityProperties.getEncryptionKeyStore() == null && securityProperties.getEncryptionCryptoProperties() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncryptionKey() && securityProperties.getEncryptionCrypto() == null) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "encryptionKeyStoreNotSet");
        }
        if (securityProperties.getEncryptionUser() == null && securityProperties.getEncryptionUseThisCertificate() == null && !securityProperties.isUseReqSigCertForEncryption() && securityProperties.isEncryptSymmetricEncryptionKey()) {
            throw new WSSConfigurationException(WSSecurityException.ErrorCode.FAILURE, "noEncryptionUser");
        }
        if (securityProperties.getEncryptionSymAlgorithm() == null) {
            securityProperties.setEncryptionSymAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        }
        if (securityProperties.getEncryptionKeyTransportAlgorithm() == null) {
            securityProperties.setEncryptionKeyTransportAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        }
        if (securityProperties.getEncryptionKeyIdentifier() == null) {
            securityProperties.setEncryptionKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
        }
        if (securityProperties.getDerivedKeyKeyIdentifier() == null) {
            securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KeyIdentifier_X509KeyIdentifier);
        }
        if (securityProperties.getDerivedKeyTokenReference() == null) {
            securityProperties.setDerivedKeyTokenReference(WSSConstants.DerivedKeyTokenReference.EncryptedKey);
        }
        if (securityProperties.getDerivedKeyTokenReference() != WSSConstants.DerivedKeyTokenReference.DirectReference) {
            securityProperties.setDerivedKeyKeyIdentifier(WSSecurityTokenConstants.KEYIDENTIFIER_SECURITY_TOKEN_DIRECT_REFERENCE);
        }
        WSSec.checkDefaultSecureParts(false, securityProperties);
    }

    private static void checkDefaultSecureParts(boolean signature, WSSSecurityProperties securityProperties) {
        if (signature) {
            List signatureParts = securityProperties.getSignatureSecureParts();
            if (signatureParts.isEmpty()) {
                SecurePart securePart = new SecurePart(new QName("http://www.w3.org/2003/05/soap-envelope", "Body"), SecurePart.Modifier.Element);
                signatureParts.add(securePart);
            }
        } else {
            List encryptionParts = securityProperties.getEncryptionSecureParts();
            if (encryptionParts.isEmpty()) {
                SecurePart securePart = new SecurePart(new QName("http://www.w3.org/2003/05/soap-envelope", "Body"), SecurePart.Modifier.Content);
                encryptionParts.add(securePart);
            }
        }
    }

    public static WSSSecurityProperties validateAndApplyDefaultsToInboundSecurityProperties(WSSSecurityProperties securityProperties) throws WSSConfigurationException {
        return new WSSSecurityProperties(securityProperties);
    }

    public static Schema loadWSSecuritySchemas() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        schemaFactory.setResourceResolver(new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                if ("http://www.w3.org/2001/XMLSchema.dtd".equals(systemId)) {
                    ConcreteLSInput concreteLSInput = new ConcreteLSInput();
                    concreteLSInput.setByteStream(ClassLoaderUtils.getResourceAsStream((String)"schemas/XMLSchema.dtd", WSSec.class));
                    return concreteLSInput;
                }
                if ("XMLSchema.dtd".equals(systemId)) {
                    ConcreteLSInput concreteLSInput = new ConcreteLSInput();
                    concreteLSInput.setByteStream(ClassLoaderUtils.getResourceAsStream((String)"schemas/XMLSchema.dtd", WSSec.class));
                    return concreteLSInput;
                }
                if ("datatypes.dtd".equals(systemId)) {
                    ConcreteLSInput concreteLSInput = new ConcreteLSInput();
                    concreteLSInput.setByteStream(ClassLoaderUtils.getResourceAsStream((String)"schemas/datatypes.dtd", WSSec.class));
                    return concreteLSInput;
                }
                if ("http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd".equals(systemId)) {
                    ConcreteLSInput concreteLSInput = new ConcreteLSInput();
                    concreteLSInput.setByteStream(ClassLoaderUtils.getResourceAsStream((String)"schemas/xmldsig-core-schema.xsd", WSSec.class));
                    return concreteLSInput;
                }
                if ("http://www.w3.org/2001/xml.xsd".equals(systemId)) {
                    ConcreteLSInput concreteLSInput = new ConcreteLSInput();
                    concreteLSInput.setByteStream(ClassLoaderUtils.getResourceAsStream((String)"schemas/xml.xsd", WSSec.class));
                    return concreteLSInput;
                }
                return null;
            }
        });
        Schema schema = schemaFactory.newSchema(new Source[]{new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/xml.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/soap-1.1.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/soap-1.2.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/exc-c14n.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/xmldsig-core-schema.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/xop-include.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/xenc-schema.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/xenc-schema-11.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/xmldsig11-schema.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/oasis-200401-wss-wssecurity-utility-1.0.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/oasis-200401-wss-wssecurity-secext-1.0.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/oasis-wss-wssecurity-secext-1.1.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/ws-secureconversation-200502.xsd", WSSec.class)), new StreamSource(ClassLoaderUtils.getResourceAsStream((String)"schemas/ws-secureconversation-1.3.xsd", WSSec.class))});
        return schema;
    }

    private static String getRsaSignatureAlgorithm() {
        return CryptoUtils.isFips140_3EnabledWithBetaGuard() ? "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512" : "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }

    private static String getHmacSignatureAlgorithm() {
        return CryptoUtils.isFips140_3EnabledWithBetaGuard() ? "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512" : "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    }

    private static String getSignatureDigestAlgorithm() {
        return CryptoUtils.isFips140_3EnabledWithBetaGuard() ? WSSConstants.NS_XENC_SHA512 : WSSConstants.NS_XMLDSIG_SHA1;
    }

    static {
        block12: {
            LOG = LoggerFactory.getLogger(WSSec.class);
            WSProviderConfig.init();
            ClassLoader cl = null;
            try {
                Init.init((URI)ClassLoaderUtils.getResource((String)"wss/wss-config.xml", WSSec.class).toURI(), WSSec.class);
                WSSConstants.setJaxbContext((JAXBContext)JAXBContext.newInstance((Class[])new Class[]{org.apache.wss4j.binding.wss10.ObjectFactory.class, org.apache.wss4j.binding.wss11.ObjectFactory.class, org.apache.wss4j.binding.wsu10.ObjectFactory.class, org.apache.wss4j.binding.wssc13.ObjectFactory.class, org.apache.wss4j.binding.wssc200502.ObjectFactory.class, org.apache.xml.security.binding.xmlenc.ObjectFactory.class, org.apache.xml.security.binding.xmlenc11.ObjectFactory.class, ObjectFactory.class, org.apache.xml.security.binding.xmldsig11.ObjectFactory.class, org.apache.xml.security.binding.excc14n.ObjectFactory.class, org.apache.xml.security.binding.xop.ObjectFactory.class}));
                Schema schema = WSSec.loadWSSecuritySchemas();
                WSSConstants.setJaxbSchemas((Schema)schema);
            }
            catch (URISyntaxException | JAXBException | XMLSecurityException | SAXException e) {
                ClassLoader jaxbimplcl = null;
                try {
                    jaxbimplcl = JAXBContextFactory.class.getClassLoader();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (jaxbimplcl == null) break block12;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("setting up the glassfish classes loader!");
                }
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(jaxbimplcl);
                try {
                    Init.init((URI)ClassLoaderUtils.getResource((String)"wss/wss-config.xml", WSSec.class).toURI(), WSSec.class);
                    WSSConstants.setJaxbContext((JAXBContext)JAXBContext.newInstance((Class[])new Class[]{org.apache.wss4j.binding.wss10.ObjectFactory.class, org.apache.wss4j.binding.wss11.ObjectFactory.class, org.apache.wss4j.binding.wsu10.ObjectFactory.class, org.apache.wss4j.binding.wssc13.ObjectFactory.class, org.apache.wss4j.binding.wssc200502.ObjectFactory.class, org.apache.xml.security.binding.xmlenc.ObjectFactory.class, org.apache.xml.security.binding.xmlenc11.ObjectFactory.class, ObjectFactory.class, org.apache.xml.security.binding.xmldsig11.ObjectFactory.class, org.apache.xml.security.binding.excc14n.ObjectFactory.class, org.apache.xml.security.binding.xop.ObjectFactory.class}));
                    Schema schema = WSSec.loadWSSecuritySchemas();
                    WSSConstants.setJaxbSchemas((Schema)schema);
                }
                catch (URISyntaxException | JAXBException | XMLSecurityException | SAXException e2) {
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                finally {
                    if (cl != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("setting back the original class loader!");
                        }
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
            }
        }
    }
}

