/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor.computed;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics.internal.monitor.computed.ComputedMappingTable;
import io.openliberty.microprofile.metrics.internal.monitor.computed.ComputedMonitorGauge;
import io.openliberty.microprofile.metrics.internal.monitor.computed.ComputedMonitorMetrics;
import io.openliberty.microprofile.metrics.internal.monitor.computed.EWMA;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ComputedMonitorMetricsHandler {
    private static final TraceComponent tc = Tr.register(ComputedMonitorMetricsHandler.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    public static final long COMPUTED_METRICS_TIMER_INTERVAL = 15000L;
    public static final long EWMA_MOVING_WINDOW_INTERVAL = 5L;
    public static final String DURATION = "DURATION";
    public static final String TOTAL = "TOTAL";
    public static final String GAUGE = MetricType.GAUGE.toString().toUpperCase();
    public static final double MILLISECOND_CONVERSION = 0.001;
    public static final double NANOSECOND_CONVERSION = 1.0E-9;
    public static final double MINUTE_CONVERSION = 60.0;
    public static Map<MetricID, Set<ComputedMonitorMetrics>> computationMetricsMap;
    public static Map<MetricID, Object> finalComputedMetricsMap;
    private Timer computeMetricsTimer = new Timer(true);
    private ComputedMappingTable mappingTable;
    protected SharedMetricRegistries sharedMetricRegistry;
    static final long serialVersionUID = 453575814021989680L;

    public ComputedMonitorMetricsHandler(SharedMetricRegistries sharedMetricRegistry) {
        this.sharedMetricRegistry = sharedMetricRegistry;
        this.mappingTable = ComputedMappingTable.getInstance();
        computationMetricsMap = new ConcurrentHashMap<MetricID, Set<ComputedMonitorMetrics>>();
        finalComputedMetricsMap = new ConcurrentHashMap<MetricID, Object>();
        this.createComputedBaseMetrics();
        ComputeMetricsTimerTask cmtt = new ComputeMetricsTimerTask();
        this.computeMetricsTimer.schedule((TimerTask)cmtt, 0L, 15000L);
    }

    public void createComputedBaseMetrics() {
        MetricRegistry metricRegistry;
        block5: {
            block7: {
                block6: {
                    metricRegistry = this.getMetricRegistry(MetricRegistry.Type.BASE.getName());
                    if (metricRegistry != null) break block5;
                    if (tc.isDebugEnabled()) break block6;
                    if (!tc.isAnyTracingEnabled()) break block7;
                }
                Tr.debug((TraceComponent)tc, (String)"MetricRegistry obtained from SharedMetricRegistries was null. No metrics will be registered.", (Object[])new Object[0]);
            }
            return;
        }
        SortedSet baseMetricsIDSet = metricRegistry.getMetricIDs();
        List<String> baseMetricGroupList = this.mappingTable.getMetricGroupsList("base");
        for (String baseMetricGroup : baseMetricGroupList) {
            String[][] data;
            for (String[] metricData : data = this.mappingTable.getData(baseMetricGroup)) {
                String metricDurationName = metricData[6];
                String metricTotalCountName = metricData[8];
                String metricDurationUnit = metricData[7];
                String metricTotalUnit = metricData[9];
                for (MetricID mid : baseMetricsIDSet) {
                    ComputedMonitorMetrics cmm = null;
                    Tag[] metricTagNames = null;
                    HashSet<ComputedMonitorMetrics> computedMonitorMetricsSet = new HashSet<ComputedMonitorMetrics>();
                    String baseMetricName = mid.getName();
                    if (!baseMetricName.equals(metricDurationName)) continue;
                    metricTagNames = this.getComputedMetricsTags(mid);
                    MetricID durationMetricID = new MetricID(metricDurationName, metricTagNames);
                    cmm = new ComputedMonitorMetrics(MetricRegistry.Type.BASE.getName(), durationMetricID, DURATION, metricDurationUnit);
                    computedMonitorMetricsSet.add(cmm);
                    MetricID totalCountMetricID = new MetricID(metricTotalCountName, metricTagNames);
                    cmm = new ComputedMonitorMetrics(MetricRegistry.Type.BASE.getName(), totalCountMetricID, TOTAL, metricTotalUnit);
                    computedMonitorMetricsSet.add(cmm);
                    MetricID computedMetricID = this.registerNewComputedMetricWithExistingMetricTag(metricData, metricTagNames);
                    computationMetricsMap.put(computedMetricID, computedMonitorMetricsSet);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Created computed metric for base computation : " + computedMetricID.toString()), (Object[])new Object[0]);
                }
            }
        }
    }

    public void createComputedMetrics(String objectName, Set<MetricID> monitorMetricsIDSet, String appName, String mpAppNameConfigValue) {
        String[][] data;
        for (String[] metricData : data = this.mappingTable.getData(objectName)) {
            Tag[] computedMetricTagNames = null;
            HashSet<ComputedMonitorMetrics> computedMonitorMetricsSet = new HashSet<ComputedMonitorMetrics>();
            for (MetricID mID : monitorMetricsIDSet) {
                ComputedMonitorMetrics cmm = null;
                String metricDurationName = metricData[6];
                String metricTotalCountName = metricData[8];
                String metricDurationUnit = metricData[7];
                String metricTotalUnit = metricData[9];
                String metricName = mID.getName();
                if (objectName.contains("REST_Stats")) {
                    computedMetricTagNames = this.getComputedMetricsTags(mID);
                    cmm = new ComputedMonitorMetrics(MetricRegistry.Type.BASE.getName(), mID, DURATION, metricDurationUnit, appName, mpAppNameConfigValue);
                    computedMonitorMetricsSet.add(cmm);
                    cmm = new ComputedMonitorMetrics(MetricRegistry.Type.BASE.getName(), mID, TOTAL, metricTotalUnit, appName, mpAppNameConfigValue);
                    computedMonitorMetricsSet.add(cmm);
                    continue;
                }
                if (metricDurationName.equals(metricName)) {
                    computedMetricTagNames = this.getComputedMetricsTags(mID);
                    cmm = new ComputedMonitorMetrics(MetricRegistry.Type.VENDOR.getName(), mID, DURATION, metricDurationUnit);
                } else if (metricTotalCountName.equals(metricName)) {
                    cmm = new ComputedMonitorMetrics(MetricRegistry.Type.VENDOR.getName(), mID, TOTAL, metricTotalUnit);
                }
                if (cmm == null) continue;
                computedMonitorMetricsSet.add(cmm);
            }
            MetricID computedMetricID = this.registerNewComputedMetricWithExistingMetricTag(metricData, computedMetricTagNames);
            computationMetricsMap.put(computedMetricID, computedMonitorMetricsSet);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Created computed metric for vendor computation :  " + computedMetricID.toString()), (Object[])new Object[0]);
        }
    }

    private Tag[] getComputedMetricsTags(MetricID metricId) {
        Map metricTagMap = metricId.getTags();
        Tag[] metricsTagsArr = null;
        if (metricTagMap.containsKey("_app")) {
            HashMap tempTagMaps = new HashMap(metricTagMap);
            tempTagMaps.remove("_app");
            ArrayList<Tag> metricsTagList = new ArrayList<Tag>();
            for (Map.Entry entry : tempTagMaps.entrySet()) {
                metricsTagList.add(new Tag((String)entry.getKey(), (String)entry.getValue()));
            }
            metricsTagsArr = metricsTagList.toArray(new Tag[metricsTagList.size()]);
        } else {
            metricsTagsArr = metricId.getTagsAsArray();
        }
        return metricsTagsArr;
    }

    public MetricID registerNewComputedMetricWithExistingMetricTag(String[] metricData, Tag[] existingMetricTags) {
        MetricRegistry metricRegistry = this.getMetricRegistry(MetricRegistry.Type.VENDOR.getName());
        String computedMetricName = metricData[0];
        String computedMetricDisplayName = metricData[1];
        MetricType metricType = MetricType.valueOf((String)metricData[3]);
        MetricID computedMetricID = new MetricID(computedMetricName, existingMetricTags);
        String description = Tr.formatMessage((TraceComponent)tc, (String)metricData[2], (Object[])new Object[0]);
        String unit = metricData[4];
        Metadata metadata = Metadata.builder().withName(computedMetricName).withDisplayName(computedMetricDisplayName).withDescription(description).withUnit(unit).build();
        if (MetricType.GAUGE.equals((Object)metricType)) {
            ComputedMonitorGauge cmg = new ComputedMonitorGauge(this, computedMetricID);
            if (existingMetricTags == null) {
                metricRegistry.gauge(metadata, cmg, x -> ((Number)x.getValue()).doubleValue(), new Tag[0]);
            } else {
                metricRegistry.gauge(metadata, cmg, x -> ((Number)x.getValue()).doubleValue(), existingMetricTags);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Registered " + computedMetricID.toString() + " in the Metric Registry."), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Failed to register " + computedMetricName + " because of invalid type " + metricType), (Object[])new Object[0]);
        }
        return computedMetricID;
    }

    public void unregisterAllComputedMetrics() {
        MetricRegistry baseRegistry = this.getMetricRegistry(MetricRegistry.Type.VENDOR.getName());
        for (MetricID metricIDToRemove : computationMetricsMap.keySet()) {
            boolean rc = baseRegistry.remove(metricIDToRemove);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Unregistered computed metric : " + metricIDToRemove.toString() + " " + (rc ? "successfully" : "unsuccessfully")), (Object[])new Object[0]);
        }
        computationMetricsMap.clear();
        finalComputedMetricsMap.clear();
    }

    public void unregister(Set<MetricID> monitorMetricsIDSet, String mpAppName) {
        MetricID computedMetricID = null;
        for (MetricID mID : monitorMetricsIDSet) {
            computedMetricID = this.getComputedMetricIDToRemove(mID);
            if (computedMetricID == null) continue;
            this.removeComputedMetrics(computedMetricID, mpAppName);
        }
    }

    public void unregisterComputedRESTMetricsByAppName(String appName) {
        block0: for (Map.Entry<MetricID, Set<ComputedMonitorMetrics>> entry : computationMetricsMap.entrySet()) {
            MetricID computedMetricID = entry.getKey();
            for (ComputedMonitorMetrics cmm : entry.getValue()) {
                String restAppName = cmm.getAppName();
                String mpAppNameConfigValue = cmm.getMpAppNameConfigValue();
                if (restAppName == null || !restAppName.equals(appName)) continue;
                this.removeComputedMetrics(computedMetricID, mpAppNameConfigValue);
                continue block0;
            }
        }
    }

    public void removeComputedMetrics(MetricID computedMetricID, String mpAppName) {
        computationMetricsMap.remove(computedMetricID);
        finalComputedMetricsMap.remove(computedMetricID);
        if (mpAppName != null && !mpAppName.isEmpty()) {
            computedMetricID = this.mergeMPAppTag(computedMetricID, mpAppName);
        }
        MetricRegistry vendorRegistry = this.getMetricRegistry(MetricRegistry.Type.VENDOR.getName());
        boolean rc = vendorRegistry.remove(computedMetricID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unregistered computed vendor metric : " + computedMetricID.toString() + " " + (rc ? "successfully" : "unsuccessfully")), (Object[])new Object[0]);
        }
    }

    private MetricID getComputedMetricIDToRemove(MetricID monitorMetricID) {
        for (Map.Entry<MetricID, Set<ComputedMonitorMetrics>> entry : computationMetricsMap.entrySet()) {
            MetricID computedMetricID = entry.getKey();
            Set<ComputedMonitorMetrics> monitorMetricSet = entry.getValue();
            for (ComputedMonitorMetrics cmm : monitorMetricSet) {
                if (!cmm.getMonitorMetricID().equals((Object)monitorMetricID)) continue;
                return computedMetricID;
            }
        }
        return null;
    }

    private MetricID mergeMPAppTag(MetricID mid, String appNameValue) {
        Tag appTag = new Tag("_app", appNameValue);
        Tag[] tempArr = Arrays.copyOf(mid.getTagsAsArray(), mid.getTagsAsArray().length + 1);
        tempArr[tempArr.length - 1] = appTag;
        return new MetricID(mid.getName(), tempArr);
    }

    public Double getComputedValue(MetricID metricId) {
        Double computedValue = 0.0;
        Object computedObject = finalComputedMetricsMap.get(metricId);
        if (computedObject == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"computedObject is null - computing metric values...", (Object[])new Object[0]);
            }
            this.calculateMetricValue();
            computedObject = finalComputedMetricsMap.get(metricId);
        }
        if (computedObject != null) {
            if (computedObject instanceof Double) {
                computedValue = (double)((Double)computedObject);
            } else if (computedObject instanceof EWMA) {
                computedValue = ((EWMA)computedObject).getAveragedValue();
            }
        }
        return computedValue;
    }

    public void calculateMetricValue() {
        for (Map.Entry<MetricID, Set<ComputedMonitorMetrics>> entry : computationMetricsMap.entrySet()) {
            String computedMetricName;
            Double metricVal = null;
            Double diffDuration = null;
            Double diffTotalCount = null;
            MetricID computedMetricID = entry.getKey();
            Set<ComputedMonitorMetrics> monitorMetrics = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Calculating metric value for computed metric : " + computedMetricID.toString()), (Object[])new Object[0]);
            }
            if ((computedMetricName = computedMetricID.getName()).equals("memory.heapUtilization")) {
                this.calculateHeapUsage(computedMetricID, monitorMetrics);
                continue;
            }
            if (computedMetricName.equals("cpu.processCpuUtilization")) {
                this.calculateProcessCpuUsage(computedMetricID);
                continue;
            }
            for (ComputedMonitorMetrics cmm : monitorMetrics) {
                MetricRegistry mr = this.getMetricRegistry(cmm.getMonitorMetricScope());
                metricVal = this.getMetricValue(mr, cmm);
                if (metricVal == null) continue;
                if (cmm.getComputationType().equals(DURATION)) {
                    diffDuration = cmm.getDifference(metricVal);
                    continue;
                }
                if (!cmm.getComputationType().equals(TOTAL)) continue;
                diffTotalCount = cmm.getDifference(metricVal);
            }
            if (diffDuration == null || diffTotalCount == null) continue;
            this.calculateEWMAValue(computedMetricID, diffDuration, diffTotalCount);
        }
    }

    public void calculateHeapUsage(MetricID computedMetricID, Set<ComputedMonitorMetrics> monitorMetrics) {
        double usedHeap = 0.0;
        double maxHeap = 0.0;
        double heapUsage = 0.0;
        MetricRegistry mr = this.getMetricRegistry(MetricRegistry.Type.BASE.getName());
        for (ComputedMonitorMetrics cmm : monitorMetrics) {
            MetricID metricId = cmm.getMonitorMetricID();
            Gauge currentGauge = mr.getGauge(metricId);
            double currentValue = ((Number)currentGauge.getValue()).doubleValue();
            if (metricId.getName().equals("memory.usedHeap")) {
                usedHeap = currentValue;
                continue;
            }
            if (!metricId.getName().equals("memory.maxHeap")) continue;
            maxHeap = currentValue;
        }
        double d = heapUsage = maxHeap == -1.0 ? -1.0 : usedHeap / maxHeap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Computed Heap Usage, usedHeap = " + usedHeap + " maxHeap = " + maxHeap + " heapUsage = " + heapUsage), (Object[])new Object[0]);
        }
        finalComputedMetricsMap.put(computedMetricID, usedHeap / maxHeap);
    }

    public void calculateProcessCpuUsage(MetricID computedMetricID) {
        double processCpuUsageInPercent = 0.0;
        double processCpuUsage = 0.0;
        processCpuUsageInPercent = CpuInfo.getJavaCpuUsage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ProcessCpu Usage from CpuInfo.getJavaCpuUsage() in percentage, processCpuUsage = " + processCpuUsageInPercent), (Object[])new Object[0]);
        }
        processCpuUsage = processCpuUsageInPercent / 100.0;
        finalComputedMetricsMap.put(computedMetricID, processCpuUsage);
    }

    public Double getMetricValue(MetricRegistry mr, ComputedMonitorMetrics cmm) {
        Number metricNum = null;
        Double currentValue = null;
        Metric metricValue = mr.getMetric(cmm.getMonitorMetricID());
        if (metricValue instanceof Gauge) {
            Gauge currentGauge = (Gauge)metricValue;
            metricNum = (Number)currentGauge.getValue();
        } else if (metricValue instanceof Counter) {
            Counter currentCount = (Counter)metricValue;
            metricNum = currentCount.getCount();
        } else if (metricValue instanceof SimpleTimer) {
            SimpleTimer currentTimer = (SimpleTimer)metricValue;
            if (cmm.getComputationType().equals(DURATION)) {
                Duration currentDur = currentTimer.getElapsedTime();
                if (currentDur != null) {
                    double tempDurNanos = currentDur.toNanos();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("REST Timer ElapsedTime Duration in nanoseconds = " + tempDurNanos), (Object[])new Object[0]);
                    }
                    currentValue = tempDurNanos * 1.0E-9;
                }
            } else {
                metricNum = currentTimer.getCount();
            }
        }
        if (metricNum != null && currentValue == null) {
            if (cmm.getComputationType().equals(DURATION)) {
                double unitConversionFactor = this.getUnitConversionFactor(cmm.getMetricUnit());
                currentValue = metricNum.doubleValue() * unitConversionFactor;
            } else {
                currentValue = metricNum.doubleValue();
            }
        }
        return currentValue;
    }

    private double getUnitConversionFactor(String metricUnit) {
        double convFactor = 1.0;
        if (metricUnit.equals("nanoseconds")) {
            convFactor = 1.0E-9;
        } else if (metricUnit.equals("milliseconds")) {
            convFactor = 0.001;
        }
        return convFactor;
    }

    public MetricRegistry getMetricRegistry(String scope) {
        MetricRegistry metricRegistry = this.sharedMetricRegistry.getOrCreate(scope);
        return metricRegistry;
    }

    public void calculateEWMAValue(MetricID computedMetricID, double duration, double totalCount) {
        String computedMetricName;
        double computedVal = 0.0;
        double d = computedVal = duration < 0.0 || totalCount < 0.0 ? -1.0 : duration / totalCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The computed value is " + computedVal), (Object[])new Object[0]);
        }
        if ((computedMetricName = computedMetricID.getName()).equals("gc.time.per.cycle") && computedVal == -1.0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The GC Time was unknown to the JVM, hence updating map for GCTime computed metric to -1.", (Object[])new Object[0]);
            }
            finalComputedMetricsMap.put(computedMetricID, computedVal);
        } else {
            EWMA ewmaObj = (EWMA)finalComputedMetricsMap.get(computedMetricID);
            if (ewmaObj == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"First initialization of the computed metric, creating EWMA object.", (Object[])new Object[0]);
                }
                double alpha = this.calculateAlpha(5.0);
                ewmaObj = new EWMA(alpha);
                double initialValue = duration == 0.0 || totalCount == 0.0 ? 0.0 : computedVal;
                ewmaObj.updateNewValue(initialValue);
            } else if (duration == 0.0 || totalCount == 0.0 || computedVal < 0.0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Idling - There were no new data in the sampling period, getting the previously calculated EWMA value to feed into it again.", (Object[])new Object[0]);
                }
                ewmaObj.updateNewValue(ewmaObj.getAveragedValue());
            } else {
                ewmaObj.updateNewValue(computedVal);
            }
            finalComputedMetricsMap.put(computedMetricID, ewmaObj);
        }
    }

    private double calculateAlpha(double movingWindowInMins) {
        double movingWindowInSecs = movingWindowInMins * 60.0;
        double numOfDataSamplesInMovingWindow = movingWindowInSecs / 15.0;
        double alpha = 2.0 / (numOfDataSamplesInMovingWindow + 1.0);
        return alpha;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class ComputeMetricsTimerTask
    extends TimerTask {
        static final long serialVersionUID = 1198354292794014927L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public void run() {
            ComputedMonitorMetricsHandler.this.calculateMetricValue();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.monitor.computed.ComputedMonitorMetricsHandler$ComputeMetricsTimerTask", ComputeMetricsTimerTask.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
        }
    }
}

