/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public abstract class ControllableStream
implements Stream {
    private static final TraceComponent tc = SibTr.register(ControllableStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final String ID_SEPERATOR = ":";

    @Override
    public synchronized List<Long> getTicksOnStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTicksOnStream");
        }
        ArrayList<Long> msgs = new ArrayList<Long>();
        StateStream stateStream = this.getStateStream();
        stateStream.setCursor(0L);
        stateStream.getNext();
        TickRange tr = stateStream.getNext();
        while (tr.endstamp < Long.MAX_VALUE) {
            if (tr.type != 7) {
                msgs.add(new Long(tr.startstamp));
            }
            tr = stateStream.getNext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTicksOnStream", msgs);
        }
        return msgs;
    }

    @Override
    public synchronized TickRange getTickRange(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTickRange");
        }
        TickRange range = null;
        StateStream stateStream = this.getStateStream();
        stateStream.setCursor(tick);
        range = (TickRange)stateStream.getNext().clone();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTickRange", (Object)range);
        }
        return range;
    }

    @Override
    public abstract long getCompletedPrefix();

    @Override
    public abstract StateStream getStateStream();

    @Override
    public abstract void writeSilenceForced(long var1) throws SIException;

    @Override
    public String getID() {
        String id = "" + this.getReliability() + ID_SEPERATOR + this.getPriority() + ID_SEPERATOR;
        return id;
    }

    protected abstract Reliability getReliability();

    protected abstract int getPriority();
}

