/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Literal;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.SelectorImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public final class LiteralImpl
extends SelectorImpl
implements Literal {
    public Object value;

    static int objectType(Object value) {
        if (value instanceof String) {
            return -5;
        }
        if (value instanceof Boolean) {
            return -6;
        }
        if (value instanceof Number) {
            return EvaluatorImpl.getType((Number)value) + -4;
        }
        if (value instanceof Serializable) {
            return -7;
        }
        return 2;
    }

    public LiteralImpl(Object value) {
        this.value = value;
        this.type = LiteralImpl.objectType(value);
    }

    public LiteralImpl(ObjectInput handle) throws ClassNotFoundException, IOException {
        this.type = handle.readByte();
        switch (this.type) {
            case -2: {
                this.value = new Float(handle.readFloat());
                return;
            }
            case -1: {
                this.value = new Double(handle.readDouble());
                return;
            }
            case -4: {
                this.value = new Integer(handle.readInt());
                return;
            }
            case -3: {
                this.value = new Long(handle.readLong());
                return;
            }
            case -5: {
                this.value = handle.readUTF();
                return;
            }
            case -6: {
                this.value = handle.readBoolean();
                return;
            }
            case -7: {
                this.value = handle.readObject();
            }
        }
        this.type = 2;
    }

    public void encodeSelf(ObjectOutput buf) throws IOException {
        buf.writeByte((byte)this.type);
        switch (this.type) {
            case -5: {
                buf.writeUTF((String)this.value);
                return;
            }
            case -3: {
                buf.writeLong((Long)this.value);
                return;
            }
            case -1: {
                buf.writeDouble((Double)this.value);
                return;
            }
            case -4: {
                buf.writeInt((Integer)this.value);
                return;
            }
            case -2: {
                buf.writeFloat(((Float)this.value).floatValue());
                return;
            }
            case -6: {
                buf.writeBoolean((Boolean)this.value);
                return;
            }
            case -7: {
                buf.writeObject(this.value);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Literal && super.equals(o)) {
            return ((Literal)o).getValue().equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        if (this.type == -5) {
            return "'" + this.value + "'";
        }
        return this.value.toString();
    }

    public Object getValue() {
        return this.value;
    }
}

