/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.token.impl;

import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.token.impl.OAuth20AccessToken;
import java.util.Map;

public class OAuth20AccessTokenBearerImpl
extends OAuth20AccessToken {
    private static final String TOKEN_TYPE = "Bearer";
    private static final boolean IS_PERSISTENT = true;
    private String _clientId = null;
    private String _username = null;
    private String _redirectUri = null;
    private String[] _scope = null;

    public OAuth20AccessTokenBearerImpl(String id, String componentId, String clientId, String username, String redirectUri, String stateId, String[] scope, int lifetimeSeconds, Map<String, String[]> extensionProperties, String grantType) {
        super(id, componentId, TOKEN_TYPE, stateId, lifetimeSeconds, true, extensionProperties, grantType);
        this.init(clientId, username, redirectUri, scope);
    }

    private void init(String clientId, String username, String redirectUri, String[] scope) {
        this._clientId = clientId;
        this._username = username;
        this._redirectUri = redirectUri;
        this._scope = scope;
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    public String getTokenString() {
        return this.getId();
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public String getRedirectUri() {
        return this._redirectUri;
    }

    @Override
    public String[] getScope() {
        return this._scope;
    }

    @Override
    public String toString() {
        StringBuffer grant = new StringBuffer(super.toString());
        grant.append("&client_id=" + this._clientId + "&");
        grant.append("username=" + this._username + "&");
        grant.append("redirect_uri=" + this._redirectUri + "&");
        grant.append("scope=" + OAuth20Util.arrayToSpaceString(this._scope));
        return grant.toString();
    }
}

