/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.BaseEncoding;
import jakarta.annotation.Nonnull;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.common.binding.artifact.SAMLSourceIDArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.metadata.resolver.impl.MetadataQueryProtocolRequestURLBuilder;

public class SAMLArtifactURLBuilder
implements MetadataQueryProtocolRequestURLBuilder.MetadataQueryProtocolURLBuilder {
    private static final BaseEncoding HEX = BaseEncoding.base16().lowerCase();

    @Override
    public String buildURL(@Nonnull String baseURL, @Nonnull CriteriaSet criteria) {
        if (!criteria.contains(ArtifactCriterion.class)) {
            return null;
        }
        ArtifactCriterion artifactCriterion = (ArtifactCriterion)criteria.get(ArtifactCriterion.class);
        if (artifactCriterion.getArtifact() instanceof SAMLSourceIDArtifact) {
            return this.buildFromSourceID(baseURL, (SAMLSourceIDArtifact)artifactCriterion.getArtifact());
        }
        return null;
    }

    private String buildFromSourceID(@Nonnull String baseURL, @Nonnull SAMLSourceIDArtifact sourceIDArtifact) {
        return baseURL + "entities/%7Bsha1%7D" + HEX.encode(sourceIDArtifact.getSourceID());
    }
}

