/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.Instant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredValidUntilFilter
implements MetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RequiredValidUntilFilter.class);
    @Nullable
    private Duration maxValidityInterval = Duration.ofDays(14L);

    @Nullable
    public Duration getMaxValidityInterval() {
        return this.maxValidityInterval;
    }

    public void setMaxValidityInterval(@Nullable Duration validity) {
        this.maxValidityInterval = validity != null && !validity.isNegative() && !validity.isZero() ? validity : null;
    }

    @Override
    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        long validityInterval;
        if (metadata == null) {
            return null;
        }
        Instant validUntil = this.getValidUntil(metadata);
        if (validUntil == null) {
            throw new FilterException("Metadata did not include a validUntil attribute");
        }
        Instant now = Instant.now();
        if (this.maxValidityInterval != null && validUntil.isAfter(now) && Duration.ofMillis(validityInterval = validUntil.toEpochMilli() - now.toEpochMilli()).compareTo(this.maxValidityInterval) > 0) {
            throw new FilterException(String.format("Metadata's validity interval %s is larger than is allowed %s", Duration.ofMillis(validityInterval), this.maxValidityInterval));
        }
        return metadata;
    }

    @Nullable
    protected Instant getValidUntil(@Nonnull XMLObject metadata) throws FilterException {
        if (metadata instanceof EntitiesDescriptor) {
            return ((EntitiesDescriptor)metadata).getValidUntil();
        }
        if (metadata instanceof EntityDescriptor) {
            return ((EntityDescriptor)metadata).getValidUntil();
        }
        this.log.error("Metadata root element was not an EntitiesDescriptor or EntityDescriptor it was a {}", (Object)metadata.getElementQName());
        throw new FilterException("Metadata root element was not an EntitiesDescriptor or EntityDescriptor");
    }
}

