/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletRequest;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.AccessControl;
import org.opensaml.profile.context.AccessControlContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateAccessControl
extends AbstractIdentifiableInitializableComponent
implements AccessControl {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PredicateAccessControl.class);
    @Nonnull
    private final Predicate<ProfileRequestContext> predicate;

    public PredicateAccessControl(@Nonnull @ParameterName(name="condition") Predicate<ProfileRequestContext> condition) {
        this.predicate = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    public boolean checkAccess(@Nonnull ServletRequest request, @Nullable String operation, @Nullable String resource) {
        Constraint.isNotNull((Object)request, (String)"ServletRequest cannot be null");
        Object attribute = request.getAttribute("opensamlProfileRequestContext");
        if (attribute != null && attribute instanceof ProfileRequestContext) {
            ProfileRequestContext prc = (ProfileRequestContext)((Object)attribute);
            AccessControlContext acc = (AccessControlContext)prc.getSubcontext(AccessControlContext.class, true);
            acc.setOperation(operation);
            acc.setResource(resource);
            if (this.predicate.test(prc)) {
                prc.removeSubcontext(acc);
                this.log.debug("{} Granted access based on predicate (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), operation, resource});
                return true;
            }
            prc.removeSubcontext(acc);
            this.log.debug("{} Denied request based on predicate (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), operation, resource});
        } else {
            this.log.warn("{} Denied request based on predicate, missing ProfileRequestContext (Operation: {}, Resource: {})", new Object[]{this.getLogPrefix(), operation, resource});
        }
        return false;
    }

    @Nonnull
    private String getLogPrefix() {
        return "Policy " + this.getId() + ":";
    }
}

