/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.srt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.webcontainer.srt.SRTInputStream;
import com.ibm.ws.webcontainer31.util.UpgradeInputByteBufferUtil;
import jakarta.servlet.ReadListener;
import java.io.IOException;

public class SRTUpgradeInputStream31
extends SRTInputStream {
    private static final TraceComponent tc = Tr.register(SRTUpgradeInputStream31.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private boolean closed = false;
    protected UpgradeInputByteBufferUtil _inBuffer;

    public void init(UpgradeInputByteBufferUtil input) {
        this._inBuffer = input;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init upgrade input", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        SRTUpgradeInputStream31 sRTUpgradeInputStream31 = this;
        synchronized (sRTUpgradeInputStream31) {
            int value = 0;
            if (this.closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
                }
                throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
            }
            value = this._inBuffer != null ? this._inBuffer.read() : this.in.read();
            return value;
        }
    }

    public int read(byte[] output) throws IOException {
        return this.read(output, 0, output.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] output, int offset, int length) throws IOException {
        SRTUpgradeInputStream31 sRTUpgradeInputStream31 = this;
        synchronized (sRTUpgradeInputStream31) {
            int value = 0;
            if (this.closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
                }
                throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
            }
            if (output == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]);
                }
                throw new NullPointerException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.bytearray.null", (Object[])new Object[0]));
            }
            if (offset < 0 || length < 0 || length > output.length - offset) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                    Tr.error((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{offset, length, output.length});
                }
                throw new IndexOutOfBoundsException(Tr.formatMessage((TraceComponent)tc, (String)"read.write.offset.length.bytearraylength", (Object[])new Object[]{offset, length, output.length}));
            }
            value = this._inBuffer != null ? this._inBuffer.read(output, offset, length) : this.in.read(output, offset, length);
            return value;
        }
    }

    public boolean isFinished() {
        return this.closed;
    }

    public boolean isReady() {
        if (this.closed) {
            return true;
        }
        return this._inBuffer.isReady();
    }

    public void setReadListener(ReadListener arg0) {
        if (this.closed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]);
            }
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"stream.is.closed.no.read.write", (Object[])new Object[0]));
        }
        this._inBuffer.setupReadListener(arg0, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class})
    public void close() throws IOException {
        SRTUpgradeInputStream31 sRTUpgradeInputStream31 = this;
        synchronized (sRTUpgradeInputStream31) {
            block11: {
                if (this.closed) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Input stream close previously called ...return ", (Object[])new Object[0]);
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling close on the util class", (Object[])new Object[0]);
                }
                this.closed = true;
                if (this._inBuffer.close().booleanValue()) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Timeout has been called, waiting for it to complete, " + this._inBuffer.isClosing()), (Object[])new Object[0]);
                        }
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)"Completed waiting for timeout to be called", (Object[])new Object[0]);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling close on parent", (Object[])new Object[0]);
            }
            super.close();
        }
    }

    public UpgradeInputByteBufferUtil getInputBufferHelper() {
        return this._inBuffer;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        this._inBuffer.readLineCall();
        int readLineReturn = super.readLine(b, off, len);
        this._inBuffer.readLineCall();
        return readLineReturn;
    }
}

