/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.HttpServiceContextImpl;
import com.ibm.ws.http.channel.internal.inbound.HttpICLReadCallback;
import com.ibm.ws.http.channel.internal.inbound.HttpIgnoreBodyCallback;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannel;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.internal.inbound.HttpPipelineEventHandler;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.base.InboundProtocolLink;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.logging.DebugLog;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpInboundLink
extends InboundProtocolLink
implements InterChannelCallback,
ConnectionLink {
    private static final TraceComponent tc = Tr.register(HttpInboundLink.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected HttpInboundServiceContextImpl myInterface = null;
    protected HttpInboundChannel myChannel = null;
    protected TCPConnectionContext myTSC = null;
    protected boolean bPartialParsedRequest = false;
    protected int numRequestsProcessed = 0;
    protected boolean filterExceptions = false;
    protected boolean bIsActive = false;
    protected List<ConnectionReadyCallback> appSides = null;
    private boolean alreadyH2Upgraded = false;
    private boolean isGrpc = false;
    VirtualConnection switchedVC = null;
    static final String CONSTANT_upgrade = new String("upgrade");
    static final String CONSTANT_connection = new String("connection");
    static final String CONSTANT_connection_value = new String("Upgrade, HTTP2-Settings");
    static final String CONSTANT_h2c = new String("h2c");

    public HttpInboundLink(HttpInboundChannel channel, VirtualConnection vc) {
        this.init(vc, channel);
        this.myInterface = new HttpInboundServiceContextImpl(null, this, this.getVirtualConnection(), this.getChannel().getHttpConfig());
    }

    public void init(VirtualConnection inVC, HttpInboundChannel channel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Init on link: " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        super.init(inVC);
        this.myChannel = channel;
        if (null != this.getHTTPContext()) {
            this.getHTTPContext().setHttpConfig(channel.getHttpConfig());
        }
        this.getVirtualConnection().getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, this);
        this.bIsActive = true;
        this.isGrpc = false;
    }

    public VirtualConnection getVirtualConnection() {
        if (this.switchedVC != null) {
            return this.switchedVC;
        }
        return super.getVirtualConnection();
    }

    public void reinit(TCPConnectionContext tcc, VirtualConnection vc, HttpInboundLink wrapper) {
        this.myTSC = tcc;
        this.switchedVC = vc;
        this.getVirtualConnection().getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, this);
        this.myInterface.reinit(tcc, vc, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying inbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()), (Object[])new Object[0]);
        }
        HttpInboundLink httpInboundLink = this;
        synchronized (httpInboundLink) {
            if (!this.bIsActive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignoring destroy on an inactive object", (Object[])new Object[0]);
                }
                return;
            }
            this.bIsActive = false;
        }
        this.getVirtualConnection().getStateMap().remove(CallbackIDs.CALLBACK_HTTPICL);
        if (this.getChannel().getHttpConfig().runningOnZOS()) {
            this.getVirtualConnection().getStateMap().remove("zConfiguredHttpReadBufferSize");
        }
        if (null != this.appSides) {
            super.destroy();
            for (ConnectionReadyCallback appside : this.appSides) {
                appside.destroy(e);
            }
            this.appSides = null;
        } else {
            super.destroy(e);
        }
        this.myInterface.clear();
        this.myInterface.destroy();
        this.myInterface = null;
        this.myTSC = null;
        this.filterExceptions = false;
        this.numRequestsProcessed = 0;
        this.myChannel = null;
    }

    public Object getChannelAccessor() {
        return this.myInterface;
    }

    public HttpInboundServiceContextImpl getHTTPContext() {
        return this.myInterface;
    }

    public HttpInboundChannel getChannel() {
        return this.myChannel;
    }

    protected boolean maxRequestsServed() {
        if (this.getChannel().isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Channel stopped, disabling keep-alive request", (Object[])new Object[0]);
            }
            return true;
        }
        if (!this.getChannel().getHttpConfig().isKeepAliveEnabled()) {
            return true;
        }
        int max = this.getChannel().getHttpConfig().getMaximumPersistentRequests();
        if (0 <= max) {
            return this.numRequestsProcessed >= max;
        }
        return false;
    }

    protected boolean isFirstRequest() {
        return 0 == this.numRequestsProcessed || 1 == this.numRequestsProcessed && this.getHTTPContext().headersParsed();
    }

    protected boolean isPartiallyParsed() {
        return this.bPartialParsedRequest;
    }

    protected void setPartiallyParsed(boolean b) {
        this.bPartialParsedRequest = b;
    }

    public boolean isDirectHttp2Link(VirtualConnection vc) {
        if (this.alreadyH2Upgraded) {
            return true;
        }
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        if (!sc.isH2Connection() && (this.checkAlpnH2() || !sc.isSecure() && sc.isHttp2Enabled()) && this.checkForH2MagicString(sc)) {
            this.alreadyH2Upgraded = true;
            return true;
        }
        return false;
    }

    public final void setIsGrpcInParentLink(boolean x) {
        this.isGrpc = x;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set isGprc: " + this.isGrpc), (Object[])new Object[0]);
        }
    }

    private boolean checkAlpnH2() {
        return this.myTSC.getSSLContext() != null && this.myTSC.getSSLContext().getAlpnProtocol() != null && this.myTSC.getSSLContext().getAlpnProtocol().equals("h2");
    }

    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("ready: " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        this.myTSC = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        sc.init(this.myTSC, this, inVC, this.getChannel().getHttpConfig());
        if (this.getChannel().getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.INFO)) {
            this.getChannel().getHttpConfig().getDebugLog().log(DebugLog.Level.INFO, "Received new connection ", (HttpServiceContext)sc);
        }
        this.processRequest();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ready");
        }
    }

    protected void processRequest() {
        int timeout = this.getHTTPContext().getReadTimeout();
        HttpICLReadCallback callback = HttpICLReadCallback.getRef();
        VirtualConnection rc = null;
        do {
            if (this.handleNewInformation()) {
                return;
            }
            if (this.isPartiallyParsed()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processRequest calling handleNewRequest()", (Object[])new Object[0]);
            }
            this.handleNewRequest();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processRequest return from handleNewRequest()", (Object[])new Object[0]);
            }
            return;
        } while (null != (rc = this.myTSC.getReadInterface().read(1L, (TCPReadCompletedCallback)callback, false, timeout)));
    }

    private boolean handleNewInformation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing new information: " + this.getVirtualConnection()), (Object[])new Object[0]);
        }
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        if (!this.isPartiallyParsed() && this.getChannel().isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Channel stopped during initial read", (Object[])new Object[0]);
            }
            sc.setHeadersParsed();
            sc.getResponse().setVersion(VersionValues.V10);
            this.sendErrorMessage(StatusCodes.UNAVAILABLE);
            return true;
        }
        boolean completed = false;
        if (this.isDirectHttp2Link(this.switchedVC)) {
            return false;
        }
        try {
            completed = sc.parseMessage();
        }
        catch (UnsupportedMethodException meth) {
            sc.setHeadersParsed();
            this.sendErrorMessage(StatusCodes.NOT_IMPLEMENTED);
            this.setPartiallyParsed(false);
            return true;
        }
        catch (UnsupportedProtocolVersionException ver) {
            sc.setHeadersParsed();
            this.sendErrorMessage(StatusCodes.UNSUPPORTED_VERSION);
            this.setPartiallyParsed(false);
            return true;
        }
        catch (MessageTooLargeException mtle) {
            sc.setHeadersParsed();
            this.sendErrorMessage(StatusCodes.ENTITY_TOO_LARGE);
            this.setPartiallyParsed(false);
            return true;
        }
        catch (MalformedMessageException mme) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parseMessage encountered a MalformedMessageException : " + mme), (Object[])new Object[0]);
            }
            this.handleGenericHNIError(mme, sc);
            return true;
        }
        catch (IllegalArgumentException iae) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parseMessage encountered an IllegalArgumentException : " + iae), (Object[])new Object[0]);
            }
            this.handleGenericHNIError(iae, sc);
            return true;
        }
        catch (Http2Exception h2e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parseMessage encountered an Http2Exception : " + h2e), (Object[])new Object[0]);
            }
            this.myInterface.getLink().close(this.getVirtualConnection(), h2e);
            return true;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"HttpInboundLink.handleNewInformation", (String)"2", (Object)((Object)this));
            this.handleGenericHNIError(t, sc);
            return true;
        }
        this.setPartiallyParsed(!completed);
        if (this.isPartiallyParsed()) {
            sc.setupReadBuffers(sc.getHttpConfig().getIncomingHdrBufferSize(), false);
        }
        return false;
    }

    private void handleGenericHNIError(Throwable t, HttpInboundServiceContextImpl hisc) {
        hisc.setHeadersParsed();
        this.sendErrorMessage(t);
        this.setPartiallyParsed(false);
    }

    private void handleNewRequest() {
        if (!this.isDirectHttp2Link(this.vc)) {
            HttpInboundServiceContextImpl sc = this.getHTTPContext();
            sc.setRequestVersion(sc.getRequest().getVersionValue());
            sc.setRequestMethod(sc.getRequest().getMethodValue());
            sc.getResponseImpl().init(sc);
            ++this.numRequestsProcessed;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received request number " + this.numRequestsProcessed + " on link " + (Object)((Object)this)), (Object[])new Object[0]);
            }
            if (!sc.check100Continue()) {
                return;
            }
        }
        this.handleDiscrimination();
    }

    protected void handleDiscrimination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Discrimination will be called", (Object[])new Object[0]);
        }
        if (this.getChannel().getHttpConfig().runningOnZOS()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Storing buffer size on z/OS", (Object[])new Object[0]);
            }
            this.getVirtualConnection().getStateMap().put("zConfiguredHttpReadBufferSize", this.getChannel().getHttpConfig().getIncomingBodyBufferSize());
        }
        ConnectionReadyCallback oldAppSide = this.getApplicationCallback();
        DiscriminationProcess dp = this.getChannel().getDiscriminationProcess();
        int state = 0;
        try {
            state = dp.discriminate(this.getVirtualConnection(), (Object)this.getHTTPContext().getRequest(), (ConnectionLink)this);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught during discriminate: " + e), (Object[])new Object[0]);
            }
            this.setPartiallyParsed(false);
            this.sendErrorMessage(e);
            return;
        }
        if (1 == state) {
            if (null != oldAppSide && !this.getApplicationCallback().equals(oldAppSide)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received new appside connlink: " + oldAppSide + " vs " + this.getApplicationCallback()), (Object[])new Object[0]);
                }
                if (null == this.appSides) {
                    this.appSides = new LinkedList<ConnectionReadyCallback>();
                    this.appSides.add(oldAppSide);
                    this.appSides.add(this.getApplicationCallback());
                } else if (!this.appSides.contains(this.getApplicationCallback())) {
                    this.appSides.add(this.getApplicationCallback());
                }
            }
            try {
                this.getApplicationCallback().ready(this.getVirtualConnection());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"HttpInboundLink.handleDiscrimination", (String)"1", (Object)((Object)this));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("App side ready() threw exception: " + t), (Object[])new Object[0]);
                }
                if (!this.bIsActive) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Link not active, returning out.", (Object[])new Object[0]);
                    }
                    return;
                }
                if (this.getHTTPContext().headersSent()) {
                    this.getDeviceLink().close(this.getVirtualConnection(), new Exception(t));
                    return;
                }
                this.sendErrorMessage(StatusCodes.UNAVAILABLE);
                return;
            }
        } else {
            this.setPartiallyParsed(false);
            this.sendErrorMessage(new Exception("Discrimination failed"));
        }
    }

    private void sendErrorMessage(Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending a 400 for throwable [" + t + "]"), (Object[])new Object[0]);
        }
        this.sendErrorMessage(StatusCodes.BAD_REQUEST);
    }

    private void sendErrorMessage(StatusCodes code) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending an error page back [code: " + code + "]"), (Object[])new Object[0]);
        }
        try {
            this.getHTTPContext().sendError(code.getHttpError());
        }
        catch (MessageSentException mse) {
            this.close(this.getVirtualConnection(), new Exception("HTTP Message failure"));
        }
    }

    private void handlePipeLining() {
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        WsByteBuffer buffer = sc.returnLastBuffer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Pipelined request found: " + buffer), (Object[])new Object[0]);
        }
        ((HttpServiceContextImpl)sc).clear();
        sc.storeAllocatedBuffer(buffer);
        sc.disableBufferModification();
        EventEngine events = HttpDispatcher.getEventService();
        if (null != events) {
            Event event = events.createEvent(HttpPipelineEventHandler.TOPIC_PIPELINING);
            event.setProperty(CallbackIDs.CALLBACK_HTTPICL.getName(), (Object)this);
            events.postEvent(event);
        } else {
            this.ready(this.getVirtualConnection());
        }
    }

    public void close(VirtualConnection inVC, Exception e) {
        String upgraded;
        VirtualConnection rc;
        boolean errorState;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close() called: " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        boolean bl = errorState = null != e;
        if (errorState && bTrace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close() in error state, " + e), (Object[])new Object[0]);
        }
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        HttpChannelConfig config = sc.getHttpConfig();
        if (sc.containsLargeMessage()) {
            this.getChannel().getFactory().releaseLargeMessage();
        }
        if (!errorState && !sc.isMessageSent()) {
            try {
                rc = sc.finishResponseMessage(null, this, false);
                if (null == rc) {
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"finishing response msg async", (Object[])new Object[0]);
                    }
                    return;
                }
            }
            catch (MessageSentException mse) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error: message sent exception when flag doesn't agree", (Object[])new Object[0]);
                }
                this.getDeviceLink().close(inVC, (Exception)mse);
                return;
            }
        }
        if (!errorState && this.getChannel().isRunning() && !sc.isIncomingMessageFullyRead()) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Incoming request body never read.", (Object[])new Object[0]);
            }
            try {
                rc = sc.getRequestBodyBuffer(HttpIgnoreBodyCallback.getRef(), false);
                boolean reachedEnd = false;
                while (null != rc) {
                    WsByteBuffer buffer = sc.getRequestBodyBuffer();
                    if (null != buffer) {
                        buffer.release();
                        rc = sc.getRequestBodyBuffer(HttpIgnoreBodyCallback.getRef(), false);
                        continue;
                    }
                    reachedEnd = true;
                    break;
                }
                if (!reachedEnd) {
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close() waiting for body purge callback", (Object[])new Object[0]);
                    }
                    return;
                }
            }
            catch (Exception purgeException) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception purging request body: " + purgeException), (Object[])new Object[0]);
                }
                errorState = true;
            }
        }
        if (this.myInterface.getLink() instanceof H2HttpInboundLinkWrap) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"we're H2, calling that close", (Object[])new Object[0]);
            }
            this.myInterface.getLink().close(inVC, e);
            return;
        }
        if (inVC != null && (upgraded = (String)inVC.getStateMap().get("UpgradedConnection")) != null && !errorState && this.getChannel().isRunning() && upgraded.compareToIgnoreCase("true") == 0) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connection Not closed because Servlet Upgrade detected.", (Object[])new Object[0]);
            }
            return;
        }
        if (!errorState && sc.isPersistent() && this.getChannel().isRunning()) {
            if (config.getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
                config.getDebugLog().log(DebugLog.Level.DEBUG, "Reading for another request", (HttpServiceContext)sc);
            }
            sc.resetStartTime();
            this.myTSC.getWriteInterface().setBuffers(null);
            if (sc.isReadDataAvailable()) {
                this.handlePipeLining();
                return;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reading for another request...", (Object[])new Object[0]);
            }
            if (this.getChannel().getHttpConfig().runningOnZOS()) {
                this.getVirtualConnection().getStateMap().put("HTTPFirstRead", "true");
            }
            sc.clear();
            sc.setReadBuffer(null);
            sc.setupJITRead(config.getIncomingHdrBufferSize());
            this.myTSC.getReadInterface().read(1L, (TCPReadCompletedCallback)HttpICLReadCallback.getRef(), true, config.getPersistTimeout());
        } else {
            block49: {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Closing connection", (Object[])new Object[0]);
                }
                if (this.getChannel().getHttpConfig().shouldAttemptPurgeData()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"attemptPurgeData true, purging the data before closing the connection", (Object[])new Object[0]);
                    }
                    try {
                        sc.setupJITRead(10);
                        this.myTSC.getReadInterface().setBuffer(null);
                        boolean processing = true;
                        while (processing) {
                            long numBytesRead = this.myTSC.getReadInterface().read(0L, 1);
                            WsByteBuffer indivBuffer = this.myTSC.getReadInterface().getBuffer();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Bytes read : " + numBytesRead), (Object[])new Object[0]);
                            }
                            if (numBytesRead <= 0L) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"No data read", (Object[])new Object[0]);
                                }
                                if (indivBuffer != null) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"No data read, releasing any buffer that was allocated", (Object[])new Object[0]);
                                    }
                                    this.myTSC.getReadInterface().setBuffer(null);
                                    indivBuffer.release();
                                }
                                processing = false;
                                continue;
                            }
                            if (indivBuffer != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Found a buffer after the read : " + indivBuffer), (Object[])new Object[0]);
                                }
                                indivBuffer.clear();
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Cleared the buffer, going back to read again, " + indivBuffer), (Object[])new Object[0]);
                                continue;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"No buffer found, assuming we are done", (Object[])new Object[0]);
                            }
                            processing = false;
                        }
                    }
                    catch (IOException purgeException) {
                        WsByteBuffer indivBuffer = this.myTSC.getReadInterface().getBuffer();
                        if (indivBuffer != null) {
                            this.myTSC.getReadInterface().setBuffer(null);
                            indivBuffer.release();
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block49;
                        Tr.debug((TraceComponent)tc, (String)("IOException during purge : " + purgeException), (Object[])new Object[0]);
                    }
                }
            }
            if (config.getDebugLog().isEnabled(DebugLog.Level.INFO)) {
                config.getDebugLog().log(DebugLog.Level.INFO, "Closing connection to client", (HttpServiceContext)sc);
            }
            if (this.myTSC != null) {
                TCPReadRequestContext readInterface;
                TCPWriteRequestContext writeInterface = this.myTSC.getWriteInterface();
                if (writeInterface != null) {
                    writeInterface.setBuffer(null);
                }
                if ((readInterface = this.myTSC.getReadInterface()) != null) {
                    readInterface.setBuffer(null);
                }
            }
            if (this.filterExceptions) {
                this.getDeviceLink().close(inVC, null);
            } else {
                this.getDeviceLink().close(inVC, e);
            }
        }
    }

    public void complete(VirtualConnection inVC) {
        this.close(inVC, null);
    }

    public void error(VirtualConnection inVC, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called on " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        try {
            this.close(inVC, (Exception)t);
        }
        catch (ClassCastException cce) {
            this.close(inVC, new Exception("Problem when finishing response"));
        }
    }

    protected void setFilterCloseExceptions(boolean b) {
        this.filterExceptions = b;
    }

    public HttpObjectFactory getObjectFactory() {
        return this.getChannel().getObjectFactory();
    }

    public boolean isHTTP2UpgradeRequest(Map<String, String> headers) {
        return this.checkIfUpgradeHeaders(headers);
    }

    private boolean checkIfUpgradeHeaders(Map<String, String> headers) {
        if (headers == Collections.EMPTY_MAP) {
            return false;
        }
        boolean connection_upgrade = false;
        boolean upgrade_h2c = false;
        String headerValue = null;
        Set<Map.Entry<String, String>> headerEntrys = headers.entrySet();
        for (Map.Entry<String, String> header : headerEntrys) {
            String name = header.getKey();
            if (name.equalsIgnoreCase(CONSTANT_connection)) {
                headerValue = header.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("connection header found with value: " + headerValue), (Object[])new Object[0]);
                }
                if (headerValue != null && headerValue.equalsIgnoreCase(CONSTANT_connection_value)) {
                    if (connection_upgrade) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"malformed: second connection header found", (Object[])new Object[0]);
                        }
                        return false;
                    }
                    connection_upgrade = true;
                }
            }
            if (!name.equalsIgnoreCase(CONSTANT_upgrade)) continue;
            headerValue = header.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("upgrade header found with value: " + headerValue), (Object[])new Object[0]);
            }
            if (headerValue == null || !headerValue.equalsIgnoreCase(CONSTANT_h2c)) continue;
            if (upgrade_h2c) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"malformed: second upgrade header found", (Object[])new Object[0]);
                }
                return false;
            }
            upgrade_h2c = true;
        }
        return connection_upgrade && upgrade_h2c;
    }

    private boolean checkForH2MagicString(HttpInboundServiceContextImpl isc) {
        WsByteBuffer buffer;
        boolean hasMagicString = false;
        if (this.myTSC == null || this.myTSC.getReadInterface() == null || (buffer = this.myTSC.getReadInterface().getBuffer()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("checkForH2MagicString: returning " + hasMagicString + " due to null read buffer"));
            }
            return hasMagicString;
        }
        buffer = buffer.duplicate();
        buffer.flip();
        if (buffer.remaining() >= 24) {
            byte[] arr = new byte[24];
            buffer.get(arr);
            hasMagicString = Arrays.equals(arr, HttpConstants.HTTP2PrefaceBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkForH2MagicString: returning " + hasMagicString));
        }
        buffer.release();
        return hasMagicString;
    }
}

