/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;

public final class Utils {
    private Utils() {
        throw new RuntimeException();
    }

    public static BundleContext getBundleContext(Map<?, ?> env, Class<?> namingClass) {
        return Utils.doPrivileged(() -> Utils.doGetBundleContext(env, namingClass));
    }

    private static BundleContext doGetBundleContext(Map<?, ?> env, Class<?> namingClass) {
        BundleContext result;
        Object bc;
        Object v0 = bc = env == null ? null : env.get("osgi.service.jndi.bundleContext");
        if (bc != null && bc instanceof BundleContext) {
            result = bc;
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = Utils.getBundleContext(cl);
        }
        if (result == null) {
            int i;
            StackFinder finder = new StackFinder();
            Class<?>[] classStack = finder.getClassContext();
            for (i = classStack.length - 1; i >= 0 && !namingClass.isAssignableFrom(classStack[i]); --i) {
            }
            ++i;
            while (i < classStack.length && result == null) {
                result = Utils.getBundleContext(classStack[i].getClassLoader());
                ++i;
            }
        }
        return result;
    }

    private static BundleContext getBundleContext(ClassLoader cl2) {
        ClassLoader cl = cl2;
        BundleContext result = null;
        while (result == null && cl != null) {
            if (cl instanceof BundleReference) {
                Bundle b = ((BundleReference)cl).getBundle();
                result = b.getBundleContext();
                if (result != null) continue;
                try {
                    b.start();
                    result = b.getBundleContext();
                }
                catch (BundleException bundleException) {}
                break;
            }
            if (cl == null) continue;
            cl = cl.getParent();
        }
        return result;
    }

    public static String getSystemProperty(String key, String defaultValue) {
        return Utils.doPrivileged(() -> System.getProperty(key, defaultValue));
    }

    public static Hashtable<?, ?> toHashtable(Map<?, ?> map) {
        Hashtable<Object, Object> env = map instanceof Hashtable ? (Hashtable)map : (map == null ? new Hashtable() : new Hashtable(map));
        return env;
    }

    public static <T> T doPrivileged(Supplier<T> action) {
        if (System.getSecurityManager() != null) {
            return (T)AccessController.doPrivileged(action::get);
        }
        return action.get();
    }

    public static <T, E extends Exception> T doPrivilegedE(Callable<T, E> action) throws E {
        if (System.getSecurityManager() != null) {
            try {
                return (T)AccessController.doPrivileged(action::call);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return action.call();
    }

    public static <U, V> Iterator<V> map(Iterator<U> iterator, Function<U, V> mapper) {
        return new MappedIterator<U, V>(iterator, mapper);
    }

    private static class MappedIterator<U, V>
    implements Iterator<V> {
        private final Iterator<U> iterator;
        private final Function<U, V> mapper;
        private V nextElement;
        private boolean hasNext;

        public MappedIterator(Iterator<U> iterator, Function<U, V> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
            this.nextMatch();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            return this.nextMatch();
        }

        private V nextMatch() {
            V oldMatch = this.nextElement;
            while (this.iterator.hasNext()) {
                V o = this.mapper.apply(this.iterator.next());
                if (o == null) continue;
                this.hasNext = true;
                this.nextElement = o;
                return oldMatch;
            }
            this.hasNext = false;
            return oldMatch;
        }
    }

    private static class StackFinder
    extends SecurityManager {
        private StackFinder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }

    public static interface Callable<V, E extends Exception> {
        public V call() throws E;
    }
}

