/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.X509KeyManager;

public class CertMappingKeyManager
implements X509KeyManager,
KeyManagerExtendedInfo {
    private static final TraceComponent tc = Tr.register(CertMappingKeyManager.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    public static final String PROTOCOL_HTTPS_CERT_MAPPING_FILE = "com.ibm.ssl.cert.mapping.file";
    public static final String PROTOCOL_HTTPS_CERT_DEFAULT_LABEL = "com.ibm.ssl.cert.default.label";
    private static final String PROTOCOL_HTTPS_CERT_TAG = "SSLServerCert";
    private static final String SINGLE_QUOTE_STRING = "'";
    private static final String DOUBLE_QUOTE_STRING = "\"";
    private Properties certMapping;
    private Properties customProperties;
    private String certDefaultLabel;
    private X509KeyManager defaultX509KeyManager;

    public CertMappingKeyManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.certMapping = new Properties();
        this.certDefaultLabel = null;
        this.defaultX509KeyManager = null;
        this.parseSSLCertFile();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return null;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.certMapping.values().toArray(new String[this.certMapping.size()]);
    }

    @Override
    public String chooseServerAlias(String ipAddress, Principal[] issuers, Socket socket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chooseServerAlias", (Object[])new Object[]{ipAddress, issuers, socket});
        }
        String alias = null;
        Map<String, Object> connectionInfo = JSSEHelper.getInstance().getInboundConnectionInfo();
        if (connectionInfo != null) {
            String tmpIpAddress = (String)connectionInfo.get("com.ibm.ssl.certMappingHost");
            alias = this.certMapping.getProperty(tmpIpAddress, this.certDefaultLabel);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("chooseServerAlias: " + alias));
        }
        return alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return null;
    }

    @Override
    public void setCustomProperties(Properties customProperties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCustomProperties", (Object[])new Object[]{customProperties});
        }
        this.customProperties = customProperties;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCustomProperties");
        }
    }

    @Override
    public void setSSLConfig(Properties config) {
    }

    @Override
    public void setDefaultX509KeyManager(X509KeyManager defaultX509KeyManager) {
        this.defaultX509KeyManager = defaultX509KeyManager;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
    }

    @Override
    public void setKeyStoreServerAlias(String serverAlias) {
    }

    @Override
    public void setKeyStoreClientAlias(String clientAlias) {
    }

    public String getProperty(String name) {
        String property = null;
        if (this.customProperties != null) {
            property = this.customProperties.getProperty(name);
        }
        if (property == null) {
            property = SSLConfigManager.getInstance().getGlobalProperty(name);
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSSLCertFile() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseSSLCertFile", (Object[])new Object[0]);
        }
        String fileName = null;
        String lineRead = null;
        BufferedReader bufferReader = null;
        this.certDefaultLabel = this.getProperty(PROTOCOL_HTTPS_CERT_DEFAULT_LABEL);
        try {
            fileName = this.getProperty(PROTOCOL_HTTPS_CERT_MAPPING_FILE);
            if (fileName != null && 0 < fileName.length()) {
                bufferReader = new BufferedReader(new FileReader(fileName));
                lineRead = bufferReader.readLine();
                while (lineRead != null) {
                    this.extractSSLServerCert(lineRead.trim());
                    lineRead = bufferReader.readLine();
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"parseSSLCertFile", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error parsing file; " + e), (Object[])new Object[0]);
            }
        }
        finally {
            if (null != bufferReader) {
                try {
                    bufferReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseSSLCertFile");
        }
    }

    private void extractSSLServerCert(String lineRead) {
        String ipAddressString;
        char delimeterChar;
        String certLabelString;
        String tmpString;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("extractSSLServerCert: " + lineRead), (Object[])new Object[0]);
        }
        if (lineRead.startsWith(PROTOCOL_HTTPS_CERT_TAG) && ((tmpString = lineRead.substring(PROTOCOL_HTTPS_CERT_TAG.length()).trim()).startsWith(SINGLE_QUOTE_STRING) || tmpString.startsWith(DOUBLE_QUOTE_STRING)) && (certLabelString = tmpString.substring(1, tmpString.lastIndexOf(delimeterChar = tmpString.charAt(0)))) != null && certLabelString.length() != 0 && (ipAddressString = tmpString.substring(tmpString.lastIndexOf(delimeterChar) + 1).trim()) != null && ipAddressString.length() != 0) {
            this.certMapping.setProperty(ipAddressString, certLabelString);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractSSLServerCert");
        }
    }
}

