/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.Element;

final class Bucket<K, V> {
    Element<K, V> ivHead;
    private int ivNumElements;

    Bucket() {
    }

    Element<K, V> findByKey(K key) {
        Element<K, V> e = this.ivHead;
        while (e != null) {
            if (key.equals(e.ivKey)) {
                return e;
            }
            e = e.ivNext;
        }
        return null;
    }

    Element<K, V> replaceByKey(K key, V object) {
        Element<K, V> element = this.removeByKey(key);
        this.addByKey(key, object);
        return element;
    }

    void addByKey(K key, V object) {
        Element<K, V> newElement = new Element<K, V>(key, object);
        newElement.ivNext = this.ivHead;
        this.ivHead = newElement;
        ++this.ivNumElements;
    }

    Element<K, V> removeByKey(K key) {
        Element<K, V> previous = null;
        Element<K, V> e = this.ivHead;
        while (e != null) {
            if (key.equals(e.ivKey)) {
                if (previous == null) {
                    this.ivHead = e.ivNext;
                } else {
                    previous.ivNext = e.ivNext;
                }
                --this.ivNumElements;
                return e;
            }
            previous = e;
            e = e.ivNext;
        }
        return null;
    }

    public int size() {
        return this.ivNumElements;
    }

    void clear() {
        this.ivNumElements = 0;
        this.ivHead = null;
    }
}

