/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;

class SibRaConnectionRequestInfo
implements ConnectionRequestInfo,
FFDCSelfIntrospectable,
Cloneable {
    private final String _userName;
    private final String _password;
    private final Subject _subject;
    private final Map _connectionProperties;
    private SICoreConnection _coreConnection;
    private int _requestCounter;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnectionRequestInfo.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();

    SibRaConnectionRequestInfo(String userName, String password, Map connectionProperties) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo", (Object)new Object[]{userName, password == null ? null : "*****", connectionProperties});
        }
        this._userName = userName;
        this._password = password;
        this._subject = null;
        this._requestCounter = 0;
        this._connectionProperties = new HashMap(connectionProperties);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo");
        }
    }

    SibRaConnectionRequestInfo(Subject subject, Map connectionProperties) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo", (Object)new Object[]{SibRaUtils.subjectToString(subject), connectionProperties});
        }
        this._userName = null;
        this._password = null;
        this._subject = subject;
        this._requestCounter = 0;
        this._connectionProperties = new HashMap(connectionProperties);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionRequestInfo");
        }
    }

    String getUserName() {
        return this._userName;
    }

    String getPassword() {
        return this._password;
    }

    Subject getSubject() {
        return this._subject;
    }

    Map getConnectionProperties() {
        return this._connectionProperties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SibRaConnectionRequestInfo) {
            SibRaConnectionRequestInfo otherRequestInfo = (SibRaConnectionRequestInfo)other;
            if (this._requestCounter != otherRequestInfo._requestCounter) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._userName, otherRequestInfo._userName)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._password, otherRequestInfo._password)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._subject, otherRequestInfo._subject)) {
                return false;
            }
            if (SibRaUtils.objectsNotEqual(this._connectionProperties, otherRequestInfo._connectionProperties)) {
                return false;
            }
            return this._coreConnection == null || otherRequestInfo._coreConnection == null || this._coreConnection.isEquivalentTo(otherRequestInfo._coreConnection);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = SibRaUtils.objectHashCode(this._userName);
        hashCode = SibRaUtils.addObjectToHashCode(hashCode, this._password);
        hashCode = SibRaUtils.addObjectToHashCode(hashCode, this._subject);
        hashCode = SibRaUtils.addObjectToHashCode(hashCode, this._connectionProperties);
        return hashCode += this._requestCounter;
    }

    public String toString() {
        StringBuffer buffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(buffer, "userName", this._userName);
        SibRaUtils.addPasswordFieldToString(buffer, "password", this._password);
        SibRaUtils.addFieldToString(buffer, "subject", SibRaUtils.subjectToString(this._subject));
        SibRaUtils.addFieldToString(buffer, "connectionProperties", this._connectionProperties);
        SibRaUtils.addFieldToString(buffer, "coreConnection", this._coreConnection);
        SibRaUtils.addFieldToString(buffer, "requestCounter", this._requestCounter);
        SibRaUtils.endToString(buffer);
        return buffer.toString();
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    void setCoreConnection(SICoreConnection coreConnection) {
        this._coreConnection = coreConnection;
    }

    SICoreConnection getCoreConnection() {
        return this._coreConnection;
    }

    public void incrementRequestCounter() {
        ++this._requestCounter;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo.clone", (String)"1:371:1.13", (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)e);
            }
            SibTr.error((TraceComponent)TRACE, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo.clone", "1:379:1.13"});
            throw new SIErrorException(NLS.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo.clone", "1:386:1.13", e}, null), (Throwable)e);
        }
        return clone;
    }
}

