/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyHttpObjectAggregator
extends SimpleChannelInboundHandler<HttpObject> {
    private long maxContentLength = Long.MAX_VALUE;
    private static final AttributeKey<HttpRequest> CURRENT_REQUEST;
    private static final AttributeKey<CompositeByteBuf> COMPOSITE_CONTENT;
    static final long serialVersionUID = 2594643307032906836L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public LibertyHttpObjectAggregator(long maxContentLength) {
        if (maxContentLength <= 0L) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer.");
        }
        this.maxContentLength = maxContentLength;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg.decoderResult().isFinished() && msg.decoderResult().isFailure()) {
            this.exceptionCaught(ctx, msg.decoderResult().cause());
        }
        if (msg instanceof FullHttpRequest) {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg, (int)1));
            ctx.channel().attr(COMPOSITE_CONTENT).set(null);
            ctx.channel().attr(CURRENT_REQUEST).set(null);
            return;
        }
        if (msg instanceof HttpRequest) {
            String value;
            HttpRequest request = (HttpRequest)msg;
            ctx.channel().attr(CURRENT_REQUEST).set((Object)request);
            CompositeByteBuf content = ctx.alloc().compositeBuffer();
            ctx.channel().attr(COMPOSITE_CONTENT).set((Object)content);
            String string = value = request.method().name().equals("POST") ? request.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH) : null;
            if (value != null) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.http.netty.pipeline.inbound.LibertyHttpObjectAggregator", (String)"67", (Object)((Object)this), (Object[])new Object[]{ctx, msg});
                    String longContentLengthNotSupportMsg = "Only POST request with integer content-length is supported at this time.";
                    throw new IllegalArgumentException(longContentLengthNotSupportMsg);
                }
            }
        } else if (msg instanceof HttpContent) {
            CompositeByteBuf content = (CompositeByteBuf)ctx.channel().attr(COMPOSITE_CONTENT).get();
            if (content != null) {
                HttpContent httpContent = (HttpContent)msg;
                int sizeOfCurrentChunk = httpContent.content().readableBytes();
                if ((long)sizeOfCurrentChunk > this.maxContentLength || (long)(content.readableBytes() + sizeOfCurrentChunk) > this.maxContentLength) {
                    ReferenceCountUtil.release((Object)msg);
                    throw new TooLongFrameException("Content length exceeded max of " + this.maxContentLength + " bytes.");
                }
                content.addComponent(true, httpContent.content().retain());
                if (msg instanceof LastHttpContent) {
                    HttpRequest request = (HttpRequest)ctx.channel().attr(CURRENT_REQUEST).get();
                    DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), (ByteBuf)content, request.headers(), ((LastHttpContent)msg).trailingHeaders());
                    ctx.fireChannelRead((Object)fullRequest);
                    ctx.channel().attr(COMPOSITE_CONTENT).set(null);
                    ctx.channel().attr(CURRENT_REQUEST).set(null);
                }
            }
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().attr(COMPOSITE_CONTENT).set(null);
        ctx.channel().attr(CURRENT_REQUEST).set(null);
        super.exceptionCaught(ctx, cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(COMPOSITE_CONTENT).set(null);
        ctx.channel().attr(CURRENT_REQUEST).set(null);
        super.channelInactive(ctx);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.inbound.LibertyHttpObjectAggregator", LibertyHttpObjectAggregator.class, null, null);
        CURRENT_REQUEST = AttributeKey.valueOf((String)"currentRequest");
        COMPOSITE_CONTENT = AttributeKey.valueOf((String)"compositeContent");
    }
}

